/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.graphic.transacao.cartao;

import java.util.concurrent.TimeUnit;
import lib.ValidadorCpfCnpj;
import lib.type.VeSMethod;
import vespague.automation.VeSPagueClientToAutomation;
import vespague.client.device.VeSPaguePinpad;
import vespague.client.graphic.VeSPagueCampoBaseTextoGenerico;
import vespague.client.graphic.VeSPagueClient;
import vespague.client.graphic.VeSPagueNoFocusChangeSign;
import vespague.client.lib.graphic.window.ClientWindowProgress;
import vespague.client.lib.graphic.window.VBIWindowMessage;
import vespague.common.VeSPagueClientUtil;
import vespague.exception.VeSPagueClientException;
import vespague.exception.VeSPagueProcessamentoException;
import vespague.structure.VBIMensagem;

/*
 * Exception performing whole class analysis ignored.
 */
public class VSPagueCampoCartaoFidelidadeCPF
extends VeSPagueCampoBaseTextoGenerico {
    public VSPagueCampoCartaoFidelidadeCPF() {
        super(117, 0, VSPagueCampoCartaoFidelidadeCPF.getMaskDefault(), "CPF");
    }

    private static String getMaskDefault() {
        return "###.###.###-##";
    }

    protected String FixedValueGet() {
        return this.ParametersGet().TransacaoFidelidadeGet() != null ? this.ParametersGet().TransacaoFidelidadeGet().is_cpf_portador : null;
    }

    protected void DadoSet(String dado) {
        if (this.ParametersGet().TransacaoFidelidadeGet() != null) {
            this.ParametersGet().TransacaoFidelidadeGet().is_cpf_portador = dado;
        }
    }

    public boolean isCollect() {
        if (this.io_transaction_manager.DatastoreGet().isColetaCartaoFidelidadeCodigoFuncionario()) {
            return this.ParametersGet().TransacaoFidelidadeGet() != null && this.ParametersGet().TransacaoFidelidadeGet().is_codigo_funcionario != null && !this.ParametersGet().TransacaoFidelidadeGet().is_codigo_funcionario.isEmpty() && this.io_transaction_manager.DatastoreGet().isColetaCartaoFidelidadeCPF();
        }
        return this.io_transaction_manager.DatastoreGet().isColetaCartaoFidelidadeCPF();
    }

    public void PreConsistenciaFazer() throws VeSPagueProcessamentoException {
        this.setVisible(VeSPagueClient.VISIBLE ? this.isCollect() : false);
        if (this.isCollect()) {
            if (this.FixedValueGet() != null) {
                this.consisteNumeroCpf(this.FixedValueGet());
            } else if (!this.isVisible()) {
                this.DadoColetar("transacao_fidelidade_cpf_portador", null);
                this.transferFocus();
            }
        }
        super.PreConsistenciaFazer();
    }

    public final void DadoConsistir() throws VeSPagueProcessamentoException, VeSPagueNoFocusChangeSign {
        String numeroCPF = this.getTextTrim().replaceAll("[^0-9]", "");
        if (!numeroCPF.isEmpty()) {
            this.consisteNumeroCpf(numeroCPF);
            super.DadoConsistir();
        } else {
            this.coletaPinpadModoGrafico();
        }
    }

    public void DadoColetar(String keyword, String mascara) throws VeSPagueProcessamentoException {
        try {
            boolean coletaFinalizada = false;
            while (!coletaFinalizada) {
                VeSPagueClientToAutomation pacoteAutomacaoSend = new VeSPagueClientToAutomation("");
                VeSPagueClientToAutomation pacoteAutomacaoReceive = new VeSPagueClientToAutomation("");
                pacoteAutomacaoSend.automacao_coleta_retorno = VeSPagueClientUtil.RETURN_CODE_SUCESS_CONFIRMATION;
                pacoteAutomacaoSend.automacao_coleta_mensagem = new String[]{this.getName()};
                pacoteAutomacaoSend.automacao_coleta_tipo = "N";
                pacoteAutomacaoSend.automacao_coleta_mascara = VSPagueCampoCartaoFidelidadeCPF.getMaskDefault();
                if (keyword != null) {
                    if (!keyword.equals(this.getName())) {
                        pacoteAutomacaoSend.automacao_coleta_palavra_chave = keyword;
                    } else {
                        LOGGER.warn("Campo \"" + this.getClass().getCanonicalName() + "\" est\u00e1 passando novamente o t\u00edtulo do campo ao inv\u00e9s da palavra-chave");
                    }
                }
                this.io_transaction_manager.io_client_to_server.io_client_automation_interaction.Send(pacoteAutomacaoSend, Integer.valueOf((int)TimeUnit.SECONDS.toMillis(120L)), true, null);
                pacoteAutomacaoReceive = this.io_transaction_manager.io_client_to_server.io_client_automation_interaction.RespostaAplicacaoComercialConsistir(pacoteAutomacaoSend.automacao_coleta_sequencial, VeSPagueClientUtil.RETURN_CODE_SUCESS_CONFIRMATION);
                if (pacoteAutomacaoReceive.automacao_coleta_informacao != null && !pacoteAutomacaoReceive.automacao_coleta_informacao.isEmpty()) {
                    this.setEnabled(false);
                    this.setText(pacoteAutomacaoReceive.automacao_coleta_informacao);
                    try {
                        this.DadoConsistir();
                        coletaFinalizada = true;
                        continue;
                    }
                    catch (VeSPagueNoFocusChangeSign ex) {
                        throw new VeSPagueProcessamentoException("Transa\u00e7\u00e3o cancelada: Dados inv\u00e1lidos recebidos pela aplica\u00e7\u00e3o comercial");
                    }
                }
                try {
                    coletaFinalizada = this.coletaPinpad();
                    if (coletaFinalizada) continue;
                    coletaFinalizada = this.continuacaoTransacaoFidelidade();
                }
                catch (Exception ex) {
                    throw new VeSPagueClientException((Throwable)ex);
                }
            }
        }
        catch (VeSPagueClientException ex) {
            throw new VeSPagueProcessamentoException((Throwable)ex);
        }
    }

    private boolean coletaPinpad() throws Exception {
        VeSPaguePinpad pinpad = this.io_transaction_manager.io_client.PinpadGet();
        if (pinpad != null && pinpad.is_pinpad_especificacao_versao.charAt(0) > '1') {
            int minDigitos = 0;
            int maxDigitos = 11;
            int timeout = 60;
            String dadoColetado = null;
            this.mensagemInformacao("Coletando CPF para acumulo de pontos");
            while (dadoColetado == null) {
                try {
                    dadoColetado = pinpad.servicoColetar("0007", minDigitos, maxDigitos, timeout);
                }
                catch (Exception e) {
                    dadoColetado = null;
                }
                if (dadoColetado != null) {
                    try {
                        if (dadoColetado.length() <= 0 || ValidadorCpfCnpj.cpfCnpjValidar((String)dadoColetado).isEmpty()) continue;
                        this.setText(dadoColetado);
                        return true;
                    }
                    catch (Exception ex) {
                        dadoColetado = null;
                        pinpad.PP_Display("CPF INVALIDO");
                        if (VeSPagueClient.VISIBLE) {
                            VBIMensagem mensagem = new VBIMensagem(2, VBIWindowMessage.OK_OPTIONS);
                            mensagem.setOpcaoPadrao((Object)VBIWindowMessage.OK_OPTIONS);
                            mensagem.setMensagem((Object)"CPF inv\u00e1lido, tente novamente");
                            this.mensagemOperador(mensagem);
                            continue;
                        }
                        VeSPagueClientToAutomation automationSend = new VeSPagueClientToAutomation("");
                        automationSend.automacao_coleta_retorno = VeSPagueClientUtil.RETURN_CODE_SUCESS_CONFIRMATION;
                        automationSend.automacao_coleta_mensagem = new String[]{"CPF inv\u00e1lido, tente novamente"};
                        this.io_transaction_manager.io_client_to_server.io_client_automation_interaction.Send(automationSend, Integer.valueOf(0), true, null);
                        this.io_transaction_manager.io_client_to_server.io_client_automation_interaction.RespostaAplicacaoComercialConsistir(automationSend.automacao_coleta_sequencial, VeSPagueClientUtil.RETURN_CODE_SUCESS_CONFIRMATION);
                        continue;
                    }
                }
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void coletaPinpadModoGrafico() throws VeSPagueNoFocusChangeSign, VeSPagueProcessamentoException {
        if (this.isVisible()) {
            ClientWindowProgress window = null;
            try {
                window = new ClientWindowProgress(this.ParametersGet().is_tipo, null, "Coletando CPF para acumulo de pontos", false, this.isVisible());
                VeSMethod metodoColetaInformacoesPinpad = new VeSMethod((Object)this, "coletaPinpad", null);
                boolean coletouPinpad = false;
                while (!coletouPinpad) {
                    try {
                        coletouPinpad = (Boolean)window.MethodExecute(metodoColetaInformacoesPinpad, null);
                        if (coletouPinpad) continue;
                        window.ProgressMessageSet("Solicite ao portador a continua\u00e7\u00e3o da transa\u00e7\u00e3o sem pontua\u00e7\u00e3o no pinpad");
                        window.VisibleSet(this.isVisible());
                        coletouPinpad = (Boolean)window.MethodExecute(new VeSMethod((Object)this, "continuacaoTransacaoFidelidade", null), null);
                        if (coletouPinpad) continue;
                        VeSPagueClient veSPagueClient = this.io_transaction_manager.io_client;
                        veSPagueClient.getClass();
                        new VeSPagueClient.V.PagueClientWindowException(veSPagueClient, (Throwable)new VeSPagueProcessamentoException("Cliente optou por pontuar, digite o CPF"));
                        throw new VeSPagueNoFocusChangeSign();
                    }
                    catch (Exception e) {
                        throw new VeSPagueProcessamentoException((Throwable)e);
                    }
                }
            }
            finally {
                window.WindowClose();
            }
        }
    }

    private void mensagemInformacao(String as_message) {
        if (!this.isVisible()) {
            VeSPagueClientToAutomation sendAutomacao = new VeSPagueClientToAutomation("");
            sendAutomacao.automacao_coleta_retorno = VeSPagueClientUtil.RETURN_CODE_SUCESS_CONFIRMATION;
            sendAutomacao.automacao_coleta_mensagem = new String[]{as_message};
            try {
                this.io_transaction_manager.io_client_to_server.io_client_automation_interaction.Send(sendAutomacao, Integer.valueOf(0), true, null);
                this.io_transaction_manager.io_client_to_server.io_client_automation_interaction.RespostaAplicacaoComercialConsistir(sendAutomacao.automacao_coleta_sequencial, VeSPagueClientUtil.RETURN_CODE_SUCESS_CONFIRMATION);
            }
            catch (Exception ex) {
                VeSPagueClient veSPagueClient = this.io_transaction_manager.io_client;
                veSPagueClient.getClass();
                new VeSPagueClient.V.PagueClientWindowException(veSPagueClient, (Throwable)ex);
                this.io_transaction_manager.io_wn_processar.TodosComponentesRemover();
            }
        }
    }

    private boolean continuacaoTransacaoFidelidade() throws VeSPagueProcessamentoException {
        block5: {
            VeSPaguePinpad pinpad;
            if (this.getTextTrim().replaceAll("[^0-9]", "").length() == 0 && this.io_transaction_manager.DatastoreGet().isPerguntaContinuarSemPontuacaoPinpad() && (pinpad = this.io_transaction_manager.io_client.PinpadGet()) != null && pinpad.Connected()) {
                block6: {
                    try {
                        this.mensagemInformacao("Solicite ao portador a continua\u00e7\u00e3o da transa\u00e7\u00e3o sem pontua\u00e7\u00e3o no pinpad");
                        pinpad.PP_Display("DESEJA CONTINUAR SEM PONTUAR?");
                        byte[] x = new byte[]{-1};
                        if (x[0] == 13 || x[0] == 27) break block5;
                        x[0] = pinpad.PP_GetKeyPress();
                        if (x[0] != 13) break block6;
                        pinpad.PP_Display("Processando ...");
                        this.ParametersGet().TransacaoFidelidadeRemove(0);
                        LOGGER.info("Cliente optou por n\u00e3o pontuar na transacao");
                        return true;
                    }
                    catch (Exception e) {
                        throw new VeSPagueProcessamentoException((Throwable)e);
                    }
                }
                pinpad.PP_Display("Processando ...");
                return false;
            }
        }
        if (this.ParametersGet().TransacaoFidelidadeGet() != null) {
            this.ParametersGet().TransacaoFidelidadeRemove(0);
        }
        return true;
    }

    private void consisteNumeroCpf(String cpf) throws VeSPagueProcessamentoException {
        String numeroCPF = cpf.replaceAll("[^0-9]", "");
        try {
            ValidadorCpfCnpj.cpfCnpjValidar((String)numeroCPF);
        }
        catch (IllegalArgumentException ex) {
            throw new VeSPagueProcessamentoException("Campo CPF inv\u00e1lido.", 30106);
        }
    }
}

