/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.graphic.transacao.cartao;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import vespague.client.graphic.VeSPagueClient;
import vespague.client.graphic.VeSPagueListaBaseGenerica;
import vespague.common.VeSPagueClientUtil;
import vespague.exception.VeSPagueProcessamentoException;
import vespague.structure.VSPagueCartaoBandeiraAid;
import vespague.structure.VeSPagueConfiguracaoPesquisar;
import vespague.structure.VeSPagueTransacao;

public class VSPagueListaTransacaoTipoCartao
extends VeSPagueListaBaseGenerica {
    public VSPagueListaTransacaoTipoCartao() {
        super("Tipo do Cart\u00e3o");
    }

    public void PreConsistenciaFazer() throws VeSPagueProcessamentoException {
        this.setHorizontalScrollBarPolicy(31);
        this.io_lt_list.setListData((Object[])this.TransacaoTipoCartaoColetaVerificar());
        if (this.isCollect()) {
            if (!VeSPagueClient.VISIBLE) {
                if (this.FixedValueGet() == null) {
                    this.DadoColetar("transacao_tipo_cartao", null);
                } else {
                    this.FixedValueSet();
                }
            } else {
                super.PreConsistenciaFazer();
            }
        }
    }

    protected Object FixedValueGet() {
        return this.ParametersGet().TransacaoCartaoGet().is_tipo;
    }

    protected void DadoSet(String as_dado) {
        this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_tipo = as_dado;
        if (as_dado != null) {
            this.setTransactionTypeWhenVoucher(this.io_transaction_manager.TransactionGet());
            try {
                this.TipoCartaoFiltrar(this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_tipo);
            }
            catch (VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void setTransactionTypeWhenVoucher(VeSPagueTransacao transaction) {
        if (transaction.TransacaoCartaoGet() != null) {
            if (VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_VOUCHER.equals(transaction.TransacaoCartaoGet().is_tipo)) {
                transaction.TransacaoCartaoGet().setTipoCartaoOriginal(VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_VOUCHER);
                transaction.TransacaoCartaoGet().is_tipo = VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_DEBITO;
                String[] aidsVoucher = this.getAidsVoucher();
                String[] aidsArray = Optional.of(aidsVoucher).orElseGet(() -> VeSPagueClientUtil.AID_ESTENDIDO_MASTERCARD.toArray(new String[0]));
                List<String> aidsList = Arrays.asList(aidsArray);
                this.io_transaction_manager.DatastoreGet().setAidsPrimeiraLeituraPinpad(aidsList);
            } else {
                String[] aids = transaction.TransacaoCartaoGet().getTipoCartaoOriginal() != null ? this.getAidsDebitoIgnorandoAidsVoucher() : this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().getAidsEspeciais();
                String[] aidsArray = Optional.ofNullable(aids).orElseGet(() -> VeSPagueClientUtil.AID_ESTENDIDO_MASTERCARD.toArray(new String[0]));
                List<String> aidsList = Arrays.asList(aidsArray);
                this.io_transaction_manager.DatastoreGet().setAidsPrimeiraLeituraPinpad(aidsList);
            }
        }
    }

    private String[] getAidsVoucher() {
        VSPagueCartaoBandeiraAid[] aids = this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().io_cfg_application_identifier;
        return (String[])Arrays.stream(aids).filter(VSPagueCartaoBandeiraAid::isVoucher).map(VSPagueCartaoBandeiraAid::ApplicationIdentifierGet).toArray(String[]::new);
    }

    private String[] getAidsDebitoIgnorandoAidsVoucher() {
        List<String> aidsVoucher = Arrays.asList(this.getAidsVoucher());
        VSPagueCartaoBandeiraAid[] aids = this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().io_cfg_application_identifier;
        return Arrays.stream(aids).filter(aid -> aid.TipoCartaoGet().equals(VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_DEBITO) && !aidsVoucher.contains(aid.ApplicationIdentifierGet())).map(VSPagueCartaoBandeiraAid::ApplicationIdentifierGet).collect(Collectors.collectingAndThen(Collectors.toList(), list -> list.isEmpty() ? null : list.toArray(new String[0])));
    }

    public boolean isCollect() {
        return this.io_lt_list.getModel().getSize() >= 1;
    }

    private final String[] TransacaoTipoCartaoColetaVerificar() {
        return this.io_transaction_manager.DatastoreGet().TransacaoTipoCartaoColetaVerificar();
    }

    private final void TipoCartaoFiltrar(String as_tipo_cartao) throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        this.io_transaction_manager.DatastoreGet().TipoCartaoFiltrar(as_tipo_cartao);
    }
}

