/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.graphic.transacao.cartao.produto;

import java.math.BigDecimal;
import lib.VeSUtil;
import lib.type.VeSDecimal;
import lib.type.VeSNumber;
import lib.type.VeSString;
import vespague.automation.VeSPagueClientToAutomation;
import vespague.client.graphic.VeSPagueClient;
import vespague.client.graphic.VeSPagueListaBaseGenerica;
import vespague.client.graphic.transacao.cartao.produto.VSPagueListaProdutoPrincipal;
import vespague.client.graphic.transacao.cartao.produto.VSPagueListaProdutoSecundario;
import vespague.client.lib.graphic.window.VBIWindowMessage;
import vespague.common.VeSPagueClientUtil;
import vespague.exception.VeSPagueClientException;
import vespague.exception.VeSPagueProcessamentoException;
import vespague.structure.VeSPagueProdutoVendaItem;

public class VSPagueListaOutroProduto
extends VeSPagueListaBaseGenerica {
    private static final String QUESTION_YES = "1-Sim";
    private static final String QUESTION_NO = "2-N\u00e3o";
    public static final int WIDTH_DEFAULT = 95;
    public static final String NAME_DEFAULT = "Adicionar mais produtos?";

    public VSPagueListaOutroProduto() {
        super(95, NAME_DEFAULT);
    }

    protected void DadoSet(String as_dado) {
    }

    public void PreConsistenciaFazer() throws VeSPagueProcessamentoException {
        boolean lb_coletar = this.isCollect();
        this.setVisible(VeSPagueClient.VISIBLE && lb_coletar);
        this.io_lt_list.setListData((Object[])new String[]{QUESTION_YES, QUESTION_NO});
        if (lb_coletar && this.getProdutoAtual().ValorUnitarioColetarGet() == null) {
            this.setHorizontalScrollBarPolicy(31);
            if (this.isVisible()) {
                if (this.io_lt_list.getModel().getSize() >= 1) {
                    this.io_lt_list.setSelectedIndex(0);
                }
                super.PreConsistenciaFazer();
            } else {
                this.DadoColetar(null, null);
            }
        } else if (this.io_transaction_manager.TransactionGet().io_produto_servico != null && this.getProdutoAtual().ValorUnitarioColetarGet() != null && this.getProdutoAtual().ValorUnitarioColetarGet().booleanValue()) {
            this.setVisible(false);
            if (this.ValorTransacaoVerificar()) {
                this.io_lt_list.setSelectedIndex(0);
                super.PreConsistenciaFazer();
            } else {
                String ls_titulo = "Confirma itens Adicionados";
                String ls_mensagem = "Voc\u00ea adicionou os produtos abaixo:\r\n";
                VeSPagueProdutoVendaItem[] veSPagueProdutoVendaItemArray = this.io_transaction_manager.TransactionGet().io_produto_servico;
                int n = this.io_transaction_manager.TransactionGet().io_produto_servico.length;
                int n2 = 0;
                while (n2 < n) {
                    VeSPagueProdutoVendaItem lo_venda_item = veSPagueProdutoVendaItemArray[n2];
                    ls_mensagem = String.valueOf(ls_mensagem) + VeSString.Align((String)lo_venda_item.ProdutoItemGet(), (int)16, (int)1, (String)" |") + VeSString.Align((String)("R$ " + VeSNumber.format((VeSDecimal)lo_venda_item.ValorUnitarioGet(), (String)"#,##0.00")), (int)10, (int)2, (String)" ") + "\r\n";
                    ++n2;
                }
                ls_mensagem = String.valueOf(ls_mensagem) + VeSString.Align((String)("Valor Total: R$ " + VeSNumber.format((VeSDecimal)this.io_transaction_manager.TransactionGet().in_valor, (String)"#,##0.00")), (int)32, (int)1, (String)" ") + "\r\n";
                ls_mensagem = String.valueOf(ls_mensagem) + "Confirma opera\u00e7\u00e3o?";
                if (!VeSPagueClient.VISIBLE) {
                    ls_mensagem = String.valueOf(ls_titulo) + ":" + "\r\n" + ls_mensagem;
                    VeSPagueClientToAutomation lo_automation_send = new VeSPagueClientToAutomation("");
                    VeSPagueClientToAutomation lo_automation_receive = new VeSPagueClientToAutomation("");
                    lo_automation_send.automacao_coleta_retorno = VeSPagueClientUtil.RETURN_CODE_SUCESS_CONFIRMATION;
                    lo_automation_send.automacao_coleta_mensagem = new String[]{ls_mensagem};
                    lo_automation_send.automacao_coleta_tipo = "X";
                    lo_automation_send.automacao_coleta_opcao = new String[]{"Sim", "N\u00e3o"};
                    try {
                        this.io_transaction_manager.io_client_to_server.io_client_automation_interaction.Send(lo_automation_send, Integer.valueOf(120000), true, null);
                        lo_automation_receive = this.io_transaction_manager.io_client_to_server.io_client_automation_interaction.RespostaAplicacaoComercialConsistir(lo_automation_send.automacao_coleta_sequencial, VeSPagueClientUtil.RETURN_CODE_SUCESS_CONFIRMATION);
                    }
                    catch (VeSPagueClientException ex) {
                        ex.printStackTrace();
                    }
                    if (lo_automation_receive.automacao_coleta_informacao != null && !"Sim".equalsIgnoreCase(lo_automation_receive.automacao_coleta_informacao)) {
                        throw new VeSPagueProcessamentoException("Opera\u00e7\u00e3o cancelada, abortando a transa\u00e7\u00e3o.");
                    }
                    this.RemoverOpcaoSimLista();
                } else {
                    Object lo_resposta = VBIWindowMessage.Show((String)ls_titulo, (Object)ls_mensagem, (int)0, (Object[])VBIWindowMessage.YES_NO_OPTIONS, (Object)VBIWindowMessage.NO_OPTION);
                    if (VBIWindowMessage.NO_OPTION == lo_resposta) {
                        throw new VeSPagueProcessamentoException("Opera\u00e7\u00e3o cancelada, abortando a transa\u00e7\u00e3o.");
                    }
                    this.RemoverOpcaoSimLista();
                }
            }
        }
    }

    public void DadoGravar() throws VeSPagueProcessamentoException {
        if (this.getProdutoAtual() != null) {
            VeSPagueProdutoVendaItem lo_venda_item = this.getProdutoAtual();
            this.ValorTransacaoVerificar();
            if (QUESTION_YES.equals(this.io_lt_list.getSelectedItem())) {
                if (lo_venda_item.GrupoMulticoletaGet()) {
                    this.io_transaction_manager.io_wn_processar.ComponenteRetroceder(VSPagueListaProdutoPrincipal.class);
                } else {
                    this.io_transaction_manager.io_wn_processar.ComponenteRetroceder(VSPagueListaProdutoSecundario.class);
                }
                this.io_transaction_manager.TransactionGet().io_produto_servico = (VeSPagueProdutoVendaItem[])VeSUtil.ArrayConcatenate((Object)this.io_transaction_manager.TransactionGet().io_produto_servico, (Object)new VeSPagueProdutoVendaItem[]{lo_venda_item.GrupoMulticoletaGet() ? new VeSPagueProdutoVendaItem() : new VeSPagueProdutoVendaItem(lo_venda_item.GrupoCodigoGet(), Boolean.valueOf(lo_venda_item.GrupoMulticoletaGet()), Boolean.valueOf(lo_venda_item.ProdutosMultiplosColetaHabilitar()), lo_venda_item.GrupoDescricaoGet(), null, null, null, null, null, lo_venda_item.ValorUnitarioColetarGet(), lo_venda_item.QuantidadeColetarGet(), lo_venda_item.ValorTotalColetarGet(), lo_venda_item.ValorImpostoColetarGet(), lo_venda_item.TabelaIndicadaGet())});
            }
        }
        if (this.io_transaction_manager.io_datastore.OutroProdutoVerificar()) {
            this.io_transaction_manager.io_datastore.OutroProdutoFiltrar();
        }
    }

    protected Object FixedValueGet() {
        return null;
    }

    public boolean isCollect() {
        return this.getProdutoAtual() != null && (this.getProdutoAtual().GrupoMulticoletaGet() || this.getProdutoAtual().ProdutosMultiplosColetaHabilitar()) || this.io_transaction_manager.DatastoreGet().OutroProdutoVerificar();
    }

    private final VeSPagueProdutoVendaItem getProdutoAtual() {
        return this.ParametersGet().io_produto_servico != null && this.ParametersGet().io_produto_servico.length > 0 ? this.ParametersGet().io_produto_servico[this.ParametersGet().io_produto_servico.length - 1] : null;
    }

    private final boolean ValorTransacaoVerificar() throws VeSPagueProcessamentoException {
        if (this.getProdutoAtual() != null && this.getProdutoAtual().ValorUnitarioColetarGet() != null && this.getProdutoAtual().ValorUnitarioColetarGet().booleanValue()) {
            VeSPagueProdutoVendaItem[] lo_produto_servico = this.io_transaction_manager.TransactionGet().io_produto_servico;
            VeSDecimal ln_valor_total_produtos = VeSDecimal.ZERO;
            if (lo_produto_servico != null) {
                VeSPagueProdutoVendaItem[] veSPagueProdutoVendaItemArray = lo_produto_servico;
                int n = lo_produto_servico.length;
                int n2 = 0;
                while (n2 < n) {
                    VeSPagueProdutoVendaItem lo_produto = veSPagueProdutoVendaItemArray[n2];
                    ln_valor_total_produtos = ln_valor_total_produtos.add(lo_produto.ValorUnitarioGet());
                    ++n2;
                }
            }
            if (ln_valor_total_produtos.compareTo((BigDecimal)this.ParametersGet().in_valor) > 0) {
                throw new VeSPagueProcessamentoException("Valor do (s) produto(s) informado(s) maior que o valor da transa\u00e7\u00e3o.");
            }
            if (this.io_lt_list.getSelectedItem() != null && QUESTION_NO.equals(this.io_lt_list.getSelectedItem()) && ln_valor_total_produtos.compareTo((BigDecimal)this.ParametersGet().in_valor) < 0) {
                this.io_lt_list.setListData((Object[])new String[]{QUESTION_YES});
                this.io_lt_list.setSelectedIndex(0);
                throw new VeSPagueProcessamentoException("Valor do (s) produto(s) informado(s) menor que valor da transa\u00e7\u00e3o.");
            }
            return ln_valor_total_produtos.compareTo((BigDecimal)this.ParametersGet().in_valor) < 0;
        }
        return false;
    }

    private final void RemoverOpcaoSimLista() throws VeSPagueProcessamentoException {
        this.io_lt_list.setListData((Object[])new String[]{QUESTION_NO});
        this.io_lt_list.setSelectedIndex(0);
        super.PreConsistenciaFazer();
    }
}

