/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.graphic.transacao.cartao.roteamento;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import lib.VBI;
import lib.VBIMain;
import lib.VeSUtil;
import lib.device.pinpad.VeSPinpadCompartilhado;
import lib.type.VeSDecimal;
import lib.type.VeSException;
import lib.type.VeSString;
import vespague.client.configuration.Configuration;
import vespague.client.configuration.ConfigurationInstance;
import vespague.client.device.VeSPaguePinpad;
import vespague.client.graphic.VeSPagueCampoBaseTextoGenerico;
import vespague.client.graphic.transacao.cartao.VSPagueCampoCartaoNumero;
import vespague.client.graphic.transacao.cartao.VSPagueCampoRoteamento;
import vespague.client.graphic.transacao.cartao.roteamento.CardModel;
import vespague.client.graphic.transacao.cartao.roteamento.CustomerModel;
import vespague.client.graphic.transacao.cartao.roteamento.RoutingRequest;
import vespague.client.graphic.transacao.cartao.roteamento.RoutingResponse;
import vespague.client.graphic.transacao.cartao.roteamento.TransactionModel;
import vespague.client.graphic.transacao.cartao.taxa.Data;
import vespague.client.graphic.transacao.cartao.taxa.VSPagueClientTaxaRequest;
import vespague.client.graphic.transacao.cartao.taxa.VSPagueClientTokenCreateResponse;
import vespague.common.VeSPagueClientUtil;
import vespague.common.service.VSPagueHealthCheckManager;
import vespague.common.type.VeSPagueMessageOld;
import vespague.exception.VeSPagueProcessamentoException;
import vespague.structure.VSPagueCartaoBandeiraAid;
import vespague.structure.VeSPagueConfiguracaoParametro;
import vespague.structure.VeSPagueConfiguracaoPesquisar;
import vespague.structure.VeSPagueTransacao;
import vespague.structure.VeSPagueValorLojaRedeConfiguracao;

public class VSPagueCampoRotaAdquirente
extends VeSPagueCampoBaseTextoGenerico {
    private final VSPagueCampoRoteamento.Config config;

    public VSPagueCampoRotaAdquirente(VSPagueCampoRoteamento.Config config) {
        super(100, 0, "Roteamento");
        this.config = config;
    }

    public void PreConsistenciaFazer() throws VeSPagueProcessamentoException {
        boolean collect = this.isCollect();
        this.setEnabled(false);
        this.setVisible(collect);
        if (collect) {
            super.PreConsistenciaFazer();
            VeSPagueTransacao veSPagueTransacao = this.io_transaction_manager.TransactionGet();
            VeSPaguePinpad veSPaguePinpad = this.io_transaction_manager.io_client.PinpadGet();
            if (this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().io_cfg_loja.getMcc() == null) {
                throw new VeSPagueProcessamentoException(VeSPagueMessageOld.MessageGet((int)140));
            }
            if ("Circuito Integrado".equals(veSPagueTransacao.TransacaoCartaoGet().is_entrada) || "Contactless".equals(veSPagueTransacao.TransacaoCartaoGet().is_entrada)) {
                if (veSPaguePinpad.in_cartao_rede_adquirente == null || veSPaguePinpad.in_cartao_registro_indice == null) {
                    throw new VeSPagueProcessamentoException("Problema na leitura do cartao: ", veSPagueTransacao.io_problem);
                }
            } else if (veSPagueTransacao.TransacaoCartaoGet().is_tipo == null) {
                throw new VeSPagueProcessamentoException(VeSPagueMessageOld.MessageGet((int)141));
            }
            RoutingResponse routingResponse = null;
            try {
                routingResponse = this.consultarRoteamento(veSPagueTransacao, this.io_transaction_manager.io_client.PinpadGet());
            }
            catch (Throwable ex) {
                LOGGER.error("Erro no processamento da melhor taxa ", ex);
                try {
                    if (this.config.getUrlNataxa() != null) {
                        VBI.Trace((String)("ENVIRONMENT: " + this.config.getEnvironment()));
                        VSPagueHealthCheckManager.EmailEnviar((String)VBIMain.ApplicationGet(), (String)"[V$PagueClient] Sem Acesso ao Nataxa", (String)("Problema ao acessar o Nataxa no terminal " + this.io_transaction_manager.io_client.getEstabelecimento() + "\\" + this.io_transaction_manager.io_client.getLoja() + "\\" + this.io_transaction_manager.io_client.getTerminal() + ":" + "\r\n\r\n" + veSPagueTransacao + "\r\n\r\n" + VeSException.StackGet((Throwable)ex) + "\r\n\r\n" + "Hostname: " + InetAddress.getLocalHost().getHostName().toLowerCase()), (String)"V$PagueClient - Nataxa <noreply@nexu.ca>", null, (String)this.config.getEnvironment(), (boolean)true);
                    }
                }
                catch (Throwable ex1) {
                    LOGGER.error(ex1.getMessage(), ex1);
                }
            }
            if (veSPaguePinpad != null) {
                String acquirer = veSPaguePinpad.AcquirerGet(veSPaguePinpad.in_cartao_rede_adquirente, veSPaguePinpad.in_cartao_registro_indice);
                if (routingResponse != null && routingResponse.acquirer() != null) {
                    String selectedAcquirer = VeSString.CapitalLetterInitiateSet((String)routingResponse.acquirer());
                    Double fee = routingResponse.fee();
                    if (fee != null) {
                        veSPagueTransacao.in_transacao_taxa = new VeSDecimal(fee.doubleValue());
                    }
                    if (!selectedAcquirer.equals(acquirer)) {
                        this.Log("[Nataxa] " + selectedAcquirer + "/" + fee);
                        acquirer = selectedAcquirer;
                        VeSPagueConfiguracaoParametro[] acquirerConfigurations = this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().io_cfg_parametro;
                        int acquirerCount = 0;
                        while (acquirerCount < acquirerConfigurations.length && !acquirerConfigurations[acquirerCount].io_valor_loja_rede.is_rede.equals(acquirer)) {
                            ++acquirerCount;
                        }
                        if (acquirerCount >= acquirerConfigurations.length) {
                            VeSPagueMessageOld lo_message = VeSPagueMessageOld.MessageGet((int)134);
                            throw new RuntimeException("[" + lo_message.CodeGet() + "] " + lo_message.toString(new Object[]{acquirer}));
                        }
                        String aid = veSPagueTransacao.TransacaoCartaoGet().is_aid;
                        String cardType = veSPagueTransacao.TransacaoCartaoGet().is_tipo;
                        VeSPagueValorLojaRedeConfiguracao.Chip[] chips = acquirerConfigurations[acquirerCount].io_valor_loja_rede.io_chip;
                        int chipCount = 0;
                        while (!(chipCount >= chips.length || chips[chipCount].is_application_identifier.equals(aid) && chips[chipCount].is_tipo_cartao.equals(cardType))) {
                            ++chipCount;
                        }
                        if (chipCount >= chips.length) {
                            VeSPagueMessageOld vspagueMessage = VeSPagueMessageOld.MessageGet((int)118);
                            throw new RuntimeException("[" + vspagueMessage.CodeGet() + "] " + vspagueMessage.toString(new Object[]{acquirer, aid}));
                        }
                        veSPaguePinpad.in_cartao_rede_adquirente = acquirerConfigurations[acquirerCount].io_valor_loja_rede.io_configuracao.in_emv_identificacao;
                        veSPaguePinpad.in_cartao_registro_indice = chips[chipCount].in_aid_index;
                        this.NfcAdquirenteEscolhidaValidar(veSPaguePinpad, acquirer);
                    } else {
                        this.Log("[Nataxa/PINPad] " + selectedAcquirer + "/" + fee);
                    }
                } else {
                    this.Log("[PINPad] " + acquirer);
                }
                this.setText(acquirer);
            } else {
                this.Log("[E-commerce] Adquirente " + null);
            }
        }
    }

    private void NfcAdquirenteEscolhidaValidar(VeSPaguePinpad veSPaguePinpad, String acquirer) throws VeSPagueProcessamentoException {
        String entryType = this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_entrada;
        if ("Contactless".equals(entryType)) {
            VeSPagueConfiguracaoParametro[] acquirerConfigurations = this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().io_cfg_parametro;
            int ln_adquirente = 0;
            while (ln_adquirente < acquirerConfigurations.length && !acquirerConfigurations[ln_adquirente].io_valor_loja_rede.is_rede.equals(acquirer)) {
                ++ln_adquirente;
            }
            String selectedAcquirer = acquirerConfigurations[ln_adquirente].io_valor_loja_rede.is_rede;
            String acquirerVersion = acquirerConfigurations[ln_adquirente].io_valor_loja_rede.is_rede_versao;
            Set lo_stt_rede_entrada = this.io_transaction_manager.DatastoreGet().CartaoEntradaTipoDisponivel(selectedAcquirer, acquirerVersion);
            boolean aidAllowsContactless = this.AidPermiteContactlessGet(veSPaguePinpad.in_cartao_rede_adquirente.intValue(), veSPaguePinpad.in_cartao_registro_indice.intValue());
            if (!lo_stt_rede_entrada.contains("Contactless") || !aidAllowsContactless) {
                try {
                    this.io_transaction_manager.io_client.PinpadGet().PP_Display(" UTILIZE CART\u00c3O     COM CHIP    ");
                    Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.io_transaction_manager.io_client.PinpadGet().in_cartao_contactless_situacao = 9;
                this.io_transaction_manager.io_wn_processar.ComponenteRetroceder(VSPagueCampoCartaoNumero.class);
                this.io_transaction_manager.io_wn_processar.ProximoComponentIr();
            }
        }
    }

    protected String FixedValueGet() {
        return null;
    }

    protected void DadoSet(String acquirer) {
        this.io_transaction_manager.TransactionGet().is_rede = acquirer;
        VeSPaguePinpad veSPaguePinpad = this.io_transaction_manager.io_client.PinpadGet();
        if (veSPaguePinpad != null) {
            try {
                this.io_transaction_manager.io_datastore.CartaoNumeroFiltrar(veSPaguePinpad.is_cartao_numero, true);
            }
            catch (VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException ex) {
                VeSPagueMessageOld lo_message = VeSPagueMessageOld.MessageGet((int)136);
                LOGGER.error(lo_message.MessageGet(), (Throwable)ex);
                throw new RuntimeException("[" + lo_message.CodeGet() + "] " + lo_message.MessageGet());
            }
        }
    }

    public final boolean isCollect() {
        return this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().getLayout() <= 1 && this.io_transaction_manager.DatastoreGet().MelhorTaxaHabilitar();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RoutingResponse consultarRoteamento(VeSPagueTransacao veSPagueTransacao, VeSPaguePinpad veSPaguePinpad) throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException, VeSPagueProcessamentoException, VeSPinpadCompartilhado.VeSPinpadCompartilhadoNoApplicationException, IOException {
        List acquirers;
        int installments;
        String brand = veSPagueTransacao.TransacaoCartaoGet().is_administradora;
        String transactionCardType = this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_tipo;
        int n = installments = this.io_transaction_manager.TransactionGet().in_parcelas != null ? this.io_transaction_manager.TransactionGet().in_parcelas.intValue() : 1;
        if (brand == null && veSPaguePinpad != null) {
            int acquirerIndex = this.io_transaction_manager.DatastoreGet().EMVIndexToNet(veSPaguePinpad.in_cartao_rede_adquirente.intValue(), veSPaguePinpad.in_cartao_registro_indice.intValue());
            int aidIndex = this.io_transaction_manager.DatastoreGet().AIDIndexToArrayIndex(acquirerIndex, veSPaguePinpad.in_cartao_registro_indice.intValue());
            VeSPagueValorLojaRedeConfiguracao acquirerConfiguration = this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().io_cfg_parametro[acquirerIndex].io_valor_loja_rede;
            String aid = acquirerConfiguration.io_chip[aidIndex].is_application_identifier;
            VSPagueCartaoBandeiraAid[] aids = this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().io_cfg_application_identifier;
            int ln_1 = 0;
            while (ln_1 < aids.length && !aids[ln_1].ApplicationIdentifierGet().equalsIgnoreCase(aid)) {
                ++ln_1;
            }
            if (ln_1 >= aids.length) {
                throw new VeSPinpadCompartilhado.VeSPinpadCompartilhadoNoApplicationException(VeSPagueMessageOld.MessageGet((int)118).MessageGet());
            }
            if (veSPagueTransacao.TransacaoCartaoGet().is_aid != null && !aids[ln_1].ApplicationIdentifierGet().equals(veSPagueTransacao.TransacaoCartaoGet().is_aid)) {
                throw new VeSPinpadCompartilhado.VeSPinpadCompartilhadoNoApplicationException(VeSPagueMessageOld.MessageGet((int)134).toString(new Object[]{acquirerConfiguration.is_rede}));
            }
            veSPagueTransacao.TransacaoCartaoGet().is_aid = aids[ln_1].ApplicationIdentifierGet();
            brand = aids[ln_1].BandeiraGet();
            transactionCardType = transactionCardType == null ? aids[ln_1].TipoCartaoGet() : transactionCardType;
        }
        String bin = null;
        if (veSPagueTransacao.TransacaoCartaoGet().is_cartao_numero != null) {
            bin = veSPagueTransacao.TransacaoCartaoGet().is_cartao_numero.substring(0, 6);
        }
        String entryType = "Digitado".equals(veSPagueTransacao.TransacaoCartaoGet().is_entrada) ? "D" : ("Magn\u00e9tico".equals(veSPagueTransacao.TransacaoCartaoGet().is_entrada) ? "M" : ("Circuito Integrado".equals(veSPagueTransacao.TransacaoCartaoGet().is_entrada) ? "I" : ("Contactless".equals(veSPagueTransacao.TransacaoCartaoGet().is_entrada) ? "C" : null)));
        String document = this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().io_cfg_loja.getCnpjCpf();
        document = document.replace(".", "").replace("/", "").replace("-", "");
        VeSPagueConfiguracaoParametro[] acquirerConfigurations = this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().io_cfg_parametro;
        if (VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_DEBITO.equals(transactionCardType) && this.io_transaction_manager.DatastoreGet().getAidsEspeciais().contains(veSPagueTransacao.TransacaoCartaoGet().is_aid)) {
            this.Log("Este cart\u00e3o \u00e9 DEBIT MASTERCARD: " + veSPagueTransacao.TransacaoCartaoGet().is_aid);
            this.Log("Adquirentes na configura\u00e7\u00e3o: " + acquirerConfigurations.length);
            acquirers = this.io_transaction_manager.DatastoreGet().DebitMastercardHabilitar();
            this.Log("Adquirentes que processam DEBIT MASTERCARD: " + VeSUtil.ArrayToString((Object[])acquirers.toArray()));
            if (acquirers.isEmpty()) {
                throw new VeSPagueProcessamentoException(VeSPagueMessageOld.MessageGet((int)156));
            }
        } else {
            acquirers = this.io_transaction_manager.DatastoreGet().listarRedesPorAid(veSPagueTransacao.TransacaoCartaoGet().is_aid);
        }
        if (brand != null) {
            brand = brand.toUpperCase();
        }
        CardModel card = CardModel.with((String)brand, (String)veSPagueTransacao.TransacaoCartaoGet().is_aid, (String)bin, (String)entryType);
        String cardType = VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_CREDITO.equals(transactionCardType) ? "CREDIT" : "DEBIT";
        double transactionValue = veSPagueTransacao.ValorTotalGet().doubleValue();
        TransactionModel transaction = TransactionModel.with((String)cardType, (int)installments, (double)transactionValue);
        CustomerModel consumer = CustomerModel.with(null, (String)document, (String[])acquirers.toArray(new String[0]));
        RoutingRequest routingRequest = RoutingRequest.with((CustomerModel)consumer, (CardModel)card, (TransactionModel)transaction);
        RoutingResponse routingResponse = null;
        ConfigurationInstance configurationInstance = this.io_transaction_manager.configurationInstance;
        if (configurationInstance != null && configurationInstance.getConfiguration().isPresent() && ((Configuration)configurationInstance.getConfiguration().get()).isNataxaEmbedded().orElse(false).booleanValue()) {
            try {
                routingResponse = this.io_transaction_manager.io_client_to_server.consultaRoteamento(routingRequest);
                if (routingResponse == null) return routingResponse;
                this.Log("Ok (200): OK");
                return routingResponse;
            }
            catch (Exception e) {
                LOGGER.error("Erro (falha no processamento da melhor taxa)", (Throwable)e);
                return null;
            }
        } else {
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.setLenient();
            Gson gson = gsonBuilder.create();
            int tokenRetry = 0;
            do {
                HttpURLConnection httpURLConnection = this.Connect();
                String json = gson.toJson((Object)routingRequest);
                this.Request(httpURLConnection, json);
                String response = this.Response(httpURLConnection, true);
                if (!response.isEmpty()) {
                    routingResponse = (RoutingResponse)gson.fromJson(response, RoutingResponse.class);
                }
                if (httpURLConnection.getResponseCode() == 200 || httpURLConnection.getResponseCode() == 201 || httpURLConnection.getResponseCode() == 204) {
                    this.Log("Ok (" + httpURLConnection.getResponseCode() + "): " + httpURLConnection.getResponseMessage());
                    continue;
                }
                this.Log(" Erro (" + httpURLConnection.getResponseCode() + "): " + httpURLConnection.getResponseMessage());
            } while (this.config.getToken() == null && ++tokenRetry < 2);
            if (this.config.getToken() != null) return routingResponse;
            this.Log("Token n\u00e3o recebido ap\u00f3s " + tokenRetry + " tentativas no servidor de autentica\u00e7\u00e3o (" + this.config.getUrlAutenticacao() + ")");
        }
        return routingResponse;
    }

    private void TokenCreate() throws IOException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setLenient();
        Gson gson = gsonBuilder.create();
        VSPagueClientTaxaRequest authServiceToken = new VSPagueClientTaxaRequest();
        Data data = new Data();
        data.setPassword(this.config.getPassword());
        authServiceToken.setData(data);
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)new URL(this.config.getUrlAutenticacao()).openConnection();
        httpsURLConnection.setDoOutput(true);
        httpsURLConnection.setRequestMethod("POST");
        httpsURLConnection.addRequestProperty("Content-Type", "application/json");
        httpsURLConnection.connect();
        String json = gson.toJson((Object)authServiceToken);
        httpsURLConnection.getOutputStream().write(json.getBytes());
        VSPagueClientTokenCreateResponse token = (VSPagueClientTokenCreateResponse)gson.fromJson(this.Response((HttpURLConnection)httpsURLConnection, false), VSPagueClientTokenCreateResponse.class);
        if (httpsURLConnection.getResponseCode() == 200 || httpsURLConnection.getResponseCode() == 201) {
            this.config.setToken(token.getData());
            this.Log("Token atualizado (" + httpsURLConnection.getResponseCode() + "): " + httpsURLConnection.getResponseMessage());
        } else {
            this.Log("Erro (" + httpsURLConnection.getResponseCode() + "): " + httpsURLConnection.getResponseMessage());
        }
    }

    private HttpURLConnection Connect() throws IOException {
        if (this.config.getToken() == null) {
            this.TokenCreate();
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(this.config.getUrlNataxa()).openConnection();
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setConnectTimeout(15000);
        httpURLConnection.setReadTimeout(15000);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.addRequestProperty("Authorization", this.config.getToken());
        httpURLConnection.addRequestProperty("Content-Type", "application/json");
        httpURLConnection.connect();
        return httpURLConnection;
    }

    private void Request(HttpURLConnection httpURLConnection, String json) throws IOException {
        this.Log(json);
        httpURLConnection.getOutputStream().write(json.getBytes());
    }

    private String Response(HttpURLConnection httpURLConnection, boolean trace) throws IOException {
        StringBuilder responseBuilder = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            while ((line = reader.readLine()) != null) {
                responseBuilder.append(line);
            }
            String response = responseBuilder.toString();
            if (trace && !response.isEmpty()) {
                this.Log(response);
            }
        }
        catch (Throwable ex) {
            if (httpURLConnection.getResponseCode() == 401) {
                this.config.setToken(null);
                httpURLConnection.disconnect();
            }
            throw ex;
        }
        return responseBuilder.toString();
    }

    private boolean AidPermiteContactlessGet(int emvIndex, int aidCardIndex) throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        int acquirerIndex = this.io_transaction_manager.DatastoreGet().EMVIndexToNet(emvIndex, aidCardIndex);
        int aidIndex = this.io_transaction_manager.DatastoreGet().AIDIndexToArrayIndex(acquirerIndex, aidCardIndex);
        VeSPagueValorLojaRedeConfiguracao acquirerConfiguration = this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().io_cfg_parametro[acquirerIndex].io_valor_loja_rede;
        VeSPagueValorLojaRedeConfiguracao.Chip chip = acquirerConfiguration.io_chip[aidIndex];
        this.Log("EMV " + emvIndex + " | \u00cdndice AID " + aidCardIndex + " | AID " + chip.is_application_identifier + " | NFC " + chip.ib_contactless);
        return chip.ib_contactless != null && chip.ib_contactless != false;
    }

    private void Log(String log) {
        LOGGER.info("nataxa-router [" + this.io_transaction_manager.io_client.getEstabelecimento() + "\\" + this.io_transaction_manager.io_client.getLoja() + "\\" + this.io_transaction_manager.io_client.getTerminal() + "] " + log);
    }
}

