/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.graphic.transacao.cartao.splitpagamento;

import java.math.BigDecimal;
import lib.VeSUtil;
import lib.type.VeSDecimal;
import lib.type.VeSNumber;
import lib.type.VeSString;
import vespague.client.graphic.VeSPagueClient;
import vespague.client.graphic.VeSPagueListaBaseGenerica;
import vespague.client.graphic.transacao.cartao.splitpagamento.VSPagueCampoIdentificadorSubVendedorSplitPagamento;
import vespague.client.lib.graphic.window.VBIWindowMessage;
import vespague.exception.VeSPagueProcessamentoException;
import vespague.structure.splitpagamento.TransacaoSplitPagamento;

public class VSPagueListaOutroSubVendedor
extends VeSPagueListaBaseGenerica {
    private static final String QUESTION_YES = "1-Sim";
    private static final String QUESTION_NO = "2-N\u00e3o";
    public static final String NAME_DEFAULT = "Adicionar mais Subvendedores?";

    public VSPagueListaOutroSubVendedor() {
        super(200, NAME_DEFAULT);
    }

    protected void DadoSet(String dado) {
    }

    public void PreConsistenciaFazer() throws VeSPagueProcessamentoException {
        boolean coletar = this.isCollect();
        this.setVisible(VeSPagueClient.VISIBLE && coletar);
        this.io_lt_list.setListData((Object[])new String[]{QUESTION_YES, QUESTION_NO});
        if (coletar && this.getSubVendedorAtual().getValorSubVendedor() == null) {
            this.setHorizontalScrollBarPolicy(31);
            if (this.isVisible()) {
                if (this.io_lt_list.getModel().getSize() >= 1) {
                    this.io_lt_list.setSelectedIndex(0);
                }
                super.PreConsistenciaFazer();
            }
        } else if (coletar && this.ParametersGet().getTransacaoSplitPagamento().getSubVendedor() != null && this.getSubVendedorAtual().getValorSubVendedor() != null) {
            this.setVisible(false);
            if (this.ValorTransacaoVerificar()) {
                this.RemoverOpcaoNaoLista();
                super.PreConsistenciaFazer();
            } else {
                String titulo = "Confirma itens Adicionados";
                String mensagem = "Voc\u00ea adicionou os seguintes subvendedores:\r\n";
                TransacaoSplitPagamento.SubVendedorSplitPagamento[] subVendedorSplitPagamentoArray = this.ParametersGet().getTransacaoSplitPagamento().getSubVendedor();
                int n = subVendedorSplitPagamentoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TransacaoSplitPagamento.SubVendedorSplitPagamento subVendedor = subVendedorSplitPagamentoArray[n2];
                    mensagem = String.valueOf(mensagem) + VeSString.Align((String)subVendedor.getIdentificadorSubVendedor(), (int)20, (int)1, (String)" ") + "| " + VeSString.Align((String)("R$ " + VeSNumber.format((double)subVendedor.getValorSubVendedor().doubleValue(), (String)"#,##0.00")), (int)20, (int)2, (String)" ") + "\r\n";
                    ++n2;
                }
                mensagem = String.valueOf(mensagem) + VeSString.Align((String)("Valor Total: R$ " + VeSNumber.format((VeSDecimal)this.io_transaction_manager.TransactionGet().in_valor, (String)"#,##0.00")), (int)32, (int)1, (String)" ") + "\r\n";
                mensagem = String.valueOf(mensagem) + "Confirma opera\u00e7\u00e3o?";
                if (VeSPagueClient.VISIBLE) {
                    Object resposta = VBIWindowMessage.Show((String)titulo, (Object)mensagem, (int)0, (Object[])VBIWindowMessage.YES_NO_OPTIONS, (Object)VBIWindowMessage.YES_OPTION);
                    if (VBIWindowMessage.NO_OPTION == resposta) {
                        throw new VeSPagueProcessamentoException("Opera\u00e7\u00e3o cancelada, abortando a transa\u00e7\u00e3o.");
                    }
                    this.RemoverOpcaoSimLista();
                    this.setVisible(false);
                }
            }
        }
    }

    public void DadoGravar() throws VeSPagueProcessamentoException {
        if (this.getSubVendedorAtual() != null) {
            this.ValorTransacaoVerificar();
            if (QUESTION_YES.equals(this.io_lt_list.getSelectedItem())) {
                this.io_transaction_manager.io_wn_processar.ComponenteRetroceder(VSPagueCampoIdentificadorSubVendedorSplitPagamento.class);
                this.ParametersGet().getTransacaoSplitPagamento().setSubVendedor((TransacaoSplitPagamento.SubVendedorSplitPagamento[])VeSUtil.ArrayConcatenate((Object)this.ParametersGet().getTransacaoSplitPagamento().getSubVendedor(), (Object)new TransacaoSplitPagamento.SubVendedorSplitPagamento[]{new TransacaoSplitPagamento.SubVendedorSplitPagamento()}));
            }
        }
    }

    protected Object FixedValueGet() {
        return null;
    }

    public boolean isCollect() {
        return this.ParametersGet().isColetarDadosSplitPagamento() != false && this.getSubVendedorAtual() != null;
    }

    private TransacaoSplitPagamento.SubVendedorSplitPagamento getSubVendedorAtual() {
        TransacaoSplitPagamento.SubVendedorSplitPagamento[] subVendedor = this.ParametersGet().getTransacaoSplitPagamento() == null ? null : this.ParametersGet().getTransacaoSplitPagamento().getSubVendedor();
        return subVendedor != null && subVendedor.length > 0 ? subVendedor[subVendedor.length - 1] : null;
    }

    private boolean ValorTransacaoVerificar() throws VeSPagueProcessamentoException {
        if (this.getSubVendedorAtual() != null && this.getSubVendedorAtual().getValorSubVendedor() != null) {
            TransacaoSplitPagamento.SubVendedorSplitPagamento[] subVendedores = this.ParametersGet().getTransacaoSplitPagamento().getSubVendedor();
            Object valorTotalPorSubVendedor = VeSDecimal.ZERO;
            if (subVendedores != null) {
                TransacaoSplitPagamento.SubVendedorSplitPagamento[] subVendedorSplitPagamentoArray = subVendedores;
                int n = subVendedores.length;
                int n2 = 0;
                while (n2 < n) {
                    TransacaoSplitPagamento.SubVendedorSplitPagamento subVendedor = subVendedorSplitPagamentoArray[n2];
                    valorTotalPorSubVendedor = valorTotalPorSubVendedor.add(subVendedor.getValorSubVendedor());
                    ++n2;
                }
            }
            if (valorTotalPorSubVendedor.compareTo((BigDecimal)this.ParametersGet().in_valor) > 0) {
                throw new VeSPagueProcessamentoException("Valor dos subvendedores maior do que o valor da transa\u00e7\u00e3o.");
            }
            if (this.io_lt_list.getSelectedItem() != null && QUESTION_NO.equals(this.io_lt_list.getSelectedItem()) && valorTotalPorSubVendedor.compareTo((BigDecimal)this.ParametersGet().in_valor) < 0) {
                this.io_lt_list.setListData((Object[])new String[]{QUESTION_YES});
                this.io_lt_list.setSelectedIndex(0);
                throw new VeSPagueProcessamentoException("Valor dos subvendedores menor que valor da transa\u00e7\u00e3o.");
            }
            return valorTotalPorSubVendedor.compareTo((BigDecimal)this.ParametersGet().in_valor) < 0;
        }
        return false;
    }

    private void RemoverOpcaoSimLista() throws VeSPagueProcessamentoException {
        this.io_lt_list.setListData((Object[])new String[]{QUESTION_NO});
        this.io_lt_list.setSelectedIndex(0);
        super.PreConsistenciaFazer();
    }

    private void RemoverOpcaoNaoLista() throws VeSPagueProcessamentoException {
        this.io_lt_list.setListData((Object[])new String[]{QUESTION_YES});
        this.io_lt_list.setSelectedIndex(0);
    }
}

