/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.graphic.transacao.cartao.taxa;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import lib.VBI;
import lib.VBIMain;
import lib.VeSUtil;
import lib.device.pinpad.VeSPinpadCompartilhado;
import lib.type.VeSDecimal;
import lib.type.VeSException;
import lib.type.VeSInteger;
import lib.type.VeSString;
import vespague.client.configuration.Configuration;
import vespague.client.configuration.ConfigurationInstance;
import vespague.client.device.VeSPaguePinpad;
import vespague.client.graphic.VeSPagueCampoBaseTextoGenerico;
import vespague.client.graphic.transacao.cartao.VSPagueCampoCartaoNumero;
import vespague.client.graphic.transacao.cartao.VSPagueCampoRoteamento;
import vespague.client.graphic.transacao.cartao.taxa.Card;
import vespague.client.graphic.transacao.cartao.taxa.Data;
import vespague.client.graphic.transacao.cartao.taxa.Expiration;
import vespague.client.graphic.transacao.cartao.taxa.Merchant;
import vespague.client.graphic.transacao.cartao.taxa.Transaction;
import vespague.client.graphic.transacao.cartao.taxa.VSPagueClientTaxaRequest;
import vespague.client.graphic.transacao.cartao.taxa.VSPagueClientTaxaResponse;
import vespague.client.graphic.transacao.cartao.taxa.VSPagueClientTokenCreateResponse;
import vespague.common.VeSPagueClientUtil;
import vespague.common.service.VSPagueHealthCheckManager;
import vespague.common.type.VeSPagueMessageOld;
import vespague.exception.VeSPagueProcessamentoException;
import vespague.structure.VSPagueCartaoBandeiraAid;
import vespague.structure.VeSPagueConfiguracaoParametro;
import vespague.structure.VeSPagueConfiguracaoPesquisar;
import vespague.structure.VeSPagueTransacao;
import vespague.structure.VeSPagueValorLojaRedeConfiguracao;

public class VSPagueCampoAdquirenteMelhorTaxa
extends VeSPagueCampoBaseTextoGenerico {
    private final VSPagueCampoRoteamento.Config config;

    public VSPagueCampoAdquirenteMelhorTaxa(VSPagueCampoRoteamento.Config config) {
        super(100, 0, "Melhor Taxa");
        this.config = config;
    }

    public void PreConsistenciaFazer() throws VeSPagueProcessamentoException {
        boolean lb_collect = this.isCollect();
        this.setEnabled(false);
        this.setVisible(lb_collect);
        if (lb_collect) {
            super.PreConsistenciaFazer();
            VeSPagueTransacao lo_transacao = this.io_transaction_manager.TransactionGet();
            VeSPaguePinpad lo_pinpad = this.io_transaction_manager.io_client.PinpadGet();
            if (this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().io_cfg_loja.getMcc() == null) {
                throw new VeSPagueProcessamentoException(VeSPagueMessageOld.MessageGet((int)140));
            }
            if ("Circuito Integrado".equals(lo_transacao.TransacaoCartaoGet().is_entrada) || "Contactless".equals(lo_transacao.TransacaoCartaoGet().is_entrada)) {
                if (lo_pinpad.in_cartao_rede_adquirente == null || lo_pinpad.in_cartao_registro_indice == null) {
                    throw new VeSPagueProcessamentoException("Problema na leitura do cartao: ", lo_transacao.io_problem);
                }
            } else if (lo_transacao.TransacaoCartaoGet().is_tipo == null) {
                throw new VeSPagueProcessamentoException(VeSPagueMessageOld.MessageGet((int)141));
            }
            VSPagueClientTaxaResponse lo_response = null;
            try {
                lo_response = this.AdquirenteMelhorTaxaBuscar(lo_transacao, this.io_transaction_manager.io_client.PinpadGet());
            }
            catch (Throwable ex) {
                LOGGER.error("Erro no processamento da melhor taxa ", ex);
                try {
                    if (this.config.getUrlNataxa() != null) {
                        VBI.Trace((String)("ENVIRONMENT: " + this.config.getEnvironment()));
                        VSPagueHealthCheckManager.EmailEnviar((String)VBIMain.ApplicationGet(), (String)"[V$PagueClient] Sem Acesso ao Nataxa", (String)("Problema ao acessar o Nataxa no terminal " + this.io_transaction_manager.io_client.getEstabelecimento() + "\\" + this.io_transaction_manager.io_client.getLoja() + "\\" + this.io_transaction_manager.io_client.getTerminal() + ":" + "\r\n\r\n" + lo_transacao + "\r\n\r\n" + VeSException.StackGet((Throwable)ex) + "\r\n\r\n" + "Hostname: " + InetAddress.getLocalHost().getHostName().toLowerCase()), (String)"V$PagueClient - Nataxa <noreply@nexu.ca>", null, (String)this.config.getEnvironment(), (boolean)true);
                    }
                }
                catch (Throwable ex1) {
                    ex1.printStackTrace();
                }
            }
            if (lo_pinpad != null) {
                String ls_adquirente = lo_pinpad.AcquirerGet(lo_pinpad.in_cartao_rede_adquirente, lo_pinpad.in_cartao_registro_indice);
                if (lo_response != null && lo_response.getData() != null && lo_response.getData().getAcquirer() != null) {
                    String ls_adquirente_nataxa = VeSString.CapitalLetterInitiateSet((String)lo_response.getData().getAcquirer());
                    Double ln_fee = lo_response.getData().getFee();
                    lo_transacao.in_transacao_taxa = new VeSDecimal(ln_fee.doubleValue());
                    if (!ls_adquirente_nataxa.equals(ls_adquirente)) {
                        this.Log("[Nataxa] " + ls_adquirente_nataxa + "/" + ln_fee);
                        ls_adquirente = ls_adquirente_nataxa;
                        VeSPagueConfiguracaoParametro[] lo_cfg_adquirentes = this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().io_cfg_parametro;
                        int ln_adquirente = 0;
                        while (ln_adquirente < lo_cfg_adquirentes.length && !lo_cfg_adquirentes[ln_adquirente].io_valor_loja_rede.is_rede.equals(ls_adquirente)) {
                            ++ln_adquirente;
                        }
                        if (ln_adquirente >= lo_cfg_adquirentes.length) {
                            VeSPagueMessageOld lo_message = VeSPagueMessageOld.MessageGet((int)134);
                            throw new RuntimeException("[" + lo_message.CodeGet() + "] " + lo_message.toString(new Object[]{ls_adquirente}));
                        }
                        String ls_aid = lo_transacao.TransacaoCartaoGet().is_aid;
                        String ls_tipo_cartao = lo_transacao.TransacaoCartaoGet().is_tipo;
                        VeSPagueValorLojaRedeConfiguracao.Chip[] lo_lst_chip = lo_cfg_adquirentes[ln_adquirente].io_valor_loja_rede.io_chip;
                        int ln_chip = 0;
                        while (!(ln_chip >= lo_lst_chip.length || lo_lst_chip[ln_chip].is_application_identifier.equals(ls_aid) && lo_lst_chip[ln_chip].is_tipo_cartao.equals(ls_tipo_cartao))) {
                            ++ln_chip;
                        }
                        if (ln_chip >= lo_lst_chip.length) {
                            VeSPagueMessageOld lo_message = VeSPagueMessageOld.MessageGet((int)118);
                            throw new RuntimeException("[" + lo_message.CodeGet() + "] " + lo_message.toString(new Object[]{ls_adquirente, ls_aid}));
                        }
                        lo_pinpad.in_cartao_rede_adquirente = lo_cfg_adquirentes[ln_adquirente].io_valor_loja_rede.io_configuracao.in_emv_identificacao;
                        lo_pinpad.in_cartao_registro_indice = lo_lst_chip[ln_chip].in_aid_index;
                        this.NfcAdquirenteEscolhidaValidar(lo_pinpad, ls_adquirente);
                    } else {
                        this.Log("[Nataxa/PINPad] " + ls_adquirente_nataxa + "/" + ln_fee);
                    }
                } else {
                    this.Log("[PINPad] " + ls_adquirente);
                }
                this.setText(ls_adquirente);
            } else {
                this.Log("[E-commerce] Adquirente " + null);
            }
        }
    }

    private final void NfcAdquirenteEscolhidaValidar(VeSPaguePinpad ao_pinpad, String as_adquirente) throws VeSPagueProcessamentoException {
        String ls_entrada_cartao = this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_entrada;
        if ("Contactless".equals(ls_entrada_cartao)) {
            VeSPagueConfiguracaoParametro[] lo_cfg_adquirentes = this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().io_cfg_parametro;
            int ln_adquirente = 0;
            while (ln_adquirente < lo_cfg_adquirentes.length && !lo_cfg_adquirentes[ln_adquirente].io_valor_loja_rede.is_rede.equals(as_adquirente)) {
                ++ln_adquirente;
            }
            String ls_rede = lo_cfg_adquirentes[ln_adquirente].io_valor_loja_rede.is_rede;
            String ls_rede_versao = lo_cfg_adquirentes[ln_adquirente].io_valor_loja_rede.is_rede_versao;
            Set lo_stt_rede_entrada = this.io_transaction_manager.DatastoreGet().CartaoEntradaTipoDisponivel(ls_rede, ls_rede_versao);
            boolean lb_aid_permite_contactless = this.AidPermiteContactlessGet(ao_pinpad.in_cartao_rede_adquirente.intValue(), ao_pinpad.in_cartao_registro_indice.intValue());
            if (!lo_stt_rede_entrada.contains("Contactless") || !lb_aid_permite_contactless) {
                try {
                    this.io_transaction_manager.io_client.PinpadGet().PP_Display(" UTILIZE CART\u00c3O     COM CHIP    ");
                    Thread.sleep(1000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.io_transaction_manager.io_client.PinpadGet().in_cartao_contactless_situacao = 9;
                this.io_transaction_manager.io_wn_processar.ComponenteRetroceder(VSPagueCampoCartaoNumero.class);
                this.io_transaction_manager.io_wn_processar.ProximoComponentIr();
            }
        }
    }

    protected String FixedValueGet() {
        return null;
    }

    protected void DadoSet(String as_adquirente) {
        this.io_transaction_manager.TransactionGet().is_rede = as_adquirente;
        VeSPaguePinpad lo_pinpad = this.io_transaction_manager.io_client.PinpadGet();
        if (lo_pinpad != null) {
            try {
                this.io_transaction_manager.io_datastore.CartaoNumeroFiltrar(lo_pinpad.is_cartao_numero, true);
            }
            catch (VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException ex) {
                VeSPagueMessageOld lo_message = VeSPagueMessageOld.MessageGet((int)136);
                LOGGER.error(lo_message.MessageGet(), (Throwable)ex);
                throw new RuntimeException("[" + lo_message.CodeGet() + "] " + lo_message.MessageGet());
            }
        }
    }

    public final boolean isCollect() {
        return this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().getLayout() <= 1 && this.io_transaction_manager.DatastoreGet().MelhorTaxaHabilitar();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private VSPagueClientTaxaResponse AdquirenteMelhorTaxaBuscar(VeSPagueTransacao ao_transacao, VeSPaguePinpad ao_pinpad) throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException, VeSPagueProcessamentoException, VeSPinpadCompartilhado.VeSPinpadCompartilhadoNoApplicationException, IOException {
        List lo_lst_adquirente;
        VeSInteger ln_parcela;
        VSPagueClientTaxaRequest lo_nataxa = new VSPagueClientTaxaRequest();
        Data lo_data = new Data();
        Card lo_card = new Card();
        String ls_bandeira = this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_administradora;
        String ls_tipo_cartao = this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_tipo;
        VeSInteger veSInteger = ln_parcela = this.io_transaction_manager.TransactionGet().in_parcelas != null ? this.io_transaction_manager.TransactionGet().in_parcelas : VeSInteger.ONE;
        if (ls_bandeira == null && ao_pinpad != null) {
            int ln_rede_index = this.io_transaction_manager.DatastoreGet().EMVIndexToNet(ao_pinpad.in_cartao_rede_adquirente.intValue(), ao_pinpad.in_cartao_registro_indice.intValue());
            int ln_aid_index = this.io_transaction_manager.DatastoreGet().AIDIndexToArrayIndex(ln_rede_index, ao_pinpad.in_cartao_registro_indice.intValue());
            VeSPagueValorLojaRedeConfiguracao lo_cfg_adquirente = this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().io_cfg_parametro[ln_rede_index].io_valor_loja_rede;
            String ls_aid = lo_cfg_adquirente.io_chip[ln_aid_index].is_application_identifier;
            VSPagueCartaoBandeiraAid[] lo_lst_aid = this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().io_cfg_application_identifier;
            int ln_1 = 0;
            while (ln_1 < lo_lst_aid.length && !lo_lst_aid[ln_1].ApplicationIdentifierGet().equalsIgnoreCase(ls_aid)) {
                ++ln_1;
            }
            if (ln_1 >= lo_lst_aid.length) {
                throw new VeSPinpadCompartilhado.VeSPinpadCompartilhadoNoApplicationException(VeSPagueMessageOld.MessageGet((int)118).MessageGet());
            }
            if (this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_aid != null && !lo_lst_aid[ln_1].ApplicationIdentifierGet().equals(this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_aid)) {
                throw new VeSPinpadCompartilhado.VeSPinpadCompartilhadoNoApplicationException(VeSPagueMessageOld.MessageGet((int)134).toString(new Object[]{lo_cfg_adquirente.is_rede}));
            }
            this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_aid = lo_lst_aid[ln_1].ApplicationIdentifierGet();
            ls_bandeira = lo_lst_aid[ln_1].BandeiraGet();
            lo_card.setBrand(ls_bandeira.toUpperCase());
            ls_tipo_cartao = ls_tipo_cartao == null ? lo_lst_aid[ln_1].TipoCartaoGet() : ls_tipo_cartao;
            Expiration lo_exp = new Expiration();
            lo_exp.setMonth(Integer.parseInt(ao_pinpad.id_cartao_validade.toString("MM")));
            lo_exp.setYear(Integer.parseInt(ao_pinpad.id_cartao_validade.toString("yyyy")));
            lo_card.setExpiration(lo_exp);
        } else if (ls_bandeira != null) {
            lo_card.setBrand(ls_bandeira.toUpperCase());
        }
        if (this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_cartao_numero != null) {
            lo_card.setIIN(this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_cartao_numero.substring(0, 6));
        }
        lo_card.setEntryType((char)("Digitado".equals(this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_entrada) ? 68 : ("Magn\u00e9tico".equals(this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_entrada) ? 77 : ("Circuito Integrado".equals(this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_entrada) ? 73 : (int)("Contactless".equals(this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_entrada) ? Character.valueOf('C') : null).charValue()))));
        Transaction lo_transaction = new Transaction();
        lo_transaction.setType(VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_CREDITO.equals(ls_tipo_cartao) ? "CREDIT" : "DEBIT");
        lo_transaction.setInstallments(ln_parcela.intValue());
        lo_transaction.setAmount(this.io_transaction_manager.TransactionGet().ValorTotalGet().intValue());
        Merchant lo_merchant = new Merchant();
        lo_merchant.setMCC(this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().io_cfg_loja.getMcc().intValue());
        String ls_cnpj_cpf = this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().io_cfg_loja.getCnpjCpf();
        if (ls_cnpj_cpf != null) {
            if (ls_cnpj_cpf.length() > 14) {
                lo_merchant.setCNPJ(ls_cnpj_cpf);
            } else {
                lo_merchant.setCPF(ls_cnpj_cpf);
            }
        }
        VeSPagueConfiguracaoParametro[] lo_cfg_adquirentes = this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().io_cfg_parametro;
        if (VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_DEBITO.equals(ls_tipo_cartao) && this.io_transaction_manager.DatastoreGet().getAidsEspeciais().contains(this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_aid)) {
            this.Log("Este cart\u00e3o \u00e9 DEBIT MASTERCARD: " + this.io_transaction_manager.TransactionGet().TransacaoCartaoGet().is_aid);
            this.Log("Adquirentes na configura\u00e7\u00e3o: " + lo_cfg_adquirentes.length);
            lo_lst_adquirente = this.io_transaction_manager.DatastoreGet().DebitMastercardHabilitar();
            this.Log("Adquirentes que processam DEBIT MASTERCARD: " + VeSUtil.ArrayToString((Object[])lo_lst_adquirente.toArray()));
            if (lo_lst_adquirente.isEmpty()) {
                throw new VeSPagueProcessamentoException(VeSPagueMessageOld.MessageGet((int)156));
            }
        } else {
            lo_lst_adquirente = new ArrayList(this.io_transaction_manager.DatastoreGet().listarRedesPorAid(ao_transacao.TransacaoCartaoGet().is_aid));
        }
        lo_merchant.setAcquirers(lo_lst_adquirente.toArray(new String[0]));
        lo_data.setCard(lo_card);
        lo_data.setTransaction(lo_transaction);
        lo_data.setMerchant(lo_merchant);
        lo_nataxa.setData(lo_data);
        VSPagueClientTaxaResponse lo_response = null;
        ConfigurationInstance configurationInstance = this.io_transaction_manager.configurationInstance;
        if (configurationInstance != null && configurationInstance.getConfiguration().isPresent() && ((Configuration)configurationInstance.getConfiguration().get()).isNataxaEmbedded().orElse(false).booleanValue()) {
            try {
                lo_response = this.io_transaction_manager.io_client_to_server.consultaMelhorTaxa(lo_nataxa);
                if (lo_response == null) return lo_response;
                this.Log("Ok (200): OK");
                return lo_response;
            }
            catch (Exception e) {
                LOGGER.error("Erro (falha no processamento da melhor taxa)", (Throwable)e);
                return null;
            }
        } else {
            GsonBuilder lo_builder = new GsonBuilder();
            lo_builder.setLenient();
            Gson lo_json = lo_builder.create();
            int ln_tentativa_token = 0;
            do {
                HttpsURLConnection lo_https = this.Connect();
                String ls_json = lo_json.toJson((Object)lo_nataxa);
                this.Request(lo_https, ls_json);
                String ls_response = this.Response(lo_https, true);
                if (!ls_response.isEmpty()) {
                    lo_response = (VSPagueClientTaxaResponse)lo_json.fromJson(ls_response, VSPagueClientTaxaResponse.class);
                }
                if (lo_https.getResponseCode() == 200 || lo_https.getResponseCode() == 201 || lo_https.getResponseCode() == 204) {
                    this.Log("Ok (" + lo_https.getResponseCode() + "): " + lo_https.getResponseMessage());
                    continue;
                }
                this.Log(" Erro (" + lo_https.getResponseCode() + "): " + lo_https.getResponseMessage());
            } while (this.config.getToken() == null && ++ln_tentativa_token < 2);
            if (this.config.getToken() != null) return lo_response;
            this.Log("Token n\u00e3o recebido ap\u00f3s " + ln_tentativa_token + " tentativas no servidor de autentica\u00e7\u00e3o (" + this.config.getUrlAutenticacao() + ")");
        }
        return lo_response;
    }

    private final void TokenCreate() throws IOException {
        GsonBuilder lo_builder = new GsonBuilder();
        lo_builder.setLenient();
        Gson lo_json = lo_builder.create();
        VSPagueClientTaxaRequest lo_nataxa = new VSPagueClientTaxaRequest();
        Data lo_data = new Data();
        lo_data.setPassword(this.config.getPassword());
        lo_nataxa.setData(lo_data);
        HttpsURLConnection lo_https = (HttpsURLConnection)new URL(this.config.getUrlAutenticacao()).openConnection();
        lo_https.setDoOutput(true);
        lo_https.setRequestMethod("POST");
        lo_https.addRequestProperty("Content-Type", "application/json");
        lo_https.connect();
        String ls_json = lo_json.toJson((Object)lo_nataxa);
        lo_https.getOutputStream().write(ls_json.getBytes());
        VSPagueClientTokenCreateResponse lo_token = (VSPagueClientTokenCreateResponse)lo_json.fromJson(this.Response(lo_https, false), VSPagueClientTokenCreateResponse.class);
        if (lo_https.getResponseCode() == 200 || lo_https.getResponseCode() == 201) {
            this.config.setToken(lo_token.getData());
            this.Log("Token atualizado (" + lo_https.getResponseCode() + "): " + lo_https.getResponseMessage());
        } else {
            this.Log("Erro (" + lo_https.getResponseCode() + "): " + lo_https.getResponseMessage());
        }
    }

    private final HttpsURLConnection Connect() throws IOException {
        if (this.config.getToken() == null) {
            this.TokenCreate();
        }
        HttpsURLConnection lo_https = (HttpsURLConnection)new URL(this.config.getUrlNataxa()).openConnection();
        lo_https.setDoOutput(true);
        lo_https.setConnectTimeout(15000);
        lo_https.setReadTimeout(15000);
        lo_https.setRequestMethod("POST");
        lo_https.addRequestProperty("Authorization", this.config.getToken());
        lo_https.addRequestProperty("Content-Type", "application/json");
        lo_https.connect();
        return lo_https;
    }

    private final void Request(HttpsURLConnection ao_connection, String as_json) throws IOException {
        this.Log(as_json);
        ao_connection.getOutputStream().write(as_json.getBytes());
    }

    private final String Response(HttpsURLConnection ao_connection, boolean ab_trace) throws IOException {
        StringBuilder lo_response = new StringBuilder();
        try {
            BufferedReader lo_reader = new BufferedReader(new InputStreamReader(ao_connection.getInputStream()));
            String ls_line = null;
            while ((ls_line = lo_reader.readLine()) != null) {
                lo_response.append(ls_line);
            }
            String ls_response = lo_response.toString();
            if (ab_trace && ls_response.length() > 0) {
                this.Log(ls_response);
            }
        }
        catch (Throwable ex) {
            if (ao_connection.getResponseCode() == 401) {
                this.config.setToken(null);
                ao_connection.disconnect();
            }
            throw ex;
        }
        return lo_response.toString();
    }

    private final boolean AidPermiteContactlessGet(int an_cartao_rede_adquirente, int an_cartao_registro_indice) throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        int ln_rede_index = this.io_transaction_manager.DatastoreGet().EMVIndexToNet(an_cartao_rede_adquirente, an_cartao_registro_indice);
        int ln_aid_index = this.io_transaction_manager.DatastoreGet().AIDIndexToArrayIndex(ln_rede_index, an_cartao_registro_indice);
        VeSPagueValorLojaRedeConfiguracao lo_cfg_adquirente = this.io_transaction_manager.DatastoreGet().ConfiguracaoDataGet().io_cfg_parametro[ln_rede_index].io_valor_loja_rede;
        VeSPagueValorLojaRedeConfiguracao.Chip lo_chip = lo_cfg_adquirente.io_chip[ln_aid_index];
        this.Log("EMV " + an_cartao_rede_adquirente + " | \u00cdndice AID " + an_cartao_registro_indice + " | AID " + lo_chip.is_application_identifier + " | NFC " + lo_chip.ib_contactless);
        return lo_chip.ib_contactless != null && lo_chip.ib_contactless != false;
    }

    private final void Log(String as_log) {
        LOGGER.info("Nataxa [" + this.io_transaction_manager.io_client.getEstabelecimento() + "\\" + this.io_transaction_manager.io_client.getLoja() + "\\" + this.io_transaction_manager.io_client.getTerminal() + "] " + as_log);
    }
}

