/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.graphic.transacao.conta;

import lib.type.VBIDatetime;
import vespague.client.graphic.VeSPagueCampoBaseDataGenerico;
import vespague.client.graphic.VeSPagueClient;
import vespague.client.graphic.VeSPagueComponentRetypeable;
import vespague.client.graphic.VeSPagueNoFocusChangeSign;
import vespague.client.graphic.transacao.conta.VeSPagueWindowContaConfirmar;
import vespague.common.VeSPagueClientUtil;
import vespague.common.type.VeSPagueMessageOld;
import vespague.exception.VeSPagueProcessamentoException;
import vespague.structure.VeSPagueTransacao;

public final class VeSPagueCampoContaVencimento
extends VeSPagueCampoBaseDataGenerico {
    private VeSPagueTransacao.TransacaoConta io_conta;

    public VeSPagueCampoContaVencimento(VeSPagueTransacao.TransacaoConta ao_conta) {
        super(69, null, "dd/MM/yy", "Vencimento");
        this.io_conta = ao_conta;
    }

    protected void DadoSet(VBIDatetime ad_dado) {
        this.io_conta.id_vencimento_data = ad_dado;
    }

    protected VBIDatetime FixedValueGet() {
        return this.io_conta.id_vencimento_data;
    }

    public void DadoConsistir() throws VeSPagueProcessamentoException, VeSPagueNoFocusChangeSign {
        this.PagamentoBoletoVencidoVerificar();
        try {
            if (this.getDate() == null || this.getTextTrim().length() < 8) {
                throw new VeSPagueNoFocusChangeSign();
            }
            super.DadoConsistir();
            if (this.isEnabled()) {
                if (this.io_conta.id_vencimento_data == null && this.io_transaction_manager.io_datastore.ContaVencimentoNecessidadeConfirmacaoVerificar() && VeSPagueClient.VISIBLE) {
                    boolean lb_status = new VeSPagueWindowContaConfirmar(this.io_transaction_manager, this.getText(), (VeSPagueComponentRetypeable)this).InternalShow();
                    if (lb_status) {
                        this.setEnabled(false);
                    } else {
                        throw new VeSPagueNoFocusChangeSign();
                    }
                }
                if (this.io_conta == null || this.io_conta.ib_vencimento_alterar == null || !this.io_conta.ib_vencimento_alterar.booleanValue()) {
                    super.DadoConsistir();
                    this.setEnabled(false);
                } else if (this.io_conta.ib_vencimento_alterar.booleanValue()) {
                    if (VeSPagueClient.VISIBLE) {
                        this.io_conta.ib_vencimento_alterar = false;
                    }
                    throw new VeSPagueNoFocusChangeSign();
                }
            }
        }
        catch (VeSPagueProcessamentoException ao_ex_formato_invalido) {
            if (this.getDate() != null) {
                throw new VeSPagueProcessamentoException(VeSPagueMessageOld.MessageGet((int)34).toString(new Object[]{"Vencimento da conta"}));
            }
            throw ao_ex_formato_invalido;
        }
    }

    public void PreConsistenciaFazer() throws VeSPagueProcessamentoException {
        if (this.isCollect()) {
            if (!VeSPagueClient.VISIBLE && this.FixedValueGet() == null) {
                this.DadoColetar("transacao_vencimento", "dd/MM/yy");
                this.transferFocus();
            }
            super.PreConsistenciaFazer();
            if (this.io_conta.ib_vencimento_alterar != null && this.io_conta.ib_vencimento_alterar.booleanValue()) {
                this.setEnabled(true);
            }
            if (this.io_conta.id_vencimento_data == null && this.io_transaction_manager.io_datastore.UniqueAcquirer(VeSPagueClientUtil.TRANSACAO_REDE_USEREDE)) {
                this.setText(new VBIDatetime().toString("dd/MM/yy"));
            }
        } else {
            this.setVisible(false);
        }
    }

    public boolean isCollect() {
        return this.io_transaction_manager.io_datastore.TransacaoContaVencimentoColetaVerificar();
    }

    private final void PagamentoBoletoVencidoVerificar() {
        VBIDatetime ld_data_atual = new VBIDatetime(new VBIDatetime().toString("yyyy-MM-dd"));
        if (!this.io_transaction_manager.io_datastore.BoletoVencidoPagamentoPermitir() && (this.io_conta.id_vencimento_data != null && this.io_conta.id_vencimento_data.Before(ld_data_atual) || this.getDate() != null && this.getDate().Before(ld_data_atual))) {
            VeSPagueClient veSPagueClient = this.io_transaction_manager.io_client;
            veSPagueClient.getClass();
            new VeSPagueClient.V.PagueClientWindowException(veSPagueClient, this.io_transaction_manager.TransactionGet().is_tipo, null, Boolean.valueOf(VeSPagueClient.VISIBLE), (Throwable)new VeSPagueProcessamentoException("N\u00e3o permitido pagamento de boletos vencidos."));
            this.io_transaction_manager.io_wn_processar.TodosComponentesRemover();
            this.io_transaction_manager.io_wn_processar.AbortAndClose();
        }
    }
}

