/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.graphic.transacao.fidelidade;

import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import lib.ValidadorCpfCnpj;
import lib.type.VeSMethod;
import vespague.automation.VeSPagueClientToAutomation;
import vespague.client.device.VeSPaguePinpad;
import vespague.client.graphic.VeSPagueCampoBaseTextoGenerico;
import vespague.client.graphic.VeSPagueClient;
import vespague.client.graphic.VeSPagueNoFocusChangeSign;
import vespague.client.graphic.transacao.VeSPagueWindowProcessar;
import vespague.client.graphic.transacao.VeSPagueWindowTransacaoProcessar;
import vespague.client.lib.graphic.window.ClientWindowProgress;
import vespague.client.lib.graphic.window.VBIWindowMessage;
import vespague.common.VeSPagueClientUtil;
import vespague.exception.VeSPagueClientException;
import vespague.exception.VeSPagueProcessamentoException;
import vespague.structure.VBIMensagem;

/*
 * Exception performing whole class analysis ignored.
 */
public final class V$PagueCampoFidelidadeCPF
extends VeSPagueCampoBaseTextoGenerico {
    private static final String MENSAGEM_CPF_SOLICITAR = "Solicite a verifica\u00e7\u00e3o do CPF ao cliente e logo ap\u00f3s a confirma\u00e7\u00e3o.";
    private static final String MENSAGEM_TRANSACAO_CANCELADA = "Transa\u00e7\u00e3o cancelada pelo portador do cart\u00e3o.";
    private static final String MENSAGEM_CONECT_PINPAD = "Conecte o PIN-Pad para efetuar esta transa\u00e7\u00e3o.";
    private static final String MENSAGEM_CPF_INVALIDO = "Campo CPF deve conter no m\u00ednimo 11 d\u00edgitos.";

    private static String getMaskDefault() {
        return "###.###.###-##";
    }

    public V$PagueCampoFidelidadeCPF() {
        super(117, 11, V$PagueCampoFidelidadeCPF.getMaskDefault(), "CPF");
    }

    protected final void DadoSet(String as_dado) {
        this.io_transaction_manager.TransactionGet().TransacaoFidelidadeGet().is_cpf_portador = as_dado;
    }

    public final void DadoConsistir() throws VeSPagueProcessamentoException, VeSPagueNoFocusChangeSign {
        String numeroCPF = this.getTextTrim().replaceAll("[^0-9]", "");
        if (numeroCPF.length() > 0) {
            this.consisteNumeroCpf(numeroCPF);
            super.DadoConsistir();
        } else {
            this.coletaPinpadModoGrafico();
        }
    }

    public final void PreConsistenciaFazer() throws VeSPagueProcessamentoException {
        boolean lb_coletar = this.isCollect();
        this.setVisible(VeSPagueClient.VISIBLE ? lb_coletar : false);
        if (lb_coletar) {
            if (this.FixedValueGet() != null) {
                this.consisteNumeroCpf(this.FixedValueGet());
            } else if (!this.isVisible()) {
                this.DadoColetar("transacao_fidelidade_cpf_portador", null);
                this.transferFocus();
            }
            super.PreConsistenciaFazer();
        }
    }

    public final void DadoGravar() throws VeSPagueProcessamentoException {
        super.DadoGravar();
        if (this.io_transaction_manager.TransactionGet().TransacaoFidelidadeGet().is_cpf_portador != null) {
            this.io_transaction_manager.io_datastore.FidelidadeCPFFiltrar();
        }
    }

    public final boolean isCollect() {
        return this.io_transaction_manager.io_datastore.FidelidadeCPFVerificar();
    }

    protected final String FixedValueGet() {
        return this.ParametersGet().TransacaoFidelidadeGet().is_cpf_portador;
    }

    public void DadoColetar(String keyword, String mascara) throws VeSPagueProcessamentoException {
        try {
            boolean coletaFinalizada = false;
            while (!coletaFinalizada) {
                VeSPagueClientToAutomation pacoteAutomacaoSend = new VeSPagueClientToAutomation("");
                VeSPagueClientToAutomation pacoteAutomacaoReceive = new VeSPagueClientToAutomation("");
                pacoteAutomacaoSend.automacao_coleta_retorno = VeSPagueClientUtil.RETURN_CODE_SUCESS_CONFIRMATION;
                pacoteAutomacaoSend.automacao_coleta_mensagem = new String[]{this.getName()};
                pacoteAutomacaoSend.automacao_coleta_tipo = "N";
                pacoteAutomacaoSend.automacao_coleta_mascara = V$PagueCampoFidelidadeCPF.getMaskDefault();
                if (keyword != null) {
                    if (!keyword.equals(this.getName())) {
                        pacoteAutomacaoSend.automacao_coleta_palavra_chave = keyword;
                    } else {
                        LOGGER.warn("Campo \"" + this.getClass().getCanonicalName() + "\" est\u00e1 passando novamente o t\u00edtulo do campo ao inv\u00e9s da palavra-chave");
                    }
                }
                this.io_transaction_manager.io_client_to_server.io_client_automation_interaction.Send(pacoteAutomacaoSend, Integer.valueOf((int)TimeUnit.SECONDS.toMillis(120L)), true, null);
                pacoteAutomacaoReceive = this.io_transaction_manager.io_client_to_server.io_client_automation_interaction.RespostaAplicacaoComercialConsistir(pacoteAutomacaoSend.automacao_coleta_sequencial, VeSPagueClientUtil.RETURN_CODE_SUCESS_CONFIRMATION);
                if (pacoteAutomacaoReceive.automacao_coleta_informacao != null && !pacoteAutomacaoReceive.automacao_coleta_informacao.isEmpty()) {
                    this.setEnabled(false);
                    this.setText(pacoteAutomacaoReceive.automacao_coleta_informacao);
                    this.DadoConsistir();
                    coletaFinalizada = true;
                    continue;
                }
                try {
                    coletaFinalizada = this.coletaPinpad();
                    if (coletaFinalizada) continue;
                    coletaFinalizada = false;
                }
                catch (Exception ex) {
                    throw new VeSPagueClientException((Throwable)ex);
                }
            }
        }
        catch (VeSPagueNoFocusChangeSign | VeSPagueClientException ex) {
            throw new VeSPagueProcessamentoException(ex);
        }
    }

    private boolean coletaPinpad() throws Exception {
        VeSPaguePinpad pinpad = this.io_transaction_manager.io_client.PinpadGet();
        if (pinpad != null && pinpad.is_pinpad_especificacao_versao.charAt(0) > '1') {
            int minDigitos = 11;
            int maxDigitos = 11;
            int timeout = 60;
            String dadoColetado = null;
            this.mensagemInformacao("Coletando CPF para acumulo de pontos");
            while (dadoColetado == null) {
                try {
                    dadoColetado = pinpad.servicoColetar("0007", minDigitos, maxDigitos, timeout);
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage());
                }
                if (dadoColetado != null) {
                    try {
                        if (dadoColetado.length() <= 0 || ValidadorCpfCnpj.cpfCnpjValidar((String)dadoColetado).isEmpty()) continue;
                        this.ParametersGet().TransacaoFidelidadeGet().is_cpf_portador = dadoColetado;
                        this.setText(dadoColetado);
                        return true;
                    }
                    catch (Exception ex) {
                        dadoColetado = null;
                        pinpad.PP_Display("CPF INVALIDO");
                        if (VeSPagueClient.VISIBLE) {
                            VBIMensagem mensagem = new VBIMensagem(2, VBIWindowMessage.OK_OPTIONS);
                            mensagem.setOpcaoPadrao((Object)VBIWindowMessage.OK_OPTIONS);
                            mensagem.setMensagem((Object)"CPF inv\u00e1lido, tente novamente");
                            this.mensagemOperador(mensagem);
                            continue;
                        }
                        VeSPagueClientToAutomation automationSend = new VeSPagueClientToAutomation("");
                        automationSend.automacao_coleta_retorno = VeSPagueClientUtil.RETURN_CODE_SUCESS_CONFIRMATION;
                        automationSend.automacao_coleta_mensagem = new String[]{"CPF inv\u00e1lido, tente novamente"};
                        this.io_transaction_manager.io_client_to_server.io_client_automation_interaction.Send(automationSend, Integer.valueOf(0), true, null);
                        this.io_transaction_manager.io_client_to_server.io_client_automation_interaction.RespostaAplicacaoComercialConsistir(automationSend.automacao_coleta_sequencial, VeSPagueClientUtil.RETURN_CODE_SUCESS_CONFIRMATION);
                        continue;
                    }
                }
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void coletaPinpadModoGrafico() throws VeSPagueNoFocusChangeSign, VeSPagueProcessamentoException {
        block7: {
            if (this.isVisible()) {
                ClientWindowProgress window = null;
                try {
                    window = new ClientWindowProgress(this.ParametersGet().is_tipo, null, "Coletando CPF para acumulo de pontos", false, this.isVisible());
                    VeSMethod metodoColetaInformacoesPinpad = new VeSMethod((Object)this, "coletaPinpad", null);
                    try {
                        window.MethodExecute(metodoColetaInformacoesPinpad, null);
                    }
                    catch (Exception e) {
                        if (VeSPagueClient.VISIBLE) {
                            VeSPagueClient veSPagueClient = this.io_transaction_manager.io_client;
                            veSPagueClient.getClass();
                            new VeSPagueClient.V.PagueClientWindowException(veSPagueClient, (Throwable)e);
                            this.coletaEncerrar();
                            break block7;
                        }
                        VeSPagueClient veSPagueClient = this.io_transaction_manager.io_client;
                        veSPagueClient.getClass();
                        new VeSPagueClient.V.PagueClientWindowException(veSPagueClient, null, "Transa\u00e7\u00e3o cancelada", Boolean.valueOf(false), null);
                        this.io_transaction_manager.io_wn_processar.TodosComponentesRemover();
                    }
                }
                finally {
                    window.WindowClose();
                }
            }
        }
    }

    private void mensagemInformacao(String as_message) {
        if (!this.isVisible()) {
            VeSPagueClientToAutomation sendAutomacao = new VeSPagueClientToAutomation("");
            sendAutomacao.automacao_coleta_retorno = VeSPagueClientUtil.RETURN_CODE_SUCESS_CONFIRMATION;
            sendAutomacao.automacao_coleta_mensagem = new String[]{as_message};
            try {
                this.io_transaction_manager.io_client_to_server.io_client_automation_interaction.Send(sendAutomacao, Integer.valueOf(0), true, null);
                this.io_transaction_manager.io_client_to_server.io_client_automation_interaction.RespostaAplicacaoComercialConsistir(sendAutomacao.automacao_coleta_sequencial, VeSPagueClientUtil.RETURN_CODE_SUCESS_CONFIRMATION);
            }
            catch (Exception ex) {
                VeSPagueClient veSPagueClient = this.io_transaction_manager.io_client;
                veSPagueClient.getClass();
                new VeSPagueClient.V.PagueClientWindowException(veSPagueClient, (Throwable)ex);
                this.io_transaction_manager.io_wn_processar.TodosComponentesRemover();
            }
        }
    }

    private void consisteNumeroCpf(String cpf) throws VeSPagueProcessamentoException {
        String numeroCPF = cpf.replaceAll("[^0-9]", "");
        try {
            if (numeroCPF.length() > 0) {
                ValidadorCpfCnpj.cpfCnpjValidar((String)numeroCPF);
            }
        }
        catch (Exception ex) {
            throw new VeSPagueProcessamentoException("Campo CPF inv\u00e1lido.", 30106);
        }
    }

    private void coletaEncerrar() {
        VeSPagueWindowTransacaoProcessar.ComponentSendCommandToItsWindow((JComponent)this, (Object)VeSPagueWindowProcessar.COMMAND_ABORT_AND_CLOSE_WINDOW);
    }
}

