/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.interaction;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import lib.file.VBIFile;
import lib.type.VBIDatetime;
import lib.type.VBIPeriod;
import lib.type.VeSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vespague.client.interaction.IUpdateConfiguration;
import vespague.client.interaction.StatusUpdateConfiguration;
import vespague.common.VeSPagueClientUtil;
import vespague.structure.VeSPagueActivate;
import vespague.structure.VeSPagueConfiguracaoData;
import vespague.structure.VeSPagueConfiguracaoParametro;

/*
 * Exception performing whole class analysis ignored.
 */
class UnmountServiceActivate {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnmountServiceActivate.class);

    UnmountServiceActivate() {
    }

    public static VeSPagueConfiguracaoData unmount(VeSPagueConfiguracaoData dataConfigurationDisk, VeSPagueActivate activate, int layout, String dataConfigurationName, IUpdateConfiguration statusUpdateControler) throws VBIFile.VBIFileFileNotFoundException, VBIFile.VBIFileInputOutputException {
        if (dataConfigurationDisk == null) {
            UnmountServiceActivate.saveConfDisk((VeSPagueConfiguracaoData)activate.io_cfg_data, (String)dataConfigurationName);
            return activate.io_cfg_data;
        }
        if (layout == 1) {
            boolean saveDisk;
            if (dataConfigurationDisk.getLayout() != layout) {
                LOGGER.info("conf com layout diferente do que baixou do VSPague Server ({}) e do disco ({})", (Object)activate.io_cfg_data.getLayout(), (Object)dataConfigurationDisk.getLayout());
                dataConfigurationDisk.setLayout(layout);
            }
            if (saveDisk = UnmountServiceActivate.unmountLayoutOne((VeSPagueConfiguracaoData)dataConfigurationDisk, (VeSPagueConfiguracaoData)activate.io_cfg_data)) {
                UnmountServiceActivate.saveConfDisk((VeSPagueConfiguracaoData)dataConfigurationDisk, (String)dataConfigurationName);
            }
            return dataConfigurationDisk;
        }
        if (layout == 2) {
            boolean saveDisk = UnmountServiceActivate.unmountLayoutTwo((VeSPagueConfiguracaoData)dataConfigurationDisk, (VeSPagueConfiguracaoData)activate.io_cfg_data, (IUpdateConfiguration)statusUpdateControler);
            if (saveDisk) {
                UnmountServiceActivate.saveConfDisk((VeSPagueConfiguracaoData)dataConfigurationDisk, (String)dataConfigurationName);
            }
            return dataConfigurationDisk;
        }
        if (layout == 0) {
            UnmountServiceActivate.saveConfDisk((VeSPagueConfiguracaoData)activate.io_cfg_data, (String)dataConfigurationName);
            return activate.io_cfg_data;
        }
        LOGGER.warn("Layout desconhecido para o arquivo de configuracao (.conf). Gravando em disco como foi recebido");
        UnmountServiceActivate.saveConfDisk((VeSPagueConfiguracaoData)activate.io_cfg_data, (String)dataConfigurationName);
        return activate.io_cfg_data;
    }

    private static void saveConfDisk(VeSPagueConfiguracaoData dataConfiguration, String dataConfigurationName) throws VBIFile.VBIFileFileNotFoundException, VBIFile.VBIFileInputOutputException {
        VeSPagueClientUtil.ConfigurationToFile((String)dataConfigurationName, (VeSPagueConfiguracaoData)dataConfiguration, (boolean)false);
    }

    private static boolean unmountLayoutOne(VeSPagueConfiguracaoData dataConfigurationDisk, VeSPagueConfiguracaoData dataConfiguration) {
        boolean saveDisk = false;
        if (dataConfiguration.is_cfg_estabelecimento != null) {
            LOGGER.info("Atualizacao parcial: estabelecimento");
            dataConfigurationDisk.is_cfg_estabelecimento = dataConfiguration.is_cfg_estabelecimento;
            saveDisk = true;
        }
        if (dataConfiguration.io_cfg_loja != null) {
            LOGGER.info("Atualizacao parcial: loja");
            dataConfigurationDisk.io_cfg_loja = dataConfiguration.io_cfg_loja;
            saveDisk = true;
        }
        if (dataConfiguration.io_cfg_terminal != null) {
            if (dataConfiguration.io_cfg_terminal.is_estabelecimento != null && dataConfiguration.io_cfg_terminal.is_loja != null && dataConfiguration.io_cfg_terminal.is_terminal != null) {
                LOGGER.info("Atualizacao parcial: terminal");
                dataConfigurationDisk.io_cfg_terminal = dataConfiguration.io_cfg_terminal;
            } else {
                dataConfigurationDisk.io_cfg_terminal.is_parametros_versao = dataConfiguration.io_cfg_terminal.is_parametros_versao;
            }
            saveDisk = true;
        }
        if (dataConfiguration.io_cfg_parametro != null) {
            LOGGER.info("Atualizacao parcial: adquirentes");
            dataConfigurationDisk.io_cfg_parametro = dataConfiguration.io_cfg_parametro;
            dataConfigurationDisk.in_bits_index = dataConfiguration.in_bits_index;
            dataConfigurationDisk.in_parametros_index = dataConfiguration.in_parametros_index;
            dataConfigurationDisk.is_inactive_acquirer = dataConfiguration.is_inactive_acquirer;
            saveDisk = true;
        }
        if (dataConfiguration.is_cfg_comunicacao != null) {
            LOGGER.info("Atualizacao parcial: comunicacao");
            dataConfigurationDisk.is_cfg_comunicacao = dataConfiguration.is_cfg_comunicacao;
            saveDisk = true;
        }
        if (dataConfiguration.io_lst_device != null) {
            LOGGER.info("Atualizacao parcial: devices");
            dataConfigurationDisk.io_lst_device = dataConfiguration.io_lst_device;
            dataConfigurationDisk.io_hs_terminais = dataConfiguration.io_hs_terminais;
            saveDisk = true;
        }
        if (dataConfiguration.ib_rede_menor_taxa != null) {
            LOGGER.info("Atualizacao parcial: menor taxa");
            dataConfigurationDisk.ib_rede_menor_taxa = dataConfiguration.ib_rede_menor_taxa;
            saveDisk = true;
        }
        if (dataConfiguration.io_cfg_application_identifier != null) {
            LOGGER.info("Atualizacao parcial: AIDs");
            dataConfigurationDisk.io_cfg_application_identifier = dataConfiguration.io_cfg_application_identifier;
            saveDisk = true;
        }
        if (dataConfiguration.getParameterTable() != null && !dataConfiguration.getParameterTable().isEmpty()) {
            LOGGER.info("Atualizacao parcial: parametros de operacao");
            dataConfigurationDisk.setParameterTable(dataConfiguration.getParameterTable());
            saveDisk = true;
        }
        if (dataConfiguration.io_cfg_conciliacao != null) {
            LOGGER.info("Atualizacao parcial: conciliacao");
            dataConfigurationDisk.io_cfg_conciliacao = dataConfiguration.io_cfg_conciliacao;
            saveDisk = true;
        }
        return saveDisk;
    }

    private static boolean unmountLayoutTwo(VeSPagueConfiguracaoData dataConfigurationDisk, VeSPagueConfiguracaoData dataConfiguration, IUpdateConfiguration statusUpdateControler) {
        boolean saveDisk = false;
        if (dataConfiguration.is_cfg_estabelecimento != null) {
            statusUpdateControler.addConfiguration(StatusUpdateConfiguration.ESTABELECIMENTO);
            LOGGER.info("Atualizacao parcial: estabelecimento");
            dataConfigurationDisk.is_cfg_estabelecimento = dataConfiguration.is_cfg_estabelecimento;
            saveDisk = true;
        }
        if (dataConfiguration.io_cfg_loja != null) {
            statusUpdateControler.addConfiguration(StatusUpdateConfiguration.LOJA);
            LOGGER.info("Atualizacao parcial: loja");
            dataConfigurationDisk.io_cfg_loja = dataConfiguration.io_cfg_loja;
            saveDisk = true;
        }
        if (dataConfiguration.io_cfg_terminal != null) {
            if (dataConfiguration.io_cfg_terminal.is_estabelecimento != null && dataConfiguration.io_cfg_terminal.is_loja != null && dataConfiguration.io_cfg_terminal.is_terminal != null) {
                statusUpdateControler.addConfiguration(StatusUpdateConfiguration.TERMINAL);
                LOGGER.info("Atualizacao parcial: terminal");
                dataConfigurationDisk.io_cfg_terminal = dataConfiguration.io_cfg_terminal;
            } else {
                dataConfigurationDisk.io_cfg_terminal.is_parametros_versao = dataConfiguration.io_cfg_terminal.is_parametros_versao;
            }
            saveDisk = true;
        }
        if (dataConfiguration.getAidsEspeciais() != null) {
            statusUpdateControler.addConfiguration(StatusUpdateConfiguration.AIDS_ESPECIAIS);
            LOGGER.info("Atualizacao parcial: aids especiais");
            dataConfigurationDisk.setAidsEspeciais(dataConfiguration.getAidsEspeciais());
            saveDisk = true;
        }
        if (dataConfiguration.io_cfg_application_identifier != null) {
            statusUpdateControler.addConfiguration(StatusUpdateConfiguration.AIDS);
            LOGGER.info("Atualizacao parcial: todos os AIDs");
            dataConfigurationDisk.io_cfg_application_identifier = dataConfiguration.io_cfg_application_identifier;
            saveDisk = true;
        }
        if (dataConfiguration.io_cfg_parametro != null) {
            boolean cargaTabela = Arrays.stream(dataConfiguration.io_cfg_parametro).anyMatch(configuracao -> configuracao.io_valor_loja_rede.is_parametros_AID != null);
            if (cargaTabela) {
                LOGGER.info("Atualizacao parcial: configuracao carga de tabelas");
                statusUpdateControler.addConfiguration(StatusUpdateConfiguration.CARGA_TABELA);
                VBIDatetime versaoCarga = new VBIDatetime().DateGet().Add(new VBIPeriod(0L, 0L, 0L, 1L));
                if (dataConfigurationDisk.getVersaoCargaTabelas() != null && dataConfigurationDisk.getVersaoCargaTabelas().DateGet().compareTo(versaoCarga.DateGet()) == 0) {
                    versaoCarga = dataConfigurationDisk.getVersaoCargaTabelas().Add(new VBIPeriod(0L, 0L, 0L, 1L));
                }
                dataConfigurationDisk.setVersaoCargaTabelas(versaoCarga);
                dataConfigurationDisk.io_cfg_parametro = dataConfiguration.io_cfg_parametro;
                dataConfigurationDisk.in_bits_index = dataConfiguration.in_bits_index;
                dataConfigurationDisk.in_parametros_index = dataConfiguration.in_parametros_index;
                LOGGER.info("Atualizacao parcial: novas configuracoes de carga de tabelas {}", (Object)dataConfigurationDisk.getVersaoCargaTabelas());
            } else {
                boolean configuracaoMenu = Arrays.stream(dataConfiguration.io_cfg_parametro).anyMatch(configuracao -> configuracao.io_valor_loja_rede.is_rede == null && configuracao.io_valor_loja_rede.is_rede_versao == null);
                if (configuracaoMenu) {
                    LOGGER.info("Atualizacao parcial: configuracao menu");
                    VeSPagueConfiguracaoParametro[] veSPagueConfiguracaoParametroArray = dataConfigurationDisk.io_cfg_parametro;
                    int n = dataConfigurationDisk.io_cfg_parametro.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VeSPagueConfiguracaoParametro veSPagueConfiguracaoParametroDisco = veSPagueConfiguracaoParametroArray[n2];
                        VeSPagueConfiguracaoParametro[] veSPagueConfiguracaoParametroArray2 = dataConfiguration.io_cfg_parametro;
                        int n3 = dataConfiguration.io_cfg_parametro.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            VeSPagueConfiguracaoParametro veSPagueConfiguracaoParametroRecebido = veSPagueConfiguracaoParametroArray2[n4];
                            if (veSPagueConfiguracaoParametroRecebido.io_valor_loja_rede.io_configuracao != null && veSPagueConfiguracaoParametroRecebido.io_valor_loja_rede.io_configuracao.is_identificacao_rede != null && veSPagueConfiguracaoParametroRecebido.io_valor_loja_rede.io_configuracao.is_identificacao_rede.equals(String.valueOf(veSPagueConfiguracaoParametroDisco.io_valor_loja_rede.is_rede) + "-" + veSPagueConfiguracaoParametroDisco.io_valor_loja_rede.is_rede_versao)) {
                                Field[] fieldArray = veSPagueConfiguracaoParametroRecebido.io_valor_loja_rede.io_configuracao.getClass().getFields();
                                int n5 = fieldArray.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    Field field = fieldArray[n6];
                                    try {
                                        Field campo = veSPagueConfiguracaoParametroDisco.io_valor_loja_rede.io_configuracao.getClass().getField(field.getName());
                                        if (campo.getType() == Boolean.class) {
                                            Object campoNew = field.get(veSPagueConfiguracaoParametroRecebido.io_valor_loja_rede.io_configuracao);
                                            Object campoOld = field.get(veSPagueConfiguracaoParametroDisco.io_valor_loja_rede.io_configuracao);
                                            if (campoNew != null && !Objects.equals(campoNew, campoOld)) {
                                                LOGGER.info("{} alteracao no campo {}: {}", new Object[]{veSPagueConfiguracaoParametroRecebido.io_valor_loja_rede.io_configuracao.is_identificacao_rede, field.getName(), campoOld + " -> " + campoNew});
                                                campo.set(veSPagueConfiguracaoParametroDisco.io_valor_loja_rede.io_configuracao, field.get(veSPagueConfiguracaoParametroRecebido.io_valor_loja_rede.io_configuracao));
                                            }
                                        }
                                    }
                                    catch (IllegalAccessException | NoSuchFieldException e) {
                                        LOGGER.warn("erro ao atualizar confoguracao de rede: {}", (Object)e.getMessage());
                                    }
                                    ++n6;
                                }
                                break;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                } else {
                    LOGGER.info("Atualizacao parcial: prioridade adquirentes");
                    VeSPagueConfiguracaoParametro[] veSPagueConfiguracaoParametroArray = dataConfiguration.io_cfg_parametro;
                    int n = dataConfiguration.io_cfg_parametro.length;
                    int n7 = 0;
                    while (n7 < n) {
                        VeSPagueConfiguracaoParametro veSPagueConfiguracaoParametroRecebido = veSPagueConfiguracaoParametroArray[n7];
                        VeSPagueConfiguracaoParametro[] veSPagueConfiguracaoParametroArray3 = dataConfigurationDisk.io_cfg_parametro;
                        int n8 = dataConfigurationDisk.io_cfg_parametro.length;
                        int n9 = 0;
                        while (n9 < n8) {
                            VeSPagueConfiguracaoParametro veSPagueConfiguracaoParametroDisco = veSPagueConfiguracaoParametroArray3[n9];
                            if (veSPagueConfiguracaoParametroDisco.io_valor_loja_rede.is_rede.equals(veSPagueConfiguracaoParametroRecebido.io_valor_loja_rede.is_rede) && veSPagueConfiguracaoParametroDisco.io_valor_loja_rede.is_rede_versao.equals(veSPagueConfiguracaoParametroRecebido.io_valor_loja_rede.is_rede_versao) && veSPagueConfiguracaoParametroRecebido.io_valor_loja_rede.in_prioridade != null) {
                                veSPagueConfiguracaoParametroDisco.io_valor_loja_rede.in_prioridade = veSPagueConfiguracaoParametroRecebido.io_valor_loja_rede.in_prioridade;
                                break;
                            }
                            ++n9;
                        }
                        ++n7;
                    }
                }
            }
            if (dataConfigurationDisk.getLayout() != dataConfiguration.getLayout()) {
                LOGGER.info("modificando versao de layout de {} para {}", (Object)dataConfigurationDisk.getLayout(), (Object)dataConfiguration.getLayout());
                UnmountServiceActivate.layoutOneToTwo((VeSPagueConfiguracaoData)dataConfigurationDisk);
            }
            saveDisk = true;
        } else if (dataConfigurationDisk != null && dataConfigurationDisk.getLayout() <= 1 && dataConfiguration.getLayout() >= 2) {
            try {
                UnmountServiceActivate.layoutOneToTwo((VeSPagueConfiguracaoData)dataConfigurationDisk);
                saveDisk = true;
                LOGGER.info(".conf modificado de layout 1 para layout 2");
            }
            catch (Exception e) {
                LOGGER.error("N\u00e3o foi poss\u00edvel gravar o arquivo de configura\u00e7\u00e3o: " + VeSException.MessageGet((Throwable)e), (Throwable)e);
            }
        }
        if (dataConfiguration.is_cfg_comunicacao != null) {
            statusUpdateControler.addConfiguration(StatusUpdateConfiguration.COMUNICACAO_AUTOMACAO);
            LOGGER.info("Atualizacao parcial: comunicacao");
            dataConfigurationDisk.is_cfg_comunicacao = dataConfiguration.is_cfg_comunicacao;
            saveDisk = true;
        }
        if (dataConfiguration.io_lst_device != null) {
            statusUpdateControler.addConfiguration(StatusUpdateConfiguration.PINPAD_LISTA);
            LOGGER.info("Atualizacao parcial: devices");
            dataConfigurationDisk.io_lst_device = dataConfiguration.io_lst_device;
            saveDisk = true;
        }
        if (dataConfiguration.ib_rede_menor_taxa != null) {
            statusUpdateControler.addConfiguration(StatusUpdateConfiguration.MENOR_TAXA);
            LOGGER.info("Atualizacao parcial: menor taxa");
            dataConfigurationDisk.ib_rede_menor_taxa = dataConfiguration.ib_rede_menor_taxa;
            saveDisk = true;
        }
        if (dataConfiguration.getParameterTable() != null && !dataConfiguration.getParameterTable().isEmpty()) {
            statusUpdateControler.addConfiguration(StatusUpdateConfiguration.TABELA_PARAMETROS);
            LOGGER.info("Atualizacao parcial: parametros de operacao");
            dataConfigurationDisk.setParameterTable(dataConfiguration.getParameterTable());
            saveDisk = true;
        }
        if (dataConfiguration.io_cfg_conciliacao != null) {
            LOGGER.info("Atualizacao parcial: conciliacao");
            dataConfigurationDisk.io_cfg_conciliacao = dataConfiguration.io_cfg_conciliacao;
            saveDisk = true;
        }
        return saveDisk;
    }

    public static void layoutOneToTwo(VeSPagueConfiguracaoData veSPagueConfiguracaoData) {
        veSPagueConfiguracaoData.in_bits_index = new int[0][];
        veSPagueConfiguracaoData.in_parametros_index = new int[0][];
        veSPagueConfiguracaoData.io_hs_terminais = null;
        veSPagueConfiguracaoData.setLayout(2);
        VeSPagueConfiguracaoParametro[] veSPagueConfiguracaoParametroArray = veSPagueConfiguracaoData.io_cfg_parametro;
        int n = veSPagueConfiguracaoData.io_cfg_parametro.length;
        int n2 = 0;
        while (n2 < n) {
            VeSPagueConfiguracaoParametro veSPagueConfiguracaoParametro = veSPagueConfiguracaoParametroArray[n2];
            veSPagueConfiguracaoParametro.io_valor_loja_parametro = null;
            veSPagueConfiguracaoParametro.io_valor_loja_bits = null;
            veSPagueConfiguracaoParametro.io_valor_loja_rede.io_hardware_cipher = null;
            veSPagueConfiguracaoParametro.io_valor_loja_rede.io_software_cipher = null;
            veSPagueConfiguracaoParametro.io_valor_loja_rede.io_mensagem = null;
            veSPagueConfiguracaoParametro.io_valor_loja_rede.io_produto = null;
            veSPagueConfiguracaoParametro.io_valor_loja_rede.io_lista_negra = null;
            veSPagueConfiguracaoParametro.io_valor_loja_rede.io_conexao = null;
            veSPagueConfiguracaoParametro.io_valor_loja_rede.io_estabelecimento_issuer = null;
            veSPagueConfiguracaoParametro.io_valor_loja_rede.io_publickey = null;
            veSPagueConfiguracaoParametro.ih_inicializacao = null;
            ++n2;
        }
    }

    public static void toReplaceLayout(VeSPagueConfiguracaoData dataConfigurationDisk, String dataConfigurationName) throws VBIFile.VBIFileFileNotFoundException, VBIFile.VBIFileInputOutputException {
        boolean saveDisk = false;
        if (dataConfigurationDisk != null && dataConfigurationDisk.getLayout() <= 1) {
            try {
                UnmountServiceActivate.layoutOneToTwo((VeSPagueConfiguracaoData)dataConfigurationDisk);
                saveDisk = true;
                LOGGER.info(".conf modificado de layout 1 para layout 2");
            }
            catch (Exception e) {
                LOGGER.error("N\u00e3o foi poss\u00edvel gravar o arquivo de configura\u00e7\u00e3o: " + VeSException.MessageGet((Throwable)e), (Throwable)e);
            }
        }
        if (saveDisk) {
            UnmountServiceActivate.saveConfDisk((VeSPagueConfiguracaoData)dataConfigurationDisk, (String)dataConfigurationName);
        }
    }
}

