/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.interaction;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lib.VBIMain;
import lib.VeSUtil;
import lib.comm.VBICommInterface;
import lib.comm.VeSComm;
import lib.comm.VeSCommSocket;
import lib.comm.structure.VBICommWebsocketConfiguration;
import lib.comm.structure.VeSCommConfiguration;
import lib.comm.structure.VeSCommService;
import lib.comm.structure.VeSCommServiceExecuted;
import lib.comm.structure.VeSCommServiceExecuting;
import lib.comm.structure.VeSCommSocketConfiguration;
import lib.file.VBIFile;
import lib.graphic.window.VBIWindow;
import lib.security.VBISecurity;
import lib.thread.VBIThreadGroup;
import lib.type.VBIDatetime;
import lib.type.VeSDecimal;
import lib.type.VeSException;
import lib.type.VeSInteger;
import lib.type.VeSString;
import lib.version.VBIVersion;
import lib.xml.VBIXmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vespague.automation.VSPagueClientAutomationInteractionBackground;
import vespague.automation.VSPagueClientAutomationInteractionDriver;
import vespague.automation.VSPagueClientAutomationInteractionForeground;
import vespague.automation.VeSPagueClientAutomationInteraction;
import vespague.automation.VeSPagueClientAutomationInteractionFile;
import vespague.client.VSPagueClientMainInstance;
import vespague.client.active.ActiveDataIntegration;
import vespague.client.device.BaixaTecnica;
import vespague.client.device.VeSPaguePinpad;
import vespague.client.graphic.ClientTrayIcon;
import vespague.client.graphic.VSPagueClient;
import vespague.client.graphic.VeSPagueClient;
import vespague.client.graphic.transacao.cartao.VSPagueCampoRoteamento;
import vespague.client.graphic.transacao.cartao.roteamento.RoutingRequest;
import vespague.client.graphic.transacao.cartao.roteamento.RoutingResponse;
import vespague.client.graphic.transacao.cartao.taxa.VSPagueClientTaxaRequest;
import vespague.client.graphic.transacao.cartao.taxa.VSPagueClientTaxaResponse;
import vespague.client.interaction.IUpdateConfiguration;
import vespague.client.interaction.StatusUpdate;
import vespague.client.interaction.StatusUpdateControler;
import vespague.client.interaction.UnmountServiceActivate;
import vespague.client.interaction.VSPagueClientToServerMain;
import vespague.client.interaction.VeSPagueClientToServer;
import vespague.client.interaction.VeSPagueClientTransactionManager;
import vespague.client.interaction.VeSPagueTransactionInteraction;
import vespague.client.lib.comm.VSPagueClientCommAplicacaoComercial;
import vespague.client.lib.graphic.window.ServerWindowProcess;
import vespague.client.util.BaixaTecnicaUtil;
import vespague.common.ClientMensagem;
import vespague.common.VeSPagueClientUtil;
import vespague.common.VeSPagueUtil;
import vespague.common.comm.VeSCommClient;
import vespague.common.type.VeSPagueMessageOld;
import vespague.exception.ClientDisconnectedServer;
import vespague.exception.VSPagueClientException;
import vespague.exception.VeSPagueClientException;
import vespague.exception.VeSPagueException;
import vespague.exception.VeSPagueProcessamentoException;
import vespague.exception.VeSPagueServerException;
import vespague.structure.ServiceRequest;
import vespague.structure.ServiceResponse;
import vespague.structure.VSPagueConfiguracaoClient;
import vespague.structure.VSPagueFileLogGet;
import vespague.structure.VeSPagueActivate;
import vespague.structure.VeSPagueAuthenticate;
import vespague.structure.VeSPagueConfiguracaoClient;
import vespague.structure.VeSPagueConfiguracaoData;
import vespague.structure.VeSPagueConfiguracaoEstabelecimento;
import vespague.structure.VeSPagueConfiguracaoParametro;
import vespague.structure.VeSPagueConfiguracaoPesquisar;
import vespague.structure.VeSPagueConfiguracaoTerminal;
import vespague.structure.VeSPagueOSConsult;
import vespague.structure.VeSPagueParametroComunicacao;
import vespague.structure.VeSPagueParametroInfo;
import vespague.structure.VeSPagueTransacao;
import vespague.structure.VeSPagueTransacaoKeyword;
import vespague.structure.VeSPagueTransactionConsult;
import vespague.structure.VeSPagueUpdate;
import vespague.structure.VeSPagueValorLojaRedeConfiguracao;

public class VeSPagueClientToServer
extends VeSCommClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(VeSPagueClientToServer.class);
    private static final byte SYN = 22;
    static String CLASS_NAME;
    private VeSPagueParametroInfo io_parametro_information;
    private VeSPagueClientTransactionManager io_transaction_manager;
    public VeSPagueClientAutomationInteraction io_client_automation_interaction;
    final VBIThreadGroup io_thd_group;
    Thread io_th_receive;
    Thread io_th_parametro_atualizar;
    private Thread io_th_getlog;
    VeSPagueActivate io_activate;
    protected Hashtable<String, LinkedBlockingQueue<VeSCommServiceExecuted>> io_received = new Hashtable();
    Hashtable<String, LinkedBlockingQueue<VeSCommServiceExecuted>> io_sended = new Hashtable();
    VeSPagueParametroComunicacao io_parametro_cfg;
    VeSPagueConfiguracaoData io_cfg_data;
    private final List<VeSInteger> io_arl_socket = new ArrayList();
    private static final String SERIAL_VERSION_ERROR = "serialVersion";
    static final int SERVICE_IDENTIFY_TIMEOUT = 10000;
    private static final int SERVICE_AUTHENTICATION_TIMEOUT = 30000;
    private static final int SERVICE_OS_CONSULT_TIMEOUT = 180000;
    private static final int SERVICE_TRANSACTION_CONSULT_TIMEOUT = 30000;
    private static final int SERVICE_PENDING_CONSULT_UPDATE_TIMEOUT = 30000;
    private static final int SERVICE_PASSWORD_CHANGE_TIMEOUT = 30000;
    private static final int SERVICE_MELHOR_TAXA_TIMEOUT = 15000;
    private static final int SERVICE_ROTEAMENTO_TIMEOUT = 15000;
    private static final int RECONNECTION_TIMEOUT = 3000;
    static final int DECORATION_TIMEOUT = 5000;
    private boolean ativacaoProcessar;
    private final IUpdateConfiguration statusUpdateControler;

    public VeSPagueClientToServer(ActiveDataIntegration activeDataIntegration, String as_identifier, String[] as_xml) {
        super(as_identifier, as_xml);
        CLASS_NAME = this.getClass().getSimpleName();
        this.io_thd_group = new VBIThreadGroup(this.getClass().getSimpleName());
        this.statusUpdateControler = new StatusUpdateControler();
        if (!(this instanceof VSPagueClientToServerMain)) {
            this.io_activate = new VeSPagueActivate();
            if (activeDataIntegration != null) {
                List listMacAddress = VeSPagueClient.getMacAdressList((String)activeDataIntegration.getHostMac());
                this.ConnectionIdentifierSet(this.IdentifierGet(), VBIMain.HOST_NAME, listMacAddress.toArray(new String[0]), as_identifier != null ? new VeSInteger(as_identifier) : null, activeDataIntegration.getEstabelecimento(), activeDataIntegration.getLoja(), activeDataIntegration.getTerminal(), activeDataIntegration.getIdentificador());
            } else {
                this.ConnectionIdentifierSet(this.IdentifierGet(), VBIMain.HOST_NAME, VBIMain.HOST_HARDWARE_ADDRESS, as_identifier != null ? new VeSInteger(as_identifier) : null, null, null, null, null);
            }
        } else {
            this.io_activate = new VeSPagueActivate(null, true, VBIMain.ApplicationVersionGet().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Start(VeSPagueClientTransactionManager ao_transaction_manager) throws Exception {
        this.io_transaction_manager = ao_transaction_manager;
        this.io_received.put(VeSPagueClientUtil.SERVICO_NOME_ATIVAR, new LinkedBlockingQueue());
        this.io_received.put(VeSPagueClientUtil.SERVICO_NOME_AUTENTICAR, new LinkedBlockingQueue());
        this.io_received.put(VeSPagueClientUtil.SERVICO_NOME_TRANSACTION_CONSULT, new LinkedBlockingQueue());
        this.io_received.put(VeSPagueClientUtil.SERVICO_NOME_PENDENTE_UPDATE, new LinkedBlockingQueue());
        this.io_received.put(VeSPagueClientUtil.SERVICO_NOME_SENHA_ALTERAR, new LinkedBlockingQueue());
        this.io_received.put(VeSPagueClientUtil.SERVICO_NOME_OSCONSULT, new LinkedBlockingQueue());
        this.io_received.put(VeSPagueClientUtil.SERVICO_NOME_RESOLVE_TRANSACTION, new LinkedBlockingQueue());
        this.io_received.put(VeSPagueClientUtil.SERVICO_NOME_ATUALIZAR, new LinkedBlockingQueue());
        this.io_received.put(VeSPagueClientUtil.VESPAGUE_TRANSACAO, new LinkedBlockingQueue());
        this.io_received.put(VeSPagueClientUtil.SERVICO_NOME_IDENTIFY, new LinkedBlockingQueue());
        this.io_received.put(VeSPagueClientUtil.SERVICO_NOME_LOG_GET, new LinkedBlockingQueue());
        this.io_received.put(VeSPagueClientUtil.SERVICO, new LinkedBlockingQueue());
        this.io_received.put(VeSPagueClientUtil.VSPAGUE_CONFIGURA_TRANSACAO, new LinkedBlockingQueue());
        this.io_received.put(VeSPagueClientUtil.VSPAGUE_TRATAMENTO_TIMEOUT_CLIENT, new LinkedBlockingQueue());
        if (!this.Connected() && ClientTrayIcon.getTrayIcon() != null && ClientTrayIcon.getTrayIcon().TrayIconSupported() && this.io_transaction_manager.io_client.ArgumentsClientGet().ApplicationPortGet() != null) {
            String ls_tip_message = ClientTrayIcon.getTrayIcon().ToolTipGet();
            ClientTrayIcon.getTrayIcon().ToolTipSet(String.valueOf(ls_tip_message.substring(0, ls_tip_message.length() - 1)) + "," + this.io_transaction_manager.io_client.ArgumentsClientGet().ApplicationPortGet() + ")");
        }
        this.Connect();
        if (this.io_th_receive == null) {
            this.io_th_receive = this.ThreadReceive();
            if (!this.io_th_receive.isAlive()) {
                this.io_th_receive.setDaemon(true);
                this.io_th_receive.start();
            }
        } else {
            Thread thread = this.io_th_receive;
            synchronized (thread) {
                this.io_th_receive.notify();
            }
        }
        if (this.io_th_getlog == null) {
            this.io_th_getlog = this.ThreadGetLog();
            if (!this.io_th_getlog.isAlive()) {
                this.io_th_getlog.start();
            }
        }
    }

    public final VeSPagueClientTransactionManager ManagerGet() {
        return this.io_transaction_manager;
    }

    public final Object SendReceive(VeSCommService ao_service, Serializable ao_serializable, int an_timeout) throws Exception {
        LOGGER.debug("enviando servico {}", (Object)ao_service.is_service);
        this.Send(ao_service, ao_serializable);
        Object lo_receive = this.ReceiveWait((long)an_timeout, ao_service);
        return lo_receive;
    }

    public final VeSPagueTransacao transactionReceiveDigitalConsultar(String tipoTransacao, VeSCommService ao_service, int an_timeout) throws Exception {
        Object lo_receive = this.transactionReceiveWait(tipoTransacao, (long)an_timeout, ao_service);
        VeSPagueTransacao lo_transacao = null;
        if (lo_receive != null) {
            lo_transacao = new VeSPagueTransacaoKeyword((String)lo_receive).toTransaction();
            int ln_transacao_pendente = 0;
            this.io_transaction_manager.io_client.LogGet().removeTransaction(lo_transacao.in_perna, lo_transacao.in_sequencial_client);
            this.io_transaction_manager.io_client.LogGet().LogRecorder(lo_transacao);
            if (lo_transacao.in_transacao_pendente_vespague_codigo != null && (ln_transacao_pendente = lo_transacao.in_transacao_pendente_vespague_codigo.length) > 0) {
                lo_transacao.in_transacao_pendente_perna = new VeSInteger[ln_transacao_pendente];
                lo_transacao.is_transacao_pendente_transacao_resposta = new String[ln_transacao_pendente];
                int ln_indice = 0;
                while (ln_indice < ln_transacao_pendente) {
                    lo_transacao.is_transacao_pendente_transacao_resposta[ln_indice] = this.io_transaction_manager.io_client.LogGet().LogStatusGet(lo_transacao.in_transacao_pendente_vespague_codigo[ln_indice]);
                    lo_transacao.in_transacao_pendente_perna[ln_indice] = lo_transacao.is_transacao_pendente_transacao_resposta[ln_indice] == null ? null : new VeSInteger(3L);
                    ++ln_indice;
                }
            }
        }
        return lo_transacao;
    }

    public void ServicoIdentificarEnviar() throws Exception {
        try {
            this.ServicoIdentificarEnviar(10000);
        }
        catch (VBIFile.VBIFileInputOutputException ex) {
            LOGGER.info("Deletando o arquivo " + this.io_transaction_manager.io_client.NomeArquivoConfiguracaoCriar() + " para solicitar um novo: " + VeSException.MessageGet((Throwable)ex));
            VBIFile.FileDelete((String)this.io_transaction_manager.io_client.NomeArquivoConfiguracaoCriar());
        }
    }

    public String[] ServicoIdentificarEnviar(int an_timeout) throws Exception {
        String[] lo_identify;
        block13: {
            lo_identify = (String[])VeSUtil.ArrayNullRemove((Object)this.SendReceive(VeSPagueClientUtil.SERVICE_IDENTIFY, (Serializable)this.ConnectionIdentifierGet(), an_timeout));
            this.io_transaction_manager.io_client.validateActiveDataIntegration(lo_identify[0], lo_identify[1], lo_identify[2]);
            this.io_transaction_manager.io_client.setEstabelecimento(lo_identify[0]);
            this.io_transaction_manager.io_client.setLoja(lo_identify[1]);
            this.io_transaction_manager.io_client.setTerminal(lo_identify[2]);
            this.io_transaction_manager.io_client.clientIdentificado();
            if (!(lo_identify.length < 3 || this.io_transaction_manager.io_client.getEstabelecimento().isEmpty() || this.io_transaction_manager.io_client.getLoja().isEmpty() || this.io_transaction_manager.io_client.getTerminal().isEmpty())) {
                try {
                    if (lo_identify != null && lo_identify.length > 30) {
                        VSPagueCampoRoteamento.UrlNataxaSet((String)lo_identify[30], (String)lo_identify[31], (String)lo_identify[32], (String)lo_identify[33], (String)lo_identify[34]);
                    }
                    if (lo_identify.length >= 7 && lo_identify[7] != null && !lo_identify[7].isEmpty()) {
                        int layoutServer = Integer.parseInt(lo_identify[7]);
                        if (this.io_parametro_information.getLayout() != layoutServer) {
                            this.io_parametro_information.setLayout(layoutServer);
                        }
                    }
                    if (lo_identify.length >= 7) {
                        this.ManagerGet().io_client.configureWorkingKeys(VeSUtil.HexaToByte((String)lo_identify[3]), VeSUtil.HexaToByte((String)lo_identify[6]), VeSUtil.HexaToByte((String)lo_identify[4]), VeSUtil.HexaToByte((String)lo_identify[5]));
                    }
                    try {
                        this.arquivosConfiguracaoCarregar();
                        this.io_transaction_manager.io_client.ApplicationNameExternalSet(this.io_transaction_manager.io_datastore.ConfiguracaoDataGet().is_cfg_estabelecimento, null);
                    }
                    catch (Exception ex) {
                        if (!(ex instanceof VBIFile.VBIFileFileNotFoundException)) {
                            throw ex;
                        }
                    }
                }
                catch (Exception ex) {
                    if (ex instanceof VBIFile.VBIFileFileNotFoundException || ex instanceof ClassNotFoundException) {
                        VeSPagueClient veSPagueClient = this.io_transaction_manager.io_client;
                        veSPagueClient.getClass();
                        new VeSPagueClient.V.PagueClientWindowException(veSPagueClient, (Throwable)ex);
                        break block13;
                    }
                    if (ex instanceof VBIFile.VBIFileInputOutputException) {
                        throw ex;
                    }
                    VBIFile.FileRename((String)"", (String)this.io_transaction_manager.io_client.NomeArquivoConfiguracaoCriar(), (String)(String.valueOf(this.io_transaction_manager.io_client.NomeArquivoConfiguracaoCriar()) + ".corrupted(" + new VBIDatetime().toString("yyyyMMddHHmmss") + ")"));
                }
            } else {
                throw new VeSPagueClientException("Terminal desconhecido (" + this.io_parametro_information.is_computador_nome + '/' + VeSUtil.ArrayToString((Object[])this.io_parametro_information.is_computador_endereco, (String)";") + ")." + "\n" + "Registre-o no servidor primeiro.", 30002);
            }
        }
        String[] ls_dados_loja = lo_identify.length > 10 ? lo_identify : null;
        return ls_dados_loja;
    }

    public void arquivosConfiguracaoCarregar() throws Exception {
        this.loadConfiguracaoData();
        try {
            this.io_transaction_manager.io_client.LogGet().TransactionResolveSet((VeSPagueUtil.TransactionResolve)VBIFile.FileToObject((String)this.io_transaction_manager.io_client.NomeArquivoLogCriar(), (boolean)true));
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("nao foi possivel carregar o arquivo de .log", (Throwable)e);
        }
    }

    public void loadConfiguracaoData() throws Exception {
        if (this.io_transaction_manager.TransactionGet() == null) {
            LOGGER.debug("iniciando carregamento de .conf em mem\u00f3ria(" + this.io_transaction_manager.io_client.getClientId() + "): " + this.io_transaction_manager.io_client.getEstabelecimento() + "\\" + this.io_transaction_manager.io_client.getLoja() + "\\" + this.io_transaction_manager.io_client.getTerminal());
            this.io_cfg_data = (VeSPagueConfiguracaoData)VBIFile.FileToObject((String)this.io_transaction_manager.io_client.NomeArquivoConfiguracaoCriar(), (boolean)false);
            LOGGER.debug(".conf carregado(" + this.io_transaction_manager.io_client.getClientId() + "): " + this.io_transaction_manager.io_client.getEstabelecimento() + "\\" + this.io_transaction_manager.io_client.getLoja() + "\\" + this.io_transaction_manager.io_client.getTerminal());
            this.io_transaction_manager.io_datastore = this.createConfiguracaoPesquisar(this.io_cfg_data);
            VeSPagueConfiguracaoTerminal configuracaoTerminal = this.io_transaction_manager.io_datastore.getConfiguracaoTerminal();
            this.io_transaction_manager.io_client.validateActiveDataIntegration(configuracaoTerminal.is_estabelecimento, configuracaoTerminal.is_loja, configuracaoTerminal.is_terminal);
            LOGGER.info("{} iniciando {}-{}-{}", new Object[]{this.io_transaction_manager.io_client.getClientId(), this.io_transaction_manager.io_client.getEstabelecimento(), this.io_transaction_manager.io_client.getLoja(), this.io_transaction_manager.io_client.getTerminal()});
        } else {
            LOGGER.warn("transacao em andamento, nao carregou .conf");
        }
    }

    protected VeSPagueConfiguracaoClient createConfiguracaoPesquisar(VeSPagueConfiguracaoData veSPagueConfiguracaoData) throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        if (veSPagueConfiguracaoData.getLayout() <= 1) {
            return new VeSPagueConfiguracaoClient(veSPagueConfiguracaoData);
        }
        return new VSPagueConfiguracaoClient(veSPagueConfiguracaoData);
    }

    public long getTimeoutThreadReceive() {
        return 0L;
    }

    Thread ThreadReceive() {
        return new Thread((ThreadGroup)this.io_thd_group, (Runnable)new /* Unavailable Anonymous Inner Class!! */, "ThreadReceive-" + this.ManagerGet().io_client.getClientId());
    }

    Thread ThreadParametrosAtualizar() {
        return new Thread((ThreadGroup)this.io_thd_group, (Runnable)new /* Unavailable Anonymous Inner Class!! */, "ThreadParametrosAtualizar-" + this.ManagerGet().io_client.getClientId());
    }

    public final void ServicoAtivarProcessar(Object ao_activate) throws VeSPagueClientException {
        if (ao_activate instanceof VeSPagueActivate) {
            VeSPagueActivate lo_activate;
            this.io_activate = lo_activate = (VeSPagueActivate)ao_activate;
            LOGGER.info("Terminal " + (this.io_activate.ib_active ? "ativado" : "desativado"));
            if (lo_activate.is_application_version != null) {
                LOGGER.info("Vers\u00e3o do V$PagueServer: " + lo_activate.is_application_version);
                if (VeSPagueClient.ApplicationVersionGet().MajorCompare(new VBIVersion(lo_activate.is_application_version)) > 0) {
                    throw new VeSPagueClientException("Vers\u00e3o incompat\u00edvel (V$PagueServer " + lo_activate.is_application_version + " e " + VeSPagueClient.ApplicationNameGet() + " " + VeSPagueClient.ApplicationVersionGet() + ")");
                }
            }
            this.setConf(lo_activate);
            if (this.io_cfg_data == null) {
                this.statusUpdateControler.statusUpdate(StatusUpdate.ERROR_PROCESSED_CONF);
                throw new VeSPagueClientException("N\u00e3o foi possivel carregar o terminal, tente novamente.");
            }
        } else {
            this.StatusUpdate(this.isActive());
        }
    }

    private void setConf(VeSPagueActivate activate) {
        VeSPagueUtil.TransactionResolve transactionResolve;
        if (activate.io_cfg_data != null) {
            this.statusUpdateControler.statusUpdate(StatusUpdate.PROCESSING_CONF);
            LOGGER.info("Novo arquivo de configura\u00e7\u00e3o recebido: {}", (Object)this.io_transaction_manager.io_client.NomeArquivoConfiguracaoCriar());
            this.io_transaction_manager.io_client.ib_servico_consultar = true;
            try {
                if (this.ManagerGet().io_client.isValidateEstabelecimentoLojaTerminal(activate.io_cfg_data.io_cfg_terminal)) {
                    if (activate.io_cfg_data.getLayout() > 1 && this.io_cfg_data != null) {
                        try {
                            this.io_cfg_data = (VeSPagueConfiguracaoData)VBIFile.FileToObject((String)this.io_transaction_manager.io_client.NomeArquivoConfiguracaoCriar(), (boolean)false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                } else {
                    throw new Exception("Configuracao recebida inv\u00e1lida, contacte o suporte.");
                }
                this.io_cfg_data = UnmountServiceActivate.unmount((VeSPagueConfiguracaoData)this.io_cfg_data, (VeSPagueActivate)activate, (int)activate.io_cfg_data.getLayout(), (String)this.io_transaction_manager.io_client.NomeArquivoConfiguracaoCriar(), (IUpdateConfiguration)this.statusUpdateControler);
                this.io_transaction_manager.io_datastore = this.createConfiguracaoPesquisar(this.io_cfg_data);
                this.statusUpdateControler.statusUpdate(StatusUpdate.PROCESSED_CONF);
            }
            catch (Exception ex) {
                VeSPagueClient veSPagueClient = this.io_transaction_manager.io_client;
                veSPagueClient.getClass();
                new VeSPagueClient.V.PagueClientWindowException(veSPagueClient, "N\u00e3o foi poss\u00edvel gravar o arquivo de configura\u00e7\u00e3o: " + VeSException.MessageGet((Throwable)ex), (Throwable)ex);
                LOGGER.warn("{}: {}", (Object)this.io_transaction_manager.getTransactionId(), (Object)"Arquivo de configura\u00e7\u00e3o corrompido. Renomeando ....");
                VBIFile.FileRename((String)"", (String)this.io_transaction_manager.io_client.NomeArquivoConfiguracaoCriar(), (String)(String.valueOf(this.io_transaction_manager.io_client.NomeArquivoConfiguracaoCriar()) + ".activate_corrupted(" + new VBIDatetime().toString("yyyyMMddHHmmss") + ")"));
                return;
            }
            transactionResolve = this.io_transaction_manager.io_client.LogGet().TransactionResolveGet();
            if (transactionResolve.getBaixarConf()) {
                transactionResolve.setBaixarConf(false);
                LOGGER.info("realizado download de arquivo .conf, desmarcando indicacao.");
                this.io_transaction_manager.io_client.LogGet().TransactionResolveSet(transactionResolve);
                try {
                    this.io_transaction_manager.io_client.LogGet().saveLogDisk(transactionResolve);
                }
                catch (VBIFile.VBIFileFileNotFoundException | VBIFile.VBIFileInputOutputException throwable) {
                    // empty catch block
                }
            }
            if (this.io_transaction_manager.io_datastore.ConfiguracaoDataGet().is_cfg_estabelecimento != null) {
                this.io_transaction_manager.io_client.ApplicationNameExternalSet(this.io_transaction_manager.io_datastore.ConfiguracaoDataGet().is_cfg_estabelecimento, null);
            }
        } else {
            this.statusUpdateControler.statusUpdate(StatusUpdate.NOT_CONF);
            if (this.io_parametro_information.getLayout() >= 2 && this.io_cfg_data.getLayout() <= 1) {
                try {
                    UnmountServiceActivate.toReplaceLayout((VeSPagueConfiguracaoData)this.io_cfg_data, (String)this.io_transaction_manager.io_client.NomeArquivoConfiguracaoCriar());
                }
                catch (VBIFile.VBIFileFileNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (VBIFile.VBIFileInputOutputException e) {
                    throw new RuntimeException(e);
                }
            }
            if ((transactionResolve = this.io_transaction_manager.io_client.LogGet().TransactionResolveGet()).getBaixarConf()) {
                transactionResolve.setBaixarConf(false);
                LOGGER.info("desmarcando indicacao de baixar .conf.");
                this.io_transaction_manager.io_client.LogGet().TransactionResolveSet(transactionResolve);
                try {
                    this.io_transaction_manager.io_client.LogGet().saveLogDisk(transactionResolve);
                }
                catch (VBIFile.VBIFileFileNotFoundException | VBIFile.VBIFileInputOutputException throwable) {
                    // empty catch block
                }
            }
        }
        this.io_parametro_information.is_parametro_versao = this.io_transaction_manager.DatastoreGet() != null ? this.io_transaction_manager.DatastoreGet().ParametroVersionGet() : null;
        LOGGER.info("Versao do arquivo de configuracao: {}", (Object)this.io_parametro_information.is_parametro_versao);
        if (this.io_cfg_data != null && ClientTrayIcon.getTrayIcon() != null) {
            VeSPagueConfiguracaoEstabelecimento lo_xml_estabelecimento = null;
            try {
                lo_xml_estabelecimento = new VeSPagueConfiguracaoEstabelecimento(this.io_cfg_data.is_cfg_estabelecimento);
            }
            catch (Exception ex) {
                LOGGER.error("N\u00e3o foi possivel abrir o Xml de configura\u00e7\u00e3o do Estabelecimento", (Throwable)ex);
            }
            if (lo_xml_estabelecimento != null && lo_xml_estabelecimento.ib_trayicon_exibir != null && !lo_xml_estabelecimento.ib_trayicon_exibir.booleanValue()) {
                ClientTrayIcon.getTrayIcon().RemoveTray();
            } else {
                ClientTrayIcon.getTrayIcon().AddTray();
            }
        }
    }

    Thread ThreadGetLog() {
        return new Thread((ThreadGroup)this.io_thd_group, (Runnable)new /* Unavailable Anonymous Inner Class!! */, "ThreadGetLog-" + this.ManagerGet().io_client.getClientId());
    }

    public void consultarDigitalPagar(VeSPagueTransacao veSPagueTransacao, String resposta) throws VeSPagueException {
        VeSPagueTransacao transacaoConsulta = new VeSPagueTransacao(VeSPagueClientUtil.TRANSACAO_TIPO_DIGITAL_CONSULTAR);
        transacaoConsulta.is_estabelecimento = veSPagueTransacao.is_estabelecimento;
        transacaoConsulta.is_loja = veSPagueTransacao.is_loja;
        transacaoConsulta.is_terminal = veSPagueTransacao.is_terminal;
        transacaoConsulta.in_sequencial = veSPagueTransacao.in_sequencial;
        transacaoConsulta.in_nsu = veSPagueTransacao.in_nsu;
        transacaoConsulta.is_rede = veSPagueTransacao.is_rede;
        transacaoConsulta.is_rede_versao = veSPagueTransacao.is_rede_versao;
        transacaoConsulta.io_parametros_info = veSPagueTransacao.io_parametros_info;
        transacaoConsulta.in_sequencial_client = veSPagueTransacao.in_sequencial_client;
        transacaoConsulta.is_resposta = resposta;
        this.TransactionSend(transacaoConsulta);
    }

    public void TransactionSend(VeSPagueTransacao ao_transaction) throws VeSPagueException {
        LinkedBlockingQueue listReceive = (LinkedBlockingQueue)this.io_received.get(VeSPagueClientUtil.SERVICE_VESPAGUE_TRANSACAO.is_service);
        if (listReceive.size() > 0) {
            listReceive.clear();
        }
        this.io_transaction_manager.io_client.LogGet().LogLastTransactionRecorder(ao_transaction);
        this.io_transaction_manager.io_client.LogGet().LogRecorder(ao_transaction);
        if (ao_transaction.io_parametros_info != null) {
            ao_transaction.io_parametros_info = this.ParameterInformationGet();
        }
        String ls_word = null;
        if (this.io_activate.ib_active) {
            VeSPagueClientUtil.TransactionEncript((VeSPagueTransacao)ao_transaction);
            ao_transaction.is_comprovante_resumido = null;
            ao_transaction.is_comprovante_segunda_via = null;
            ao_transaction.is_comprovante_primeira_via = null;
            ao_transaction.id_server_enviado_data_hora = new VBIDatetime();
            VeSPagueTransacaoKeyword lo_keyword_in = new VeSPagueTransacaoKeyword(ao_transaction);
            ls_word = lo_keyword_in.toString();
            ao_transaction.TransacaoCartaoGet();
            if (ao_transaction.in_perna != null && ao_transaction.in_perna.intValue() == 3) {
                this.configureBreakIdleTime(Integer.valueOf(5));
            } else if (VeSPagueClientUtil.TRANSACAO_TIPO_DIGITAL_CONSULTAR.equals(ao_transaction.is_tipo) && ao_transaction.in_timeout != null && ao_transaction.in_timeout.intValue() > 0) {
                this.configureBreakIdleTime(Integer.valueOf((int)Math.round(ao_transaction.in_timeout.doubleValue() * 1.15)));
            } else {
                this.configureBreakIdleTime(Integer.valueOf(200));
            }
        } else {
            throw new VeSPagueClientException("Terminal n\u00e3o est\u00e1 ativo", 30002);
        }
        this.Send(VeSPagueClientUtil.SERVICE_VESPAGUE_TRANSACAO, (Serializable)((Object)ls_word));
    }

    public void sendResolverPendenciaClient(VeSPagueTransacao veSPagueTransacao) {
        VeSPagueTransacaoKeyword keyword = new VeSPagueTransacaoKeyword(veSPagueTransacao);
        String stringTransacao = keyword.toString();
        this.configureBreakIdleTime(Integer.valueOf(5));
        LOGGER.info("Enviando servico de tratamento de time-out do client. Sequencial Client {}", (Object)veSPagueTransacao.in_sequencial_client);
        try {
            this.Send(VeSPagueClientUtil.SERVICE_TRATAMENTO_TIMEOUT_CLIENT, (Serializable)((Object)stringTransacao));
        }
        catch (VeSPagueClientException e) {
            LOGGER.error("Erro ao enviar o servico de tratamento de time-out", (Throwable)e);
        }
    }

    public void Send(VeSCommService ao_service, Serializable ao_object) throws VeSPagueClientException {
        try {
            this.io_sended.put(ao_service.is_service, (LinkedBlockingQueue)this.io_received.get(ao_service.is_service));
            this.ServiceExecuting(new VeSCommServiceExecuting(new String[]{this.IdentifierGet()}, ao_service, ao_object));
        }
        catch (VeSComm.VeSCommException ex) {
            throw new VSPagueClientException(ClientMensagem.erroConexaoVSPagueServer.mensagem(), 30006);
        }
    }

    public VeSPagueTransacao TransactionSendReceive(VeSPagueTransacao ao_transaction) throws Exception {
        VeSPagueTransacao lo_transaction = null;
        VeSPagueTransacaoKeyword lo_keyword_out = null;
        String ls_transaction = "";
        ao_transaction.id_server_enviado_data_hora = new VBIDatetime();
        boolean recebeu = false;
        try {
            if (ao_transaction.io_terminal_info != null) {
                this.verificaNecessidadebaixaTecnica(ao_transaction);
            }
            this.TransactionSend(ao_transaction);
            boolean sequencialDiferente = true;
            do {
                ls_transaction = (String)this.transactionReceiveWait(ao_transaction.is_tipo, (long)(ao_transaction.in_timeout != null && ao_transaction.in_timeout.intValue() > 0 ? ao_transaction.in_timeout.multiply(1000L).intValue() : this.TimeOutTerminalGet() * 1000 + 15000), VeSPagueClientUtil.SERVICE_VESPAGUE_TRANSACAO);
                recebeu = true;
                if (ls_transaction != null) {
                    lo_keyword_out = new VeSPagueTransacaoKeyword(ls_transaction);
                    lo_transaction = lo_keyword_out.toTransaction();
                    lo_transaction.id_client_recebido_data_hora = new VBIDatetime();
                    this.io_transaction_manager.io_client.TransactionStatisticRecorder();
                    this.io_transaction_manager.io_client.LogGet().LogRecorder(lo_transaction);
                    int ln_transacao_pendente = 0;
                    if (lo_transaction.in_transacao_pendente_vespague_codigo != null && (ln_transacao_pendente = lo_transaction.in_transacao_pendente_vespague_codigo.length) > 0) {
                        lo_transaction.in_transacao_pendente_perna = new VeSInteger[ln_transacao_pendente];
                        lo_transaction.is_transacao_pendente_transacao_resposta = new String[ln_transacao_pendente];
                        int ln_indice = 0;
                        while (ln_indice < ln_transacao_pendente) {
                            lo_transaction.is_transacao_pendente_transacao_resposta[ln_indice] = this.io_transaction_manager.io_client.LogGet().LogStatusGet(lo_transaction.in_transacao_pendente_vespague_codigo[ln_indice]);
                            lo_transaction.in_transacao_pendente_perna[ln_indice] = lo_transaction.is_transacao_pendente_transacao_resposta[ln_indice] == null ? null : new VeSInteger(3L);
                            ++ln_indice;
                        }
                    }
                }
                boolean bl = sequencialDiferente = ls_transaction != null && lo_transaction.in_sequencial_client.compareTo((BigInteger)ao_transaction.in_sequencial_client) != 0;
                if (sequencialDiferente) {
                    LOGGER.warn("{} Sequencial client recebido diferente do esperado.", (Object)this.io_transaction_manager.io_client.getClientId());
                    continue;
                }
                LOGGER.debug("{} Transacao com sequencial client recebido {}", (Object)this.io_transaction_manager.io_client.getClientId(), (Object)ao_transaction.in_sequencial_client);
            } while (sequencialDiferente);
        }
        catch (VeSPagueException ex) {
            String string = ao_transaction.in_sequencial == null ? "TO" : (ao_transaction.is_resposta = ao_transaction.is_resposta == null ? "to" : ao_transaction.is_resposta);
            if (!recebeu && ex.in_code == 30001) {
                VeSPagueTransacao transacao = ao_transaction.clone();
                new Thread(() -> this.sendResolverPendenciaClient(transacao)).start();
            }
            this.io_transaction_manager.io_client.LogGet().LogRecorder(ao_transaction);
            VeSPagueClientUtil.TransactionDecript((VeSPagueTransacao)ao_transaction, (boolean)true);
            switch (ex.in_code) {
                case 3: {
                    this.StatusUpdate();
                }
            }
            throw ex;
        }
        if (lo_transaction == null) {
            ao_transaction.is_resposta = "TO";
            this.io_transaction_manager.io_client.LogGet().LogRecorder(ao_transaction);
            lo_transaction = ao_transaction;
            VeSPagueClientUtil.TransactionDecript((VeSPagueTransacao)lo_transaction, (boolean)true);
            ao_transaction.io_problem = new VSPagueClientException(ClientMensagem.tempoExcedidoRespostaTransacao.mensagem(), 30001);
        } else if (lo_transaction.io_problem != null) {
            if (lo_transaction.io_problem instanceof VeSPagueClientException && ((VeSPagueClientException)lo_transaction.io_problem).in_code == 30001) {
                ao_transaction.is_resposta = ao_transaction.in_sequencial == null ? "TO" : (ao_transaction.is_resposta == null ? "to" : ao_transaction.is_resposta);
                this.io_transaction_manager.io_client.LogGet().LogRecorder(lo_transaction);
                ao_transaction.is_resposta = lo_transaction.is_resposta;
                ao_transaction.is_resposta_mensagem = lo_transaction.is_resposta_mensagem;
                ao_transaction.io_problem = new VSPagueClientException(ClientMensagem.tempoExcedidoRespostaTransacao.mensagem(), 30001);
                lo_transaction = ao_transaction;
            } else if (lo_transaction.io_problem instanceof VeSPagueServerException) {
                ao_transaction.is_resposta = ao_transaction.is_resposta == null ? "EX" : ao_transaction.is_resposta;
                this.io_transaction_manager.io_client.LogGet().LogRecorder(lo_transaction);
                switch (((VeSPagueServerException)lo_transaction.io_problem).in_code) {
                    case 3: {
                        this.StatusUpdate(Boolean.valueOf(true));
                        break;
                    }
                    case 20019: {
                        LOGGER.warn("{}: {}", (Object)this.io_transaction_manager.getTransactionId(), (Object)"TERMINAL DESATIVADO\nAguarde a reconex\u00e3o automatica. Isso poder\u00e1 levar alguns minutos...\nPara maiores detalhes, consulte o arquivo: C:\\VeSPague\\Client\\VeSPagueClient - Error.txt");
                    }
                }
            }
            VeSPagueClientUtil.TransactionDecript((VeSPagueTransacao)lo_transaction, (boolean)true);
        } else {
            VeSPagueClientUtil.TransactionDecript((VeSPagueTransacao)lo_transaction, (boolean)true);
        }
        return lo_transaction;
    }

    private void verificaNecessidadebaixaTecnica(VeSPagueTransacao veSPagueTransacao) {
        BaixaTecnica baixaTecnica = BaixaTecnicaUtil.get((String)veSPagueTransacao.is_estabelecimento, (String)veSPagueTransacao.is_loja, (String)veSPagueTransacao.is_terminal);
        if (baixaTecnica == null) {
            BaixaTecnicaUtil.createDir((String)veSPagueTransacao.is_estabelecimento, (String)veSPagueTransacao.is_loja, (String)veSPagueTransacao.is_terminal);
        }
        if (veSPagueTransacao.io_terminal_info.is_pinpad_serial_number != null && veSPagueTransacao.io_terminal_info.is_pinpad_model != null && veSPagueTransacao.io_terminal_info.is_pinpad_specification_version != null && veSPagueTransacao.io_terminal_info.is_pinpad_firmware_version != null) {
            BaixaTecnica baixaTecnicaNew = new BaixaTecnica(veSPagueTransacao.io_terminal_info.is_pinpad_serial_number, veSPagueTransacao.io_terminal_info.is_pinpad_model, veSPagueTransacao.io_terminal_info.is_pinpad_specification_version, veSPagueTransacao.io_terminal_info.is_pinpad_firmware_version);
            if (!baixaTecnicaNew.equals((Object)baixaTecnica)) {
                BaixaTecnicaUtil.save((String)veSPagueTransacao.is_estabelecimento, (String)veSPagueTransacao.is_loja, (String)veSPagueTransacao.is_terminal, (BaixaTecnica)baixaTecnicaNew);
                LOGGER.info("atualizando arquivo de baixa tecnica com as novas informacoes de equipamento");
                veSPagueTransacao.setBaixaTecnicaProcessar(true);
            }
        } else {
            LOGGER.warn("campo obrigatorio para geracao de baixa tecnica nao prenchido, arquivo nao atualizado");
        }
    }

    public VeSPagueTransacao TransactionReceive(VeSInteger an_transaction_sequencial) throws VeSPagueException {
        return (VeSPagueTransacao)this.transactionReceiveDigitalConsultar((Object)an_transaction_sequencial);
    }

    public void StatusUpdate() throws VeSPagueException {
        this.StatusUpdate(this.isActive());
    }

    public void StatusUpdate(Boolean ab_active) throws VeSPagueClientException {
        this.StatusUpdate(StatusUpdate.NONE, ab_active);
    }

    public void StatusUpdate(StatusUpdate statusUpdate, Boolean ab_active) throws VeSPagueClientException {
        if (this.io_th_parametro_atualizar == null) {
            this.io_th_parametro_atualizar = this.ThreadParametrosAtualizar();
            this.io_th_parametro_atualizar.start();
        }
        String versaoParametrosTerminal = this.io_transaction_manager.io_datastore == null || this.io_parametro_information.getLayout() != this.io_transaction_manager.io_datastore.ConfiguracaoDataGet().getLayout() ? null : this.io_transaction_manager.io_datastore.ParametroVersionGet();
        VeSPagueParametroInfo parametroInfo = new VeSPagueParametroInfo(ab_active, this.io_parametro_information.is_computador_nome, this.io_parametro_information.is_computador_endereco, this.io_parametro_information.in_computador_porta, this.io_transaction_manager.io_client.getEstabelecimento(), this.io_transaction_manager.io_client.getLoja(), this.io_transaction_manager.io_client.getTerminal(), versaoParametrosTerminal, this.io_parametro_information.is_client_version, null);
        parametroInfo.setLayout(this.io_parametro_information.getLayout());
        this.Send(VeSPagueClientUtil.SERVICE_ACTIVE, (Serializable)parametroInfo);
        this.statusUpdateControler.statusUpdate(statusUpdate);
    }

    public void LogGet(VSPagueFileLogGet ao_file_log_get, VeSPagueUpdate ao_update) throws VeSPagueClientException, VBIFile.VBIFileFileNotFoundException, VBIFile.VBIFileInputOutputException {
        File[] lo_files = new File(System.getProperty("user.dir")).listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
        int ln_1 = 0;
        while (ln_1 < lo_files.length) {
            block17: {
                VeSPagueUpdate.ResourceToUpdate lo_resource;
                byte[] lh_data = null;
                if (ao_update.io_resources != null && ao_update.io_resources[ao_update.io_resources.length - 1].is_resource_path.equals(lo_files[ln_1].getName())) {
                    VeSPagueUpdate veSPagueUpdate = ao_update;
                    veSPagueUpdate.getClass();
                    lo_resource = new VeSPagueUpdate.ResourceToUpdate(veSPagueUpdate, lo_files[ln_1].getName(), "1.0", (Object)new VBIDatetime(), ao_update.io_resources[ao_update.io_resources.length - 1].in_resource_total_size, ao_update.io_resources[ao_update.io_resources.length - 1].in_resource_position, null, 0, false, null, null);
                } else {
                    VeSPagueUpdate veSPagueUpdate = ao_update;
                    veSPagueUpdate.getClass();
                    lo_resource = new VeSPagueUpdate.ResourceToUpdate(veSPagueUpdate, lo_files[ln_1].getName(), "1.0", (Object)new VBIDatetime(), -1, 0, null, 0, false, null, null);
                }
                VBIFile lo_file = new VBIFile(lo_files[ln_1].getName());
                try {
                    try {
                        if (VBIFile.FileExists((String)lo_files[ln_1].getName())) {
                            lo_file.Open();
                            VBIDatetime ld_data_modified = new VBIDatetime(new File(lo_files[ln_1].getName()).lastModified());
                            if (!lo_resource.ib_only_verify) {
                                int ln_file_size = (int)(lo_resource.in_resource_total_size > 0 ? (long)lo_resource.in_resource_total_size : VBIFile.FileSizeGet((String)lo_resource.is_resource_path));
                                ArrayList<VeSPagueUpdate.ResourceToUpdate> lo_resources = new ArrayList<VeSPagueUpdate.ResourceToUpdate>(lo_files.length);
                                if (ln_file_size > -1) {
                                    if (lo_resource.in_resource_position + 16384 >= ln_file_size) {
                                        lh_data = lo_file.Read((long)((int)lo_file.LengthGet() - (lo_resource.in_resource_position == -1 ? 0 : lo_resource.in_resource_position)), (long)(lo_resource.in_resource_position == -1 ? 0 : lo_resource.in_resource_position));
                                        VeSPagueUpdate veSPagueUpdate = ao_update;
                                        veSPagueUpdate.getClass();
                                        lo_resources.add(new VeSPagueUpdate.ResourceToUpdate(veSPagueUpdate, lo_resource.is_resource_path, "1.0", (Object)ld_data_modified, ln_file_size, ln_file_size, lh_data, 0, true, VBISecurity.MD5Compute((String)lo_resource.is_resource_path), null));
                                    } else {
                                        lh_data = lo_file.Read(16384L, (long)(lo_resource.in_resource_position == -1 ? 0 : lo_resource.in_resource_position));
                                        VeSPagueUpdate veSPagueUpdate = ao_update;
                                        veSPagueUpdate.getClass();
                                        lo_resources.add(new VeSPagueUpdate.ResourceToUpdate(veSPagueUpdate, lo_resource.is_resource_path, "1.0", (Object)ld_data_modified, ln_file_size, (lo_resource.in_resource_position == -1 ? 0 : lo_resource.in_resource_position) + 16384, lh_data, 0, false, null, null));
                                    }
                                    if (lo_resources.size() > 0) {
                                        ao_update.io_resources = new VeSPagueUpdate.ResourceToUpdate[lo_resources.size()];
                                        lo_resources.toArray(ao_update.io_resources);
                                        this.Send(VeSPagueClientUtil.SERVICE_LOG_GET, (Serializable)new VSPagueFileLogGet(ao_update, lo_files[ln_1].getName(), ao_file_log_get.TerminalLocationGet()));
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (lo_file != null && lo_file.Opened()) {
                            lo_file.Close();
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (lo_file != null && lo_file.Opened()) {
                        lo_file.Close();
                    }
                    throw throwable;
                }
                if (lo_file != null && lo_file.Opened()) {
                    lo_file.Close();
                }
            }
            ++ln_1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object transactionReceiveDigitalConsultar(Object ao_key) throws VeSPagueException {
        Boolean lo_return = null;
        if (!((LinkedBlockingQueue)this.io_received.get(ao_key)).isEmpty() && (lo_return = Boolean.valueOf(((LinkedBlockingQueue)this.io_received.get(ao_key)).remove(0))) != null && lo_return instanceof Throwable) {
            if (this.io_sended.containsKey(ao_key)) {
                LinkedBlockingQueue linkedBlockingQueue = (LinkedBlockingQueue)this.io_sended.get(ao_key);
                synchronized (linkedBlockingQueue) {
                    ((LinkedBlockingQueue)this.io_sended.get(ao_key)).notify();
                }
            }
            throw new VeSPagueException((Throwable)((Object)lo_return));
        }
        return lo_return;
    }

    public final VeSPagueConfiguracaoData ConfiguracaoDataGet() {
        return this.io_cfg_data;
    }

    protected final void ConfiguracaoDataSet(VeSPagueConfiguracaoData ao_cfg_data) {
        this.io_cfg_data = ao_cfg_data;
    }

    public void loadInteractionOffline() throws Exception {
        if (this.io_cfg_data == null) {
            VeSInteger applicationPort = this.ManagerGet().io_client.ArgumentsClientGet().ApplicationPortGet();
            File[] listFiles = new File(System.getProperty("user.dir")).listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
            if (listFiles.length == 1) {
                String[] fileName = listFiles[0].getName().split("_");
                this.io_transaction_manager.io_client.setEstabelecimento(fileName[1]);
                this.io_transaction_manager.io_client.setLoja(fileName[2]);
                if (fileName.length == 4) {
                    this.io_transaction_manager.io_client.setTerminal(fileName[3].substring(0, fileName[3].indexOf(".")));
                } else {
                    this.io_transaction_manager.io_client.setTerminal(fileName[3]);
                }
                this.loadConfiguracaoData();
                this.io_activate = new VeSPagueActivate(this.io_cfg_data, true, VBIMain.ApplicationVersionGet().toString());
                this.ParameterInformationGet().is_parametro_versao = this.io_cfg_data.io_cfg_terminal.is_parametros_versao;
                this.AutomacaoConfigurar(this.io_cfg_data.is_cfg_comunicacao, this.io_cfg_data.io_cfg_terminal.XmlComunicacaoGet());
                this.AutomacaoIniciar();
            } else {
                LOGGER.error("Nenhum ou mais de um .conf encontrado no diretorio.");
            }
        }
    }

    public VeSPagueActivate getActivate() {
        return this.io_activate;
    }

    public final void AutomacaoConfigurar(String as_cfg_comunicacao, String as_cfg_terminal_comunicacao) {
        try {
            VeSPagueParametroComunicacao lo_comunicacao_anterior = this.io_parametro_cfg;
            if (as_cfg_terminal_comunicacao != null && !as_cfg_terminal_comunicacao.isEmpty()) {
                this.io_parametro_cfg = new VeSPagueParametroComunicacao(this.AutomacaoXmlFormatar(as_cfg_terminal_comunicacao));
            }
            if (!(as_cfg_comunicacao == null || as_cfg_comunicacao.isEmpty() || this.io_parametro_cfg != null && this.io_parametro_cfg.VeSPagueAutomationConfiguracao.in_interface != null && this.io_parametro_cfg.VeSPagueAutomationConfiguracao.in_interface != 0)) {
                this.io_parametro_cfg = new VeSPagueParametroComunicacao(this.AutomacaoXmlFormatar(as_cfg_comunicacao));
            }
            if (!(this.io_parametro_cfg == null || lo_comunicacao_anterior != null && lo_comunicacao_anterior.XmlGet().equalsIgnoreCase(this.io_parametro_cfg.XmlGet()))) {
                if (this.io_parametro_cfg.VeSPagueAutomationConfiguracao.in_interface != null) {
                    boolean bl = VeSPagueClient.ALWAYS_ON_TOP = this.io_parametro_cfg.VeSPagueAutomationConfiguracao.ib_always_on_top != null && this.io_parametro_cfg.VeSPagueAutomationConfiguracao.ib_always_on_top != false;
                    if (VSPagueClient.io_hmp_instance != null) {
                        this.io_transaction_manager.io_client.in_mode = 3;
                        VeSPagueClient.VISIBLE = false;
                    } else {
                        this.io_transaction_manager.io_client.in_mode = this.io_parametro_cfg.VeSPagueAutomationConfiguracao.in_interface;
                        VeSPagueClient.VISIBLE = this.io_transaction_manager.io_client.in_mode != 3 && this.io_transaction_manager.io_client.in_mode != 5 && this.io_transaction_manager.io_client.in_mode != 6;
                    }
                    VeSPagueClient.COMPROVANTE_SEPARADOR = this.io_parametro_cfg.VeSPagueAutomationConfiguracao.is_comprovante_separador != null ? this.io_parametro_cfg.VeSPagueAutomationConfiguracao.is_comprovante_separador : "/\\";
                    VeSPagueClient.COMPROVANTE_NULO = this.io_parametro_cfg.VeSPagueAutomationConfiguracao.ib_comprovante_nulo;
                } else {
                    throw new VeSPagueProcessamentoException("Modo de processamento indefinido\n\n");
                }
            }
            if (this.io_transaction_manager.io_client.getTrayIcon() != null) {
                if (this.io_transaction_manager.io_client.getTrayIcon().isMenuVisible()) {
                    boolean lb_visible = this.io_transaction_manager.io_client.in_mode == 0 || this.io_transaction_manager.io_client.in_mode == 1;
                    boolean lb_toolbar_habilitar = this.io_cfg_data != null && this.io_cfg_data.io_cfg_terminal.ib_toolbar_habilitar != false && VeSPagueClient.VISIBLE;
                    this.io_transaction_manager.io_client.getTrayIcon().enableMenu(lb_visible);
                    if (!this.io_transaction_manager.io_client.ToolbarGet().isVisible()) {
                        this.io_transaction_manager.io_client.Visible(lb_visible);
                    } else if (!lb_toolbar_habilitar) {
                        this.io_transaction_manager.io_client.ShortCutGet().CreateComponents();
                        this.io_transaction_manager.io_client.ShortCutGet().EnableSet(true);
                        this.io_transaction_manager.io_client.ToolbarGet().VisibleSet(false);
                        this.io_transaction_manager.io_client.Visible(true);
                    }
                }
                this.io_transaction_manager.io_client.getTrayIcon().configureAlwaysOnTop(VeSPagueClient.ALWAYS_ON_TOP);
            }
            VBIWindow.AlwaysOnTopSet((boolean)VeSPagueClient.ALWAYS_ON_TOP);
            this.io_transaction_manager.WindowProgressInstanciar();
            if (!this.io_transaction_manager.io_client.ToolbarGet().isVisible()) {
                this.io_transaction_manager.io_client.ShortCutGet().EnableSet(true);
            }
        }
        catch (Exception ex) {
            this.io_transaction_manager.WindowProgressInstanciar();
            VeSPagueClient veSPagueClient = this.io_transaction_manager.io_client;
            veSPagueClient.getClass();
            new VeSPagueClient.V.PagueClientWindowException(veSPagueClient, (Throwable)ex);
        }
    }

    private final String AutomacaoXmlFormatar(String as_xml_comunicacao) {
        String ls_xml_nome = VeSPagueParametroComunicacao.class.getSimpleName();
        String ls_xml_informacao_header = "<VeSPagueAutomationConfiguracao>";
        String ls_xml_informacao_trailer = as_xml_comunicacao.contains("io_cfg_sap") ? "</io_cfg_sap>" : "</VeSPagueAutomationConfiguracao>";
        String ls_xml_header = "<XMLRoot>";
        String ls_xml_trailer = "</XMLRoot>";
        String ls_xml_estrutura = VeSString.Substring((String)as_xml_comunicacao, (String)"<VeSPagueAutomationConfiguracao>", (int)1, (String)ls_xml_informacao_trailer, (int)1);
        return ls_xml_estrutura == null ? as_xml_comunicacao : String.valueOf(as_xml_comunicacao.indexOf("<XMLRoot>") >= 0 ? as_xml_comunicacao.substring(0, as_xml_comunicacao.indexOf("<XMLRoot>")) : "") + "<XMLRoot>" + "<" + ls_xml_nome + ">" + "<VeSPagueAutomationConfiguracao>" + ls_xml_estrutura + ls_xml_informacao_trailer + "</" + ls_xml_nome + ">" + "</XMLRoot>";
    }

    public void AutomacaoIniciar() {
        block16: {
            try {
                if (this.io_parametro_cfg != null) {
                    VeSInteger ln_port = this.io_transaction_manager.io_client.ArgumentsClientGet().ApplicationPortGet() != null ? this.io_transaction_manager.io_client.ArgumentsClientGet().ApplicationPortGet() : (this.io_parametro_cfg.VeSPagueAutomationConfiguracao.in_port != null && this.io_parametro_cfg.VeSPagueAutomationConfiguracao.in_port.compareTo(1) > 0 ? new VeSInteger((long)this.io_parametro_cfg.VeSPagueAutomationConfiguracao.in_port.intValue()) : new VeSInteger(60906L));
                    boolean lb_trace = this.io_parametro_cfg.VeSPagueAutomationConfiguracao.ib_trace != false || this.io_transaction_manager.io_client.ArgumentsClientGet().ApplicationTraceEnable();
                    String ls_modo_processamento = null;
                    switch (this.io_transaction_manager.io_client.in_mode) {
                        case 1: {
                            ls_modo_processamento = "Standalone";
                            this.AutomacaoComunicacaoFinalizar();
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 6: {
                            boolean lb_same_object = false;
                            int ln_array_size = this.io_arl_socket.size();
                            if (ln_array_size > 0) {
                                int ln_indice_socket = 0;
                                while (ln_indice_socket < ln_array_size && !(lb_same_object = ln_port.compareTo((BigInteger)this.io_arl_socket.get(ln_indice_socket)) == 0)) {
                                    ++ln_indice_socket;
                                }
                            }
                            if (lb_same_object) break;
                            this.io_arl_socket.add(ln_port);
                            if (this.io_transaction_manager.io_client.ArgumentsClientGet().ApplicationPortGet() != null && !this.io_transaction_manager.io_client.ArgumentsClientGet().ApplicationPortGet().equals((Object)ln_port)) {
                                throw new VeSPagueProcessamentoException("Porta de comunica\u00e7\u00e3o com a automa\u00e7\u00e3o difere da configurada no servidor\n\n");
                            }
                            this.AutomacaoComunicacaoFinalizar();
                            VeSCommSocketConfiguration lo_cfg_socket = new VeSCommSocketConfiguration();
                            if (this.io_parametro_cfg.VeSPagueAutomationConfiguracao.ib_websocket != null && this.io_parametro_cfg.VeSPagueAutomationConfiguracao.ib_websocket.booleanValue()) {
                                lo_cfg_socket = new VBICommWebsocketConfiguration();
                            }
                            lo_cfg_socket.is_host = this.io_parametro_cfg.VeSPagueAutomationConfiguracao.is_host != null ? this.io_parametro_cfg.VeSPagueAutomationConfiguracao.is_host : "";
                            lo_cfg_socket.in_port = ln_port;
                            lo_cfg_socket.ib_secure_socket_layer = this.io_parametro_cfg.VeSPagueAutomationConfiguracao.ib_secure_socket_layer;
                            lo_cfg_socket.in_reconnect_automatic_delay = this.io_parametro_cfg.VeSPagueAutomationConfiguracao.is_host != null ? Long.valueOf(1000L) : null;
                            lo_cfg_socket.ib_trace = lb_trace;
                            VeSComm lo_com_listen = VeSComm.Factory((String)lo_cfg_socket.XmlGet());
                            if (this.io_transaction_manager.io_client.in_mode == 2) {
                                ls_modo_processamento = "Foreground";
                                this.io_client_automation_interaction = new VSPagueClientAutomationInteractionForeground(this.io_transaction_manager, lo_com_listen);
                                break;
                            }
                            if (this.io_transaction_manager.io_client.in_mode == 6) {
                                ls_modo_processamento = "Driver";
                                this.io_client_automation_interaction = new VSPagueClientAutomationInteractionDriver(this.io_transaction_manager, (VeSComm)new VSPagueClientCommAplicacaoComercial(this.io_transaction_manager.io_client.getClientId(), (VeSCommConfiguration)lo_cfg_socket), null);
                                this.io_transaction_manager.io_client.in_mode = 3;
                                break;
                            }
                            if (this.io_transaction_manager.io_client.in_mode != 3) break;
                            ls_modo_processamento = this.io_parametro_cfg.VeSPagueAutomationConfiguracao.ib_websocket != null && this.io_parametro_cfg.VeSPagueAutomationConfiguracao.ib_websocket != false ? "Websocket" : "Background";
                            this.io_client_automation_interaction = new VSPagueClientAutomationInteractionBackground(this.io_transaction_manager, lo_com_listen, null);
                            break;
                        }
                        case 4: {
                            ls_modo_processamento = "File";
                            if (this.io_client_automation_interaction != null && this.io_client_automation_interaction instanceof VeSPagueClientAutomationInteractionFile) break;
                            LOGGER.info("configurando modo de integracao {}", (Object)ls_modo_processamento);
                            this.AutomacaoComunicacaoFinalizar();
                            this.io_client_automation_interaction = new VeSPagueClientAutomationInteractionFile(this.io_transaction_manager, this.io_parametro_cfg.VeSPagueAutomationConfiguracao.is_path_request, this.io_parametro_cfg.VeSPagueAutomationConfiguracao.is_path_response, this.io_parametro_cfg.VeSPagueAutomationConfiguracao.is_impressao_via, this.io_parametro_cfg.VeSPagueAutomationConfiguracao.ib_tags_validar, this.io_parametro_cfg.VeSPagueAutomationConfiguracao.ib_tag_proprietaria, this.io_parametro_cfg.VeSPagueAutomationConfiguracao.ib_solicitar_confirmacao_desfazimento, lb_trace);
                            break;
                        }
                        case 0: {
                            throw new VeSPagueProcessamentoException("Modo de processamento (" + this.io_transaction_manager.io_client.in_mode + ") indefinido" + "\n" + "\n");
                        }
                    }
                    if (ls_modo_processamento != null) {
                        LOGGER.info("aplicacao configurada com modo de processamento \"" + ls_modo_processamento + "\"");
                    }
                    break block16;
                }
                throw new VeSPagueProcessamentoException("N\u00e3o foi poss\u00edvel abrir a porta de comunica\u00e7\u00e3o. Automa\u00e7\u00e3o inoperante.\n\n");
            }
            catch (Exception ex) {
                VeSPagueClient veSPagueClient = this.io_transaction_manager.io_client;
                veSPagueClient.getClass();
                new VeSPagueClient.V.PagueClientWindowException(veSPagueClient, (Throwable)ex);
            }
        }
    }

    private void AutomacaoComunicacaoFinalizar() throws VeSPagueProcessamentoException {
        if (this.io_client_automation_interaction != null) {
            this.io_client_automation_interaction.Finalize();
            this.io_client_automation_interaction = null;
        }
    }

    public void Update() {
        new UpdateProcess(this, null).start();
    }

    public VeSPagueTransactionInteraction getAutomationInteraction() {
        return this.io_client_automation_interaction != null ? this.io_client_automation_interaction : this.io_transaction_manager.io_client.TransactionInteractionGet();
    }

    public boolean EmployeeAuthentication(String as_user, String as_password) throws Exception {
        Object lo_receive = this.SendReceive(VeSPagueClientUtil.SERVICE_AUTHENTICATION, (Serializable)new VeSPagueAuthenticate(this.io_transaction_manager.io_client.getEstabelecimento(), this.io_transaction_manager.io_client.getLoja(), this.io_transaction_manager.io_client.getTerminal(), as_user, as_password, VeSPagueClientUtil.USUARIO_LOJISTA), 30000);
        return (Boolean)lo_receive;
    }

    public final VeSPagueOSConsult ManutencaoRedeConsultar(VeSInteger[] an_sequencial) throws Exception {
        VeSPagueOSConsult lo_consult_os = null;
        lo_consult_os = an_sequencial == null ? new VeSPagueOSConsult(this.TerminalConfiguracaoGet((VeSPagueConfiguracaoPesquisar)this.io_transaction_manager.io_datastore).is_estabelecimento, this.TerminalConfiguracaoGet((VeSPagueConfiguracaoPesquisar)this.io_transaction_manager.io_datastore).is_loja, this.TerminalConfiguracaoGet((VeSPagueConfiguracaoPesquisar)this.io_transaction_manager.io_datastore).is_terminal, this.io_transaction_manager.io_datastore.TransacaoGet().is_rede, this.io_transaction_manager.io_datastore.TransacaoGet().is_rede_versao, null, null, null, null) : new VeSPagueOSConsult(an_sequencial);
        return (VeSPagueOSConsult)this.SendReceive(VeSPagueClientUtil.SERVICE_CONSULTAR_OS, (Serializable)lo_consult_os, 180000);
    }

    public VeSPagueTransactionConsult TransacaoConsultar(VeSPagueTransactionConsult ao_pending) throws Exception {
        if (ao_pending == null) {
            ao_pending = new VeSPagueTransactionConsult();
        }
        ao_pending.is_estabelecimento = this.io_transaction_manager.io_client.getEstabelecimento();
        ao_pending.is_loja = this.io_transaction_manager.io_client.getLoja();
        ao_pending.is_terminal = this.io_transaction_manager.io_client.getTerminal();
        ao_pending.is_tipo_transacao = this.io_transaction_manager.io_datastore.TransacaoGet().is_tipo != null ? this.io_transaction_manager.io_datastore.TransacaoGet().is_tipo : ao_pending.is_tipo_transacao;
        return (VeSPagueTransactionConsult)this.SendReceive(VeSPagueClientUtil.SERVICE_TRANSACTION_CONSULT, (Serializable)ao_pending, 30000);
    }

    public boolean TransacaoPendenteConsultar(Object[] ao_dados_transacao) throws Exception {
        Object lo_receive = this.SendReceive(VeSPagueClientUtil.SERVICE_CONSULT_PENDING_UPDATE, (Serializable)ao_dados_transacao, 30000);
        return (Boolean)lo_receive;
    }

    public VSPagueClientTaxaResponse consultaMelhorTaxa(VSPagueClientTaxaRequest vsPagueClientTaxaRequest) throws Exception {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setLenient();
        Gson gson = gsonBuilder.create();
        String payload = gson.toJson((Object)vsPagueClientTaxaRequest);
        ServiceRequest serviceRequest = new ServiceRequest("nataxa", payload);
        LOGGER.info("solicitacao do servico {}. requestId: {}, payload: {}", new Object[]{serviceRequest.getName(), serviceRequest.getRequestId(), serviceRequest.getPayload()});
        Object receive = this.SendReceive(VeSPagueClientUtil.SERVICE, (Serializable)serviceRequest, 15000);
        ServiceResponse serviceResponse = (ServiceResponse)receive;
        if (serviceResponse.successful) {
            LOGGER.info("resposta do servico {}. requestId: {}, successful: {}, statusCode: {}, errorCode: {}, payload: {}", new Object[]{serviceRequest.getName(), serviceRequest.getRequestId(), serviceResponse.successful, serviceResponse.statusCode, serviceResponse.errorCode, serviceResponse.payload});
            if (serviceResponse.payload != null) {
                return (VSPagueClientTaxaResponse)gson.fromJson(serviceResponse.payload, VSPagueClientTaxaResponse.class);
            }
            LOGGER.warn("resposta sem payload");
            return null;
        }
        LOGGER.error("resposta do servico {}. requestId: {}, successful: {}, statusCode: {}, errorCode: {}, message: {}, payload: {}", new Object[]{serviceRequest.getName(), serviceRequest.getRequestId(), serviceResponse.successful, serviceResponse.statusCode, serviceResponse.errorCode, serviceResponse.errorDescription, serviceResponse.payload});
        return null;
    }

    public RoutingResponse consultaRoteamento(RoutingRequest roteamentoRequest) throws Exception {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setLenient();
        Gson gson = gsonBuilder.create();
        String payload = gson.toJson((Object)roteamentoRequest);
        ServiceRequest serviceRequest = new ServiceRequest("nataxa-router", payload);
        LOGGER.info("solicitacao do servico {}. requestId: {}, payload: {}", new Object[]{serviceRequest.getName(), serviceRequest.getRequestId(), serviceRequest.getPayload()});
        Object receive = this.SendReceive(VeSPagueClientUtil.SERVICE, (Serializable)serviceRequest, 15000);
        ServiceResponse serviceResponse = (ServiceResponse)receive;
        if (serviceResponse.successful) {
            LOGGER.info("resposta do servico {}. requestId: {}, successful: {}, statusCode: {}, errorCode: {}, payload: {}", new Object[]{serviceRequest.getName(), serviceRequest.getRequestId(), serviceResponse.successful, serviceResponse.statusCode, serviceResponse.errorCode, serviceResponse.payload});
            if (serviceResponse.payload != null) {
                return (RoutingResponse)gson.fromJson(serviceResponse.payload, RoutingResponse.class);
            }
            LOGGER.warn("resposta sem payload");
            return null;
        }
        LOGGER.error("resposta do servico {}. requestId: {}, successful: {}, statusCode: {}, errorCode: {}, message: {}, payload: {}", new Object[]{serviceRequest.getName(), serviceRequest.getRequestId(), serviceResponse.successful, serviceResponse.statusCode, serviceResponse.errorCode, serviceResponse.errorDescription, serviceResponse.payload});
        return null;
    }

    public final ArrayList PasswordChange(ArrayList<String> ao_valor_usuario) throws Exception {
        return (ArrayList)this.SendReceive(VeSPagueClientUtil.SERVICE_PASSWORD_CHANGE, ao_valor_usuario, 30000);
    }

    public Object transactionReceiveWait(String tipoTransacao, long waitTime, VeSCommService veSCommService) throws Exception {
        Serializable lo_return = null;
        LinkedBlockingQueue lo_lbq_service = (LinkedBlockingQueue)this.io_received.get(veSCommService.is_service);
        try {
            if (!VeSPagueClientUtil.TRANSACAO_TIPO_DIGITAL_PAGAR.equals(tipoTransacao) && !VeSPagueClientUtil.TRANSACAO_TIPO_DIGITAL_CONSULTAR.equals(tipoTransacao)) {
                while ((lo_return = (Serializable)(waitTime == 0L ? lo_lbq_service.take() : lo_lbq_service.poll(waitTime, TimeUnit.MILLISECONDS))) instanceof ClientDisconnectedServer) {
                }
            } else {
                lo_return = (Serializable)(waitTime == 0L ? lo_lbq_service.take() : lo_lbq_service.poll(waitTime, TimeUnit.MILLISECONDS));
            }
            if (lo_return instanceof ClientDisconnectedServer) {
                lo_lbq_service.clear();
                throw new Exception((Throwable)lo_return);
            }
            if (lo_return instanceof Throwable) {
                LOGGER.error("servico de excecao recebido ", lo_return);
                if (this.io_sended.containsKey(veSCommService.is_service)) {
                    LinkedBlockingQueue lo_arl = (LinkedBlockingQueue)this.io_sended.get(veSCommService.is_service);
                    lo_arl.add(veSCommService);
                }
                throw new VeSPagueClientException((Throwable)lo_return);
            }
            if (lo_return instanceof VeSCommServiceExecuted) {
                VeSCommServiceExecuted lo_service_executed = (VeSCommServiceExecuted)lo_return;
                if (lo_service_executed.io_exception != null) {
                    throw new VeSPagueClientException((Throwable)lo_service_executed.io_exception);
                }
                lo_return = lo_service_executed.io_executed;
            }
        }
        catch (InterruptedException ex) {
            throw new VeSPagueClientException("Transa\u00e7\u00e3o interrompida inesperadamente.", 30007);
        }
        if (lo_return == null) {
            throw new VSPagueClientException(ClientMensagem.tempoExcedidoRespostaTransacao.mensagem(), 30001);
        }
        return lo_return;
    }

    protected Object ReceiveWait(long an_time, VeSCommService ao_service) throws Exception {
        Serializable lo_return = null;
        LinkedBlockingQueue lo_lbq_service = (LinkedBlockingQueue)this.io_received.get(ao_service.is_service);
        try {
            lo_return = (Serializable)(an_time == 0L ? lo_lbq_service.take() : lo_lbq_service.poll(an_time, TimeUnit.MILLISECONDS));
            if (lo_return instanceof Throwable) {
                LOGGER.error("servico de excecao recebido ", lo_return);
                if (this.io_sended.containsKey(ao_service.is_service)) {
                    LinkedBlockingQueue lo_arl = (LinkedBlockingQueue)this.io_sended.get(ao_service.is_service);
                    lo_arl.add(ao_service);
                }
                throw new VeSPagueClientException((Throwable)lo_return);
            }
            if (lo_return instanceof VeSCommServiceExecuted) {
                VeSCommServiceExecuted lo_service_executed = (VeSCommServiceExecuted)lo_return;
                if (lo_service_executed.io_exception != null) {
                    throw new VeSPagueClientException((Throwable)lo_service_executed.io_exception);
                }
                lo_return = lo_service_executed.io_executed;
            }
        }
        catch (InterruptedException ex) {
            throw new VeSPagueClientException("Transa\u00e7\u00e3o interrompida inesperadamente.", 30007);
        }
        if (lo_return == null) {
            throw new VSPagueClientException(ClientMensagem.tempoExcedidoRespostaTransacao.mensagem(), 30001);
        }
        return lo_return;
    }

    public void Stop() {
        if (this.io_th_receive != null && this.io_th_receive.isAlive()) {
            this.io_th_receive.interrupt();
            this.io_th_receive = null;
        }
        if (this.io_th_getlog != null && this.io_th_getlog.isAlive()) {
            this.io_th_getlog.interrupt();
            this.io_th_getlog = null;
        }
        if (this.io_th_parametro_atualizar != null && this.io_th_parametro_atualizar.isAlive()) {
            this.io_th_parametro_atualizar.interrupt();
            this.io_th_parametro_atualizar = null;
        }
        try {
            this.Disconnect();
        }
        catch (VeSComm.VeSCommException veSCommException) {
            // empty catch block
        }
    }

    @Deprecated
    public final boolean isUpdating() {
        return false;
    }

    public Boolean isActive() {
        if (this.io_activate != null && this.io_activate.ib_active) {
            return true;
        }
        return false;
    }

    public VeSPagueConfiguracaoTerminal TerminalConfiguracaoGet(VeSPagueConfiguracaoPesquisar ao_configuracao) {
        return ao_configuracao.ConfiguracaoDataGet().io_cfg_terminal;
    }

    private final int TimeOutTerminalGet() throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        return this.io_transaction_manager.io_datastore.ConfiguracaoDataGet() != null && this.io_transaction_manager.io_datastore.ConfiguracaoDataGet().io_cfg_terminal != null && this.io_transaction_manager.io_datastore.ConfiguracaoDataGet().io_cfg_terminal.in_timeout != null ? this.io_transaction_manager.io_datastore.ConfiguracaoDataGet().io_cfg_terminal.in_timeout : 60;
    }

    public final String[] ConnectionIdentifierGet() {
        String[] ls_identificar = new String[]{this.io_parametro_information.is_computador_nome, VeSUtil.ArrayToString((Object[])((String[])VeSUtil.ArrayNullRemove((Object)this.io_parametro_information.is_computador_endereco)), (String)"-"), this.io_parametro_information.in_computador_porta == null ? null : this.io_parametro_information.in_computador_porta.toString()};
        if (this.io_parametro_information.is_cnpj_cpf != null) {
            ls_identificar = (String[])VeSUtil.ArrayConcatenate((Object)ls_identificar, (Object)new String[]{this.io_parametro_information.is_cnpj_cpf});
        }
        return ls_identificar;
    }

    public final void ConnectionIdentifierSet(String as_identifier, String as_hostname, String[] as_mac_address, VeSInteger an_port, String as_estabelecimento, String as_loja, String as_terminal, String as_cnpj_cpf) {
        String parametroVersao = null;
        if (this.io_cfg_data != null) {
            parametroVersao = this.io_cfg_data.io_cfg_terminal.is_parametros_versao;
        }
        this.io_parametro_information = new VeSPagueParametroInfo(Boolean.valueOf(false), as_hostname, as_mac_address, an_port, as_estabelecimento, as_loja, as_terminal, parametroVersao, VeSPagueClient.ApplicationVersionGet().toString(), as_cnpj_cpf);
        this.io_parametro_information.setLayout(VeSPagueClientUtil.LAYOUT_CONF.CONFIGURACAO_PARCIAL.layout());
        this.IdentifierSet(String.valueOf(this.io_parametro_information.is_computador_nome) + "(" + VeSUtil.ArrayToString((Object[])this.io_parametro_information.is_computador_endereco) + ")" + "/" + VBIMain.ApplicationGet() + "(" + VBIMain.HOST_NAME + ")" + "/" + "(" + as_identifier + ")" + (this.io_parametro_information.in_computador_porta == null ? "" : "/" + this.io_parametro_information.in_computador_porta) + (this.io_parametro_information.is_cnpj_cpf == null ? "" : "/" + this.io_parametro_information.is_cnpj_cpf));
    }

    public final void ConnectionIdentifierDriverSet(String as_identifier, String as_hostname, String[] as_mac_address, VeSInteger an_port, String as_estabelecimento, String as_loja, String as_terminal, String as_cnpj_cpf) {
        String parametroVersao = null;
        if (this.io_cfg_data != null) {
            parametroVersao = this.io_cfg_data.io_cfg_terminal.is_parametros_versao;
        }
        if (this.io_parametro_information == null) {
            this.io_parametro_information = new VeSPagueParametroInfo(Boolean.valueOf(false), as_hostname, as_mac_address, an_port, as_estabelecimento, as_loja, as_terminal, parametroVersao, VeSPagueClient.ApplicationVersionGet().toString(), as_cnpj_cpf);
            this.io_parametro_information.setLayout(VeSPagueClientUtil.LAYOUT_CONF.CONFIGURACAO_PARCIAL.layout());
            VSPagueClientMainInstance.setDefaultLayoutConf((Integer)VeSPagueClientUtil.LAYOUT_CONF.CONFIGURACAO_PARCIAL.layout());
        } else {
            this.io_parametro_information = new VeSPagueParametroInfo(Boolean.valueOf(false), as_hostname, as_mac_address, an_port, as_estabelecimento, as_loja, as_terminal, parametroVersao, VeSPagueClient.ApplicationVersionGet().toString(), as_cnpj_cpf);
            this.io_parametro_information.setLayout(VSPagueClientMainInstance.getDefaultLayoutConf().intValue());
        }
        this.IdentifierSet(String.valueOf(this.io_parametro_information.is_computador_nome) + "(" + VeSUtil.ArrayToString((Object[])this.io_parametro_information.is_computador_endereco) + ")" + "/" + VBIMain.ApplicationGet() + "(" + VBIMain.HOST_NAME + ")" + "/" + "(" + as_identifier + ")" + (this.io_parametro_information.in_computador_porta == null ? "" : "/" + this.io_parametro_information.in_computador_porta) + (this.io_parametro_information.is_cnpj_cpf == null ? "" : "/" + this.io_parametro_information.is_cnpj_cpf));
    }

    public final VeSPagueParametroInfo ParameterInformationGet() {
        return this.io_parametro_information;
    }

    private void configureBreakIdleTime(Integer seconds) {
        if (this.getComm() instanceof VeSCommSocket) {
            VeSCommSocket veSCommSocket = (VeSCommSocket)this.getComm();
            veSCommSocket.configureBreakIdleTime(seconds);
        }
    }

    public boolean isAtivacaoProcessar() {
        return this.io_cfg_data == null || this.io_transaction_manager.io_client.LogGet().TransactionResolveGet().getBaixarConf();
    }

    protected VeSComm createVeSComm(VBICommInterface vbiCommInterface, String[] xml) throws VBIXmlException {
        6 vbiCommInterfaceLocal = new /* Unavailable Anonymous Inner Class!! */;
        return super.createVeSComm((VBICommInterface)vbiCommInterfaceLocal, xml);
    }

    public void configuraTransacao() throws Exception {
        VeSPaguePinpad veSPaguePinpad = this.io_transaction_manager.io_client.PinpadGet();
        VeSPagueConfiguracaoClient vsPagueConfiguracaoClient = this.io_transaction_manager.DatastoreGet();
        VeSPagueTransacao veSPagueTransacao = this.io_transaction_manager.TransactionGet();
        ServerWindowProcess veSWindowProgress = new ServerWindowProcess(ClientMensagem.configurandoTransacao.mensagem(), VeSPagueClient.VISIBLE && !this.io_transaction_manager.isTefOculto(), false);
        AtomicReference exceptionServico = new AtomicReference();
        try {
            veSWindowProgress.ThreadExecute(() -> {
                try {
                    this.configuraTransacao(veSPagueTransacao, veSPaguePinpad, vsPagueConfiguracaoClient);
                }
                catch (Exception e) {
                    exceptionServico.set(e);
                }
            });
        }
        finally {
            veSWindowProgress.WindowClose();
        }
        if (exceptionServico.get() != null) {
            throw (Exception)exceptionServico.get();
        }
    }

    private void configuraTransacao(VeSPagueTransacao veSPagueTransacao, VeSPaguePinpad veSPaguePinpad, VeSPagueConfiguracaoClient veSPagueConfiguracaoClient) throws Exception {
        block25: {
            block27: {
                block26: {
                    if (veSPaguePinpad != null && veSPaguePinpad.in_cartao_rede_adquirente != null && veSPaguePinpad.in_cartao_rede_adquirente.intValue() > 0) {
                        int acquirerIndex = veSPagueConfiguracaoClient.EMVIndexToNet(veSPaguePinpad.in_cartao_rede_adquirente.intValue(), veSPaguePinpad.in_cartao_registro_indice.intValue());
                        int aidIndex = veSPagueConfiguracaoClient.AIDIndexToArrayIndex(acquirerIndex, veSPaguePinpad.in_cartao_registro_indice.intValue());
                        VeSPagueValorLojaRedeConfiguracao acquirerConfiguration = veSPagueConfiguracaoClient.ConfiguracaoDataGet().io_cfg_parametro[acquirerIndex].io_valor_loja_rede;
                        veSPagueTransacao.TransacaoCartaoGet().is_aid = acquirerConfiguration.io_chip[aidIndex].is_application_identifier;
                        veSPagueTransacao.is_rede = acquirerConfiguration.is_rede;
                        veSPagueTransacao.is_rede_versao = acquirerConfiguration.is_rede_versao;
                        List redesPinpad = veSPaguePinpad.getRedes();
                        if (!redesPinpad.isEmpty()) {
                            veSPagueTransacao.setRedesPinpad(redesPinpad.toArray(new String[0]));
                        }
                    }
                    long timeoutService = TimeUnit.SECONDS.toMillis(15L);
                    this.configureBreakIdleTime(Integer.valueOf(200));
                    veSPagueTransacao.is_estabelecimento = this.io_transaction_manager.io_client.getEstabelecimento();
                    veSPagueTransacao.is_loja = this.io_transaction_manager.io_client.getLoja();
                    veSPagueTransacao.is_terminal = this.io_transaction_manager.io_client.getTerminal();
                    veSPagueTransacao.io_parametros_info = this.io_transaction_manager.io_client_to_server.io_parametro_information;
                    VeSPagueTransacao transacaoConfiguraTransacao = veSPagueTransacao.clone();
                    if (transacaoConfiguraTransacao.TransacaoCartaoGet() != null) {
                        transacaoConfiguraTransacao.TransacaoCartaoGet().is_cartao_numero = null;
                        transacaoConfiguraTransacao.TransacaoCartaoGet().ih_cartao_trilha1 = null;
                        transacaoConfiguraTransacao.TransacaoCartaoGet().ih_cartao_trilha2 = null;
                        transacaoConfiguraTransacao.TransacaoCartaoGet().is_cvv2 = null;
                        transacaoConfiguraTransacao.TransacaoCartaoGet().id_validade = null;
                    }
                    VeSPagueTransacaoKeyword veSPagueTransacaoKeyword = new VeSPagueTransacaoKeyword(transacaoConfiguraTransacao);
                    try {
                        ((LinkedBlockingQueue)this.io_received.get(VeSPagueClientUtil.VSPAGUE_CONFIGURA_TRANSACAO)).clear();
                    }
                    catch (Exception e) {
                        LOGGER.error("ocorreu erro ao apagar a fila de mensagem do servico {}", (Object)VeSPagueClientUtil.VSPAGUE_CONFIGURA_TRANSACAO, (Object)e);
                    }
                    VeSPagueConfiguracaoData receive = (VeSPagueConfiguracaoData)this.SendReceive(VeSPagueClientUtil.SERVICE_CONFIGURA_TRANSACAO, (Serializable)((Object)veSPagueTransacaoKeyword.toString()), (int)timeoutService);
                    if (receive == null) {
                        throw new VeSPagueClientException("TO - TENTE NOVAMENTE");
                    }
                    if (receive.isBaixarConfiguracao()) {
                        VeSPagueUtil.TransactionResolve transactionResolve = this.io_transaction_manager.io_client.LogGet().TransactionResolveGet();
                        if (receive.isBaixarConfiguracao() && !transactionResolve.getBaixarConf()) {
                            LOGGER.info("recebeu indicativo para baixar .conf");
                            transactionResolve.setBaixarConf(true);
                            this.io_transaction_manager.io_client.LogGet().saveLogDisk(transactionResolve);
                        }
                        if (receive.getLayout() != this.io_transaction_manager.io_client_to_server.io_parametro_information.getLayout()) {
                            LOGGER.info("mudanca de layout solicitada de {} para {}", (Object)this.io_transaction_manager.io_client_to_server.io_parametro_information.getLayout(), (Object)receive.getLayout());
                            this.io_transaction_manager.io_client_to_server.io_parametro_information.setLayout(receive.getLayout());
                        }
                    }
                    if (receive.io_cfg_parametro == null && VeSPagueClientUtil.TRANSACAO_TIPO_ADMINISTRACAO_EXTRATO_GERAL.equals(veSPagueTransacao.is_tipo)) {
                        return;
                    }
                    if (receive.io_cfg_parametro != null && VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_CONFIRMAR.equals(veSPagueTransacao.is_tipo)) {
                        return;
                    }
                    if (receive.io_cfg_parametro == null || receive.io_cfg_parametro.length == 0) {
                        throw new VeSPagueClientException("Nenhuma configura\u00e7\u00e3o encontrada para a opera\u00e7\u00e3o");
                    }
                    boolean nenhumaConfiguracao = Arrays.stream(receive.io_cfg_parametro).allMatch(veSPagueConfiguracaoParametro -> veSPagueConfiguracaoParametro.io_valor_loja_bits == null || veSPagueConfiguracaoParametro.io_valor_loja_bits.length == 0);
                    if (nenhumaConfiguracao) {
                        throw new VeSPagueClientException("Nenhuma configura\u00e7\u00e3o encontrada para a opera\u00e7\u00e3o");
                    }
                    String redePinpad = veSPaguePinpad != null && veSPagueTransacao.TransacaoCartaoGet() != null && veSPaguePinpad.in_cartao_rede_adquirente != null && veSPaguePinpad.in_cartao_registro_indice.intValue() >= 0 ? veSPaguePinpad.AcquirerGet(veSPaguePinpad.in_cartao_rede_adquirente, veSPaguePinpad.in_cartao_registro_indice) : null;
                    this.io_cfg_data.io_cfg_parametro = receive.io_cfg_parametro;
                    this.io_cfg_data.in_bits_index = receive.in_bits_index;
                    this.io_cfg_data.in_parametros_index = receive.in_parametros_index;
                    this.io_transaction_manager.configureTransactionDataStore(this.io_transaction_manager.io_client_to_server.createConfiguracaoPesquisar(this.io_cfg_data));
                    this.io_transaction_manager.DatastoreGet().TransacaoTipoFiltrar((Object)veSPagueTransacao.is_tipo);
                    if (receive.getValorTaxa() != null) {
                        veSPagueTransacao.in_transacao_taxa = new VeSDecimal(receive.getValorTaxa());
                    }
                    if (redePinpad == null) break block25;
                    if (this.io_cfg_data.io_cfg_parametro.length != 1) break block26;
                    if (this.io_cfg_data.io_cfg_parametro[0].io_valor_loja_rede.is_rede.equals(redePinpad)) break block27;
                    VeSPagueConfiguracaoParametro veSPagueConfiguracaoParametroReceive = this.io_cfg_data.io_cfg_parametro[0];
                    if (veSPagueTransacao.TransacaoCartaoGet() == null || veSPaguePinpad.in_cartao_rede_adquirente == null || veSPaguePinpad.in_cartao_rede_adquirente.intValue() <= 0) break block27;
                    String ls_aid = veSPagueTransacao.TransacaoCartaoGet().is_aid;
                    String ls_tipo_cartao = veSPagueTransacao.TransacaoCartaoGet().is_tipo;
                    VeSPagueValorLojaRedeConfiguracao.Chip[] lo_lst_chip = veSPagueConfiguracaoParametroReceive.io_valor_loja_rede.io_chip;
                    int ln_chip = 0;
                    while (!(ln_chip >= lo_lst_chip.length || lo_lst_chip[ln_chip].is_application_identifier.equals(ls_aid) && lo_lst_chip[ln_chip].is_tipo_cartao.equals(ls_tipo_cartao))) {
                        ++ln_chip;
                    }
                    if (ln_chip >= lo_lst_chip.length) {
                        VeSPagueMessageOld lo_message = VeSPagueMessageOld.MessageGet((int)118);
                        throw new RuntimeException("[" + lo_message.CodeGet() + "] " + lo_message.toString(new Object[]{veSPagueConfiguracaoParametroReceive.io_valor_loja_rede.is_rede, ls_aid}));
                    }
                    veSPaguePinpad.in_cartao_rede_adquirente = veSPagueConfiguracaoParametroReceive.io_valor_loja_rede.io_configuracao.in_emv_identificacao;
                    veSPaguePinpad.in_cartao_registro_indice = lo_lst_chip[ln_chip].in_aid_index;
                    veSPagueTransacao.is_rede = this.io_cfg_data.io_cfg_parametro[0].io_valor_loja_rede.is_rede;
                    veSPagueTransacao.is_rede_versao = this.io_cfg_data.io_cfg_parametro[0].io_valor_loja_rede.is_rede_versao;
                    break block27;
                }
                VeSInteger[] redePrioridade = this.io_transaction_manager.DatastoreGet().getAcquirerEMVIdentifyList();
                if (redePrioridade.length > 0) {
                    String ls_aid = veSPagueTransacao.TransacaoCartaoGet().is_aid;
                    String ls_tipo_cartao = veSPagueTransacao.TransacaoCartaoGet().is_tipo;
                    VeSInteger[] veSIntegerArray = redePrioridade;
                    int n = redePrioridade.length;
                    int n2 = 0;
                    block3: while (n2 < n) {
                        VeSInteger redeEmv = veSIntegerArray[n2];
                        int j = 0;
                        while (j < this.io_cfg_data.io_cfg_parametro.length) {
                            if (this.io_cfg_data.io_cfg_parametro[j].io_valor_loja_rede.io_configuracao.in_emv_identificacao != null && redeEmv.intValue() == this.io_cfg_data.io_cfg_parametro[j].io_valor_loja_rede.io_configuracao.in_emv_identificacao.intValue()) {
                                VeSPagueValorLojaRedeConfiguracao.Chip[] lo_lst_chip;
                                VeSPagueValorLojaRedeConfiguracao.Chip[] chipArray = lo_lst_chip = this.io_cfg_data.io_cfg_parametro[j].io_valor_loja_rede.io_chip;
                                int n3 = lo_lst_chip.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    VeSPagueValorLojaRedeConfiguracao.Chip chip = chipArray[n4];
                                    if (chip.is_application_identifier.equals(ls_aid) && chip.is_tipo_cartao.equals(ls_tipo_cartao)) {
                                        veSPaguePinpad.in_cartao_rede_adquirente = this.io_cfg_data.io_cfg_parametro[j].io_valor_loja_rede.io_configuracao.in_emv_identificacao;
                                        veSPaguePinpad.in_cartao_registro_indice = chip.in_aid_index;
                                        veSPagueTransacao.is_rede = this.io_cfg_data.io_cfg_parametro[j].io_valor_loja_rede.is_rede;
                                        veSPagueTransacao.is_rede_versao = this.io_cfg_data.io_cfg_parametro[j].io_valor_loja_rede.is_rede_versao;
                                        break block3;
                                    }
                                    ++n4;
                                }
                            }
                            ++j;
                        }
                        ++n2;
                    }
                }
            }
            if (veSPagueTransacao.TransacaoCartaoGet() != null && veSPagueTransacao.TransacaoCartaoGet().is_cartao_numero != null) {
                this.io_transaction_manager.DatastoreGet().CartaoNumeroFiltrar(veSPagueTransacao.TransacaoCartaoGet().is_cartao_numero, true);
            }
        }
        if (VeSPagueClientUtil.TRANSACAO_TIPO_ADMINISTRACAO_CANCELAR.equals(veSPagueTransacao.is_tipo)) {
            this.io_transaction_manager.DatastoreGet().TransacaoCancelamentoFiltrarBits(veSPagueTransacao);
        }
        if (this.io_cfg_data.in_parametros_index.length > 0 && (VeSPagueClientUtil.TRANSACAO_TIPO_CONTA_PAGAR.equals(this.io_transaction_manager.TransactionGet().is_tipo) || VeSPagueClientUtil.TRANSACAO_TIPO_CONTA_CARNE_PAGAR.equals(this.io_transaction_manager.TransactionGet().is_tipo) || VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_PAGAR.equals(this.io_transaction_manager.TransactionGet().is_tipo))) {
            this.io_transaction_manager.DatastoreGet().TransacaoTipoContaParametroFiltrar();
        }
    }

    public IUpdateConfiguration getStatusUpdateControler() {
        return this.statusUpdateControler;
    }

    static /* synthetic */ VeSPagueClientTransactionManager access$0(VeSPagueClientToServer veSPagueClientToServer) {
        return veSPagueClientToServer.io_transaction_manager;
    }

    static /* synthetic */ Logger access$1() {
        return LOGGER;
    }

    static /* synthetic */ String access$2(VeSPagueClientToServer veSPagueClientToServer) {
        return veSPagueClientToServer.is_address;
    }

    static /* synthetic */ IUpdateConfiguration access$3(VeSPagueClientToServer veSPagueClientToServer) {
        return veSPagueClientToServer.statusUpdateControler;
    }

    static /* synthetic */ Thread access$4(VeSPagueClientToServer veSPagueClientToServer) {
        return veSPagueClientToServer.io_th_getlog;
    }
}

