/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.lib.comm;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import lib.VeSUtil;
import lib.comm.VeSComm;
import lib.comm.structure.VeSCommConfiguration;
import lib.comm.structure.VeSCommConnectScript;
import lib.interfac.VBIInterfaceUnderflowException;
import lib.thread.VBIThread;
import lib.type.VeSException;
import lib.xml.VBIXmlException;
import vespague.client.lib.comm.VSPagueClientComm;

public abstract class VSPagueClientComm
extends VeSComm
implements Runnable {
    private static final Map<VeSComm, ArrayList<VSPagueClientComm>> SHAREDS = new ConcurrentHashMap();
    private final TYPE ie_type;
    private VeSComm io_comm;
    protected final LinkedBlockingQueue<VeSComm.VeSCommReceive> io_lbq_received = new LinkedBlockingQueue();
    private VBIThread io_thd_receive;
    private final String identifier;

    static {
        String ls_thread_name = "V$PagueClientComm.SharedsManager";
        new VBIThread(ls_thread_name, false, false, true, false, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public VSPagueClientComm(String identifier, TYPE ae_type, VeSCommConfiguration ao_configuration) throws VBIXmlException {
        super(new VeSCommConfiguration[]{ao_configuration});
        this.ie_type = ae_type;
        this.identifier = identifier;
    }

    public VSPagueClientComm(String identifier, TYPE ae_type, VeSComm ao_comm) throws VeSComm.VeSCommException {
        super(new VeSCommConfiguration[]{ao_comm.ConfigurationGet()});
        this.ie_type = ae_type;
        this.identifier = identifier;
        this.Connect(null, ao_comm);
    }

    protected final void Connect() throws VeSComm.VeSCommAlreadyConnectedException, VeSComm.VeSCommException {
    }

    public Integer[] Connect(VeSCommConnectScript ao_connect_script) throws VeSComm.VeSCommAlreadyConnectedException, VeSComm.VeSCommException {
        if (this.io_comm != null) {
            throw new VeSComm.VeSCommAlreadyConnectedException();
        }
        VeSComm lo_comm_work = null;
        try {
            lo_comm_work = VeSComm.Factory((String)this.ConfigurationGet().XmlGet());
        }
        catch (VBIXmlException ex) {
            throw new VeSComm.VeSCommException((Throwable)ex);
        }
        Integer[] ln_connections = this.Connect(ao_connect_script, lo_comm_work);
        return ln_connections;
    }

    private final Integer[] Connect(VeSCommConnectScript ao_connect_script, VeSComm ao_comm) throws VeSComm.VeSCommException {
        Integer[] ln_connections = null;
        if (SHAREDS.get(ao_comm) != null && !((ArrayList)SHAREDS.get(ao_comm)).isEmpty()) {
            ArrayList lo_arl_client_comm = (ArrayList)((ArrayList)SHAREDS.get(ao_comm)).clone();
            for (VSPagueClientComm lo_client_comm : lo_arl_client_comm) {
                if (lo_client_comm.ie_type != this.ie_type && lo_client_comm.io_comm.equals((Object)ao_comm)) {
                    ((ArrayList)SHAREDS.get(ao_comm)).add(this.ie_type == TYPE.PIN_PAD ? 0 : ((ArrayList)SHAREDS.get(ao_comm)).size(), this);
                    ao_comm = lo_client_comm.io_comm;
                    this.io_thd_receive = lo_client_comm.io_thd_receive;
                    continue;
                }
                throw new IllegalArgumentException("N\u00e3o \u00e9 permitido conex\u00f5es de mesmo tipo (" + this.ie_type + ")");
            }
            ArrayList<Integer> lo_arl_connections = new ArrayList<Integer>();
            VeSComm.VeSCommConnection[] veSCommConnectionArray = ao_comm.ConnectionGet();
            int n = veSCommConnectionArray.length;
            int n2 = 0;
            while (n2 < n) {
                VeSComm.VeSCommConnection lo_connection = veSCommConnectionArray[n2];
                lo_arl_connections.add(lo_connection.in_connection);
                ++n2;
            }
            ln_connections = lo_arl_connections.toArray(new Integer[lo_arl_connections.size()]);
        } else {
            ln_connections = ao_comm.Disconnected() ? ao_comm.Connect(ao_connect_script, 50) : new Integer[]{ao_comm.ConnectionGet().length};
            ArrayList<VSPagueClientComm> lo_arl_client_comm = new ArrayList<VSPagueClientComm>();
            lo_arl_client_comm.add(this);
            SHAREDS.put(ao_comm, lo_arl_client_comm);
            this.io_thd_receive = this.ReceiveThreadCreate(String.valueOf(this.getClass().getSimpleName()) + ".Receive." + this.ie_type + "|" + ao_comm + "-" + this.identifier);
        }
        this.io_comm = ao_comm;
        if (!this.io_thd_receive.Alive()) {
            this.io_thd_receive.Start();
        }
        return ln_connections;
    }

    public final boolean Connected() {
        return this.io_comm != null && this.io_comm.Connected();
    }

    private final void ConnectionCheck() throws VeSComm.VBICommDisconnectedException {
        if (this.Disconnected()) {
            throw new VeSComm.VBICommDisconnectedException();
        }
    }

    protected final void Disconnect() {
        this.DisconnectAll();
    }

    protected final void Disconnect(VeSComm.VeSCommConnection ao_connection) {
        this.io_comm.Disconnect(Integer.valueOf(ao_connection.in_connection));
    }

    public void DisconnectAll() {
        if (!this.Disconnected()) {
            ArrayList list = (ArrayList)SHAREDS.get(this.io_comm);
            if (list != null) {
                list.remove(this);
                if (list.isEmpty()) {
                    SHAREDS.remove(this.io_comm);
                    if (this.io_comm.Connected()) {
                        this.io_comm.DisconnectAll();
                    }
                    this.io_thd_receive.Interrupt(null);
                }
            }
            this.io_comm = null;
        } else {
            LOGGER.info(this + " j\u00e1 desconectado");
        }
    }

    public final boolean Disconnected() {
        return this.io_comm == null;
    }

    public final byte[] Receive() throws VeSComm.VBICommDisconnectedException, VeSComm.VeSCommNotConnectedException {
        this.ConnectionCheck();
        VeSComm.VeSCommReceive lo_received = (VeSComm.VeSCommReceive)this.io_lbq_received.poll();
        if (lo_received != null) {
            this.Log('R', this + "<-", VeSUtil.ByteToHexa((byte[])lo_received.ih_buffer));
        }
        return lo_received != null ? lo_received.ih_buffer : null;
    }

    public final byte[] Receive(Long an_timeout) throws VeSComm.VBICommDisconnectedException, VeSComm.VeSCommNotConnectedException, InterruptedException {
        this.ConnectionCheck();
        VeSComm.VeSCommReceive lo_received = (VeSComm.VeSCommReceive)this.io_lbq_received.poll(an_timeout == 0L ? 1000L : an_timeout, TimeUnit.MILLISECONDS);
        if (lo_received != null) {
            this.Log('R', "R  " + this + "<-", VeSUtil.ByteToHexa((byte[])lo_received.ih_buffer));
        }
        return lo_received != null ? lo_received.ih_buffer : null;
    }

    public final VeSComm.VeSCommReceive ReceiveAny() throws VeSComm.VBICommDisconnectedException {
        this.ConnectionCheck();
        VeSComm.VeSCommReceive lo_received = (VeSComm.VeSCommReceive)this.io_lbq_received.poll();
        if (lo_received != null) {
            this.Log('R', this + "<-", VeSUtil.ByteToHexa((byte[])lo_received.ih_buffer));
        }
        return lo_received;
    }

    public final VeSComm.VeSCommReceive ReceiveAny(Long an_timeout) throws VeSComm.VBICommDisconnectedException, InterruptedException {
        this.ConnectionCheck();
        VeSComm.VeSCommReceive lo_received = (VeSComm.VeSCommReceive)this.io_lbq_received.poll(an_timeout == 0L ? 1000L : an_timeout, TimeUnit.MILLISECONDS);
        if (lo_received != null) {
            this.Log('R', "RA " + this + "<-", VeSUtil.ByteToHexa((byte[])lo_received.ih_buffer));
        }
        return lo_received;
    }

    private final VBIThread ReceiveThreadCreate(String as_name) {
        return new VBIThread(as_name, false, false, false, false, (Runnable)this);
    }

    @Override
    public final void run() {
        try {
            byte[] lh_received = new byte[]{};
            long ln_timeout = 3L;
            while (!this.io_thd_receive.Interrupted() && this.io_comm != null && !this.io_comm.Disconnected() && this.io_comm.Connected()) {
                try {
                    VeSComm.VeSCommReceive lo_receive = this.io_comm.ReceiveAny(Long.valueOf(1000L));
                    if (lo_receive == null) continue;
                    if (lo_receive.ih_buffer == null || lo_receive.ih_buffer.length == 0) {
                        if (lh_received.length > 0) {
                            byte[] lh_tmp_received = lh_received;
                            lh_received = new byte[]{};
                            throw new VBIInterfaceUnderflowException("Ignorados " + lh_tmp_received.length + " bytes ap\u00f3s aguardar " + ln_timeout + " segundos por novos bytes: " + VeSUtil.ByteToHexa((byte[])lh_tmp_received));
                        }
                        throw new VBIInterfaceUnderflowException("Nenhum byte recebido");
                    }
                    lh_received = (byte[])VeSUtil.ArrayConcatenate((Object)lh_received, (Object)lo_receive.ih_buffer);
                    while (lh_received.length > 0) {
                        TYPE lo_type = this.TypeSearch(lh_received);
                        VSPagueClientComm lo_client_comm = this.CommSearch(lo_type);
                        int ln_pointer = this.PointSearch(lh_received);
                        if (ln_pointer == -1) {
                            throw new VBIInterfaceUnderflowException("Buffer incompleto. Lendo mais dados (" + lh_received.length + ")");
                        }
                        byte[] lh_received_notify = (byte[])VeSUtil.ArrayTruncate((Object)lh_received, (int)0, (int)ln_pointer);
                        lh_received = (byte[])VeSUtil.ArrayTruncate((Object)lh_received, (int)ln_pointer, (int)lh_received.length);
                        VeSComm.VeSCommReceive lo_receive_notify = new VeSComm.VeSCommReceive(lo_receive.io_connection, lo_receive.id_timestamp, (Object)lh_received_notify);
                        if (lo_client_comm == null) continue;
                        lo_client_comm.io_lbq_received.put(lo_receive_notify);
                    }
                }
                catch (VBIInterfaceUnderflowException ex) {
                    LOGGER.error(VeSException.MessageGet((Throwable)ex));
                }
            }
        }
        catch (VeSComm.VeSCommException veSCommException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private final TYPE TypeSearch(byte[] ah_receive) throws VeSComm.VeSCommException {
        TYPE lo_type = null;
        lo_type = ah_receive[0] == 4 || ah_receive[0] == 6 || ah_receive[0] == 21 || ah_receive[0] == 22 || ah_receive[0] == 24 ? TYPE.PIN_PAD : TYPE.VSPAGUE_CLIENT_DRIVER;
        if (lo_type == null) {
            throw new VeSComm.VeSCommException("Pacote n\u00e3o identificado (" + ah_receive[0] + ")");
        }
        return lo_type;
    }

    private final int PointSearch(byte[] ah_receive) throws VeSComm.VeSCommException {
        int ln_pointer = -1;
        if (ah_receive[0] == 22) {
            int ln_founded_etb = VeSUtil.IndexOf((byte[])ah_receive, (byte[])new byte[]{23}, (int)0);
            if (ln_founded_etb >= 0 && ln_founded_etb + 3 <= ah_receive.length) {
                ln_pointer = ln_founded_etb + 3;
            }
        } else if (ah_receive[0] == 4 || ah_receive[0] == 6 || ah_receive[0] == 21 || ah_receive[0] == 24) {
            ln_pointer = 1;
        } else {
            byte[] lh_sequence_final = "\r\n\t\t\r\n\t\t\t\r\n\t\t\r\n\t".getBytes();
            int ln_founded_sequence_final = VeSUtil.IndexOf((byte[])ah_receive, (byte[])lh_sequence_final, (int)0);
            if (ln_founded_sequence_final >= 0) {
                ln_pointer = ln_founded_sequence_final + lh_sequence_final.length;
            }
        }
        return ln_pointer;
    }

    private final VSPagueClientComm CommSearch(TYPE ao_type) {
        VSPagueClientComm lo_client_comm = null;
        if (this.io_comm == null) {
            LOGGER.warn("Sem comunica\u00e7\u00e3o para analisar VSPagueClientComm.");
            return null;
        }
        ArrayList lo_arl = (ArrayList)SHAREDS.get(this.io_comm);
        if (lo_arl == null) {
            LOGGER.warn("Nenhum COM encontrada na configura\u00e7\u00e3o informada.");
            return null;
        }
        if (lo_arl.size() == 1) {
            lo_client_comm = (VSPagueClientComm)lo_arl.get(0);
        } else {
            int ln_1 = 0;
            while (lo_client_comm == null && ln_1 < lo_arl.size()) {
                if (ao_type == ((VSPagueClientComm)lo_arl.get((int)ln_1)).ie_type) {
                    lo_client_comm = (VSPagueClientComm)lo_arl.get(ln_1);
                }
                ++ln_1;
            }
        }
        return lo_client_comm;
    }

    public final void Send(byte[] ah_buffer) throws VeSComm.VBICommDisconnectedException, VeSComm.VeSCommNotConnectedException {
        this.ConnectionCheck();
        this.Log('S', "S  " + this + "->", VeSUtil.ByteToHexa((byte[])ah_buffer));
        this.io_comm.Send(ah_buffer);
    }

    public final void SendWithClearReceived(byte[] ah_buffer) throws VeSComm.VBICommDisconnectedException, VeSComm.VeSCommNotConnectedException {
        this.ConnectionCheck();
        this.io_lbq_received.clear();
        this.Log('S', "SC " + this + "->", VeSUtil.ByteToHexa((byte[])ah_buffer));
        this.io_comm.SendWithClearReceived(ah_buffer);
    }

    protected abstract int PointerSearch(byte[] var1) throws VBIInterfaceUnderflowException;

    public final boolean equals(Object ao_object) {
        return this == ao_object;
    }

    public final String toString() {
        return String.valueOf(this.io_comm != null ? this.io_comm + "[" : "") + "[" + this.ie_type + "]" + super.toString();
    }

    protected abstract void Log(char var1, String var2, String var3);

    public final boolean Shared() {
        return ((ArrayList)SHAREDS.get(this.io_comm)).size() > 1;
    }

    static /* synthetic */ Map access$0() {
        return SHAREDS;
    }
}

