/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.lib.comm;

import java.math.BigInteger;
import lib.VeSUtil;
import lib.comm.VeSComm;
import lib.comm.structure.VeSCommConfiguration;
import lib.type.VBIDatetime;
import lib.xml.VBIXmlException;
import vespague.client.lib.comm.VSPagueClientComm;

public class VSPagueClientCommPinpad
extends VSPagueClientComm {
    public VSPagueClientCommPinpad(String identifier, VeSCommConfiguration ao_configuration) throws VBIXmlException {
        this(identifier, VSPagueClientComm.TYPE.PIN_PAD, ao_configuration);
    }

    private VSPagueClientCommPinpad(String identifier, VSPagueClientComm.TYPE ae_type, VeSCommConfiguration ao_configuration) throws VBIXmlException {
        super(identifier, ae_type, ao_configuration);
    }

    public VSPagueClientCommPinpad(String identifier, VeSComm ao_comm) throws VeSComm.VeSCommException {
        super(identifier, VSPagueClientComm.TYPE.PIN_PAD, ao_comm);
    }

    protected final int PointerSearch(byte[] ah_receive) {
        int ln_pointer = -1;
        if (ah_receive[0] == 22) {
            int ln_founded_etb = VeSUtil.IndexOf((byte[])ah_receive, (byte[])new byte[]{23}, (int)0);
            if (ln_founded_etb >= 0 && ln_founded_etb + 3 <= ah_receive.length) {
                ln_pointer = ln_founded_etb + 3;
            }
        } else if (ah_receive[0] == 4 || ah_receive[0] == 6 || ah_receive[0] == 21 || ah_receive[0] == 24) {
            ln_pointer = 1;
        }
        return ln_pointer;
    }

    public void DisconnectAll() {
        VeSComm.VeSCommReceive lo_receive = new VeSComm.VeSCommReceive(null, new VBIDatetime(), (Object)new byte[]{21});
        this.io_lbq_received.add(lo_receive);
        super.DisconnectAll();
    }

    protected void Log(char direction, String heading, String logHex) {
        try {
            if (direction == 'R' && logHex.startsWith("16") && logHex.length() >= 14) {
                String command = logHex.substring(2, 8);
                String response = logHex.substring(8, 14);
                BigInteger bigInteger = new BigInteger(String.valueOf(command) + response, 16);
                String resultString = new String(bigInteger.toByteArray());
                LOGGER.debug("{}{}", (Object)heading, (Object)resultString);
            } else if (direction == 'S' && logHex.length() >= 8) {
                String command = logHex.substring(2, 8);
                BigInteger bigInteger = new BigInteger(command, 16);
                String resultString = new String(bigInteger.toByteArray());
                LOGGER.debug("{}{}", (Object)heading, (Object)resultString);
            }
        }
        catch (Exception e) {
            LOGGER.error("erro log pinpad: {}", (Object)e.getMessage());
        }
    }
}

