/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import lib.VeSUtil;
import lib.file.VBIFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vespague.client.device.BaixaTecnica;
import vespague.client.util.ArchivesClientUtil;

public class BaixaTecnicaUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaixaTecnicaUtil.class);
    private static final String PATH = ".config";
    private static final String FILE_NAME = "BAIXA_TECNICA.dat";

    public static void createDir(String estabelecimento, String loja, String terminal) {
        File file = new File(ArchivesClientUtil.getArchive((String)estabelecimento, (String)loja, (String)terminal, (String)PATH));
        if (!file.exists()) {
            try {
                if (file.mkdir()) {
                    LOGGER.info("diretorio '.config' criado com sucesso");
                }
            }
            catch (SecurityException e) {
                throw new RuntimeException("falha na configuracao do diretorio '.config'.", e);
            }
        }
    }

    public static void save(String estabelecimento, String loja, String terminal, BaixaTecnica baixaTecnica) {
        try {
            String nomeArquivo = ArchivesClientUtil.getArchive((String)estabelecimento, (String)loja, (String)terminal, (String)(PATH + File.separator + estabelecimento + "_" + loja + "_" + terminal + "_" + FILE_NAME));
            byte[] objetoSerializado = VeSUtil.ObjectToByte((Serializable)baixaTecnica, (boolean)false);
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(nomeArquivo);){
                fileOutputStream.write(objetoSerializado);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            LOGGER.error("erro ao gravar o arquivo de baixatecnica.dat");
        }
    }

    public static BaixaTecnica get(String estabelecimento, String loja, String terminal) {
        try {
            String nomeArquivo = ArchivesClientUtil.getArchive((String)estabelecimento, (String)loja, (String)terminal, (String)(PATH + File.separator + estabelecimento + "_" + loja + "_" + terminal + "_" + FILE_NAME));
            byte[] data = VBIFile.FileToByte((String)nomeArquivo);
            Throwable throwable = null;
            Object var6_8 = null;
            try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
                ObjectInputStream is = new ObjectInputStream(in);
                BaixaTecnica baixaTecnica = (BaixaTecnica)is.readObject();
                is.close();
                return baixaTecnica;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            LOGGER.error("erro ao abrir o arquivo de baixatecnica.dat", (Throwable)ex);
            return null;
        }
    }
}

