/*
 * Decompiled with CFR 0.152.
 */
package vespague.client.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vespague.common.type.VSPagueProdutoConsultaFidelidade;
import vespague.structure.VeSPagueConfirmacaoPositiva;
import vespague.structure.VeSPagueTransacao;

/*
 * Exception performing whole class analysis ignored.
 */
public class LogFormatterUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogFormatterUtil.class);

    private static String requestTransaction(VeSPagueTransacao reqTransaction) {
        ArrayList<String> log = new ArrayList<String>();
        log.add(String.format("perna: %s", reqTransaction.in_perna));
        log.add("tipo: " + reqTransaction.is_tipo);
        log.add("sequencial client: " + reqTransaction.in_sequencial_client);
        if (reqTransaction.in_valor != null) {
            log.add("valor: " + reqTransaction.in_valor);
        }
        if (reqTransaction.in_nsu_original != null) {
            log.add("sequencial transacao: " + reqTransaction.in_sequencial);
            log.add("nsu original: " + reqTransaction.in_nsu_original);
        }
        if (reqTransaction.is_rede != null && reqTransaction.is_rede_versao != null) {
            log.add("rede: " + reqTransaction.is_rede);
            log.add("versao: " + reqTransaction.is_rede_versao);
            if (reqTransaction.is_pagamento != null) {
                log.add("pagamento: " + reqTransaction.is_pagamento);
                if (reqTransaction.is_financiado != null) {
                    log.add("financiado: " + reqTransaction.is_financiado);
                    log.add("parcelas: " + reqTransaction.in_parcelas);
                }
            }
            if (reqTransaction.is_transacao_produto != null) {
                log.add("produto: " + reqTransaction.is_transacao_produto);
            }
            if (reqTransaction.TransacaoCartaoGet() != null) {
                log.addAll(LogFormatterUtil.reqTransactionCard((VeSPagueTransacao.TransacaoCartao)reqTransaction.TransacaoCartaoGet()));
            }
            if (reqTransaction.TransacaoTelefoneGet() != null) {
                log.addAll(LogFormatterUtil.reqTransactionTelephone((VeSPagueTransacao.TransacaoTelefone)reqTransaction.TransacaoTelefoneGet()));
            }
            if (reqTransaction.TransacaoConversaoMoedaGet() != null) {
                log.addAll(LogFormatterUtil.reqTransactionConvertionCoin((VeSPagueTransacao.TransacaoConversaoMoeda)reqTransaction.TransacaoConversaoMoedaGet()));
            }
            if (reqTransaction.TransacaoCrediarioGet() != null) {
                log.addAll(LogFormatterUtil.reqTransacaoCrediario((VeSPagueTransacao.TransacaoCrediario)reqTransaction.TransacaoCrediarioGet()));
            }
            if (reqTransaction.TransacaoFidelidadeGet() != null) {
                log.addAll(LogFormatterUtil.reqTransacaoFidelidade((VeSPagueTransacao.TransacaoFidelidade)reqTransaction.TransacaoFidelidadeGet()));
            }
            if (reqTransaction.io_transacao_confirmacao_positiva_tela != null) {
                log.addAll(LogFormatterUtil.reqTransacaoInformacaoAdicional((VeSPagueConfirmacaoPositiva[])reqTransaction.io_transacao_confirmacao_positiva_tela));
            }
        }
        if (reqTransaction.io_problem != null) {
            log.add("erro: " + reqTransaction.io_problem);
        }
        return String.join((CharSequence)", ", log);
    }

    private static Collection<String> reqTransacaoInformacaoAdicional(VeSPagueConfirmacaoPositiva[] veSPagueConfirmacaoPositivas) {
        ArrayList<String> log = new ArrayList<String>();
        VeSPagueConfirmacaoPositiva[] veSPagueConfirmacaoPositivaArray = veSPagueConfirmacaoPositivas;
        int n = veSPagueConfirmacaoPositivas.length;
        int n2 = 0;
        while (n2 < n) {
            VeSPagueConfirmacaoPositiva veSPagueConfirmacaoPositiva = veSPagueConfirmacaoPositivaArray[n2];
            log.add("codigo: " + veSPagueConfirmacaoPositiva.in_codigo);
            log.add("pergunta: " + veSPagueConfirmacaoPositiva.is_pergunta);
            log.add("resposta: " + new String(veSPagueConfirmacaoPositiva.ih_resposta));
            log.add("tabela indicada: " + veSPagueConfirmacaoPositiva.in_tabela_indicada);
            ++n2;
        }
        return Collections.singletonList("campo dinamico tela: [ " + String.join((CharSequence)", ", log) + " ]");
    }

    private static Collection<String> reqTransacaoFidelidade(VeSPagueTransacao.TransacaoFidelidade transacaoFidelidade) {
        ArrayList<String> log = new ArrayList<String>();
        log.add("codigo: " + transacaoFidelidade.getCodigoProduto());
        log.add("produto: " + transacaoFidelidade.getTipoProduto());
        log.add("plataforma promocional: " + transacaoFidelidade.getNomePlataformaPromocional());
        if (transacaoFidelidade.getProdutoDisponivelResgate() != null) {
            VSPagueProdutoConsultaFidelidade[] vSPagueProdutoConsultaFidelidadeArray = transacaoFidelidade.getProdutoDisponivelResgate();
            int n = vSPagueProdutoConsultaFidelidadeArray.length;
            int n2 = 0;
            while (n2 < n) {
                VSPagueProdutoConsultaFidelidade vsPagueProdutoConsultaFidelidade = vSPagueProdutoConsultaFidelidadeArray[n2];
                log.add("codigo produto: " + vsPagueProdutoConsultaFidelidade.getCodigoProduto());
                log.add("tipo produto: " + vsPagueProdutoConsultaFidelidade.getTipoProduto());
                log.add("descricao produto: " + vsPagueProdutoConsultaFidelidade.getDescricaoProduto());
                log.add("valor produto: " + vsPagueProdutoConsultaFidelidade.getValor());
                ++n2;
            }
        }
        return Collections.singletonList("fidelidade: [ " + String.join((CharSequence)", ", log) + " ]");
    }

    private static Collection<String> reqTransacaoCrediario(VeSPagueTransacao.TransacaoCrediario transacaoCrediario) {
        ArrayList<String> log = new ArrayList<String>();
        VeSPagueTransacao.TransacaoCrediario.Informacoes[] informacoesArray = transacaoCrediario.io_informacao;
        int n = transacaoCrediario.io_informacao.length;
        int n2 = 0;
        while (n2 < n) {
            VeSPagueTransacao.TransacaoCrediario.Informacoes informacoes = informacoesArray[n2];
            log.add("descricao: " + informacoes.is_descricao);
            log.add("informacao: " + informacoes.is_informacao);
            log.add("quantidade parcela: " + informacoes.in_quantidade_parcela);
            ++n2;
        }
        return Collections.singletonList("crediario: [ " + String.join((CharSequence)", ", log) + " ]");
    }

    private static Collection<String> reqTransactionConvertionCoin(VeSPagueTransacao.TransacaoConversaoMoeda transacaoConversaoMoeda) {
        ArrayList<String> log = new ArrayList<String>();
        log.add("display: " + transacaoConversaoMoeda.is_operador_display);
        log.add("troca: " + transacaoConversaoMoeda.is_cliente_aceitou_troca_moeda);
        if (transacaoConversaoMoeda.io_mensagem_pinpad != null) {
            VeSPagueTransacao.TransacaoConversaoMoeda.MensagemConversao[] mensagemConversaoArray = transacaoConversaoMoeda.io_mensagem_pinpad;
            int n = transacaoConversaoMoeda.io_mensagem_pinpad.length;
            int n2 = 0;
            while (n2 < n) {
                VeSPagueTransacao.TransacaoConversaoMoeda.MensagemConversao mensagemConversao = mensagemConversaoArray[n2];
                log.add("display" + mensagemConversao.is_operador_display);
                log.add("pinpad" + mensagemConversao.is_portador_display);
                ++n2;
            }
        }
        return Collections.singletonList("conversao moeda: [ " + String.join((CharSequence)", ", log) + " ]");
    }

    private static List<String> reqTransactionTelephone(VeSPagueTransacao.TransacaoTelefone transacaoTelefone) {
        ArrayList<String> log = new ArrayList<String>();
        log.add("ddd: " + transacaoTelefone.is_telefone_ddd);
        log.add("numero: " + transacaoTelefone.is_telefone_numero.substring(0, 7));
        log.add("concessionaria: " + transacaoTelefone.is_telefone_concessionaria);
        log.add("operadora: " + transacaoTelefone.is_telefone_operadora);
        log.add("valor recarga: " + transacaoTelefone.in_telefone_valor_recarga);
        return Collections.singletonList("telefone [ " + String.join((CharSequence)", ", log) + " ]");
    }

    private static List<String> reqTransactionCard(VeSPagueTransacao.TransacaoCartao transacaoCartao) {
        ArrayList<String> log = new ArrayList<String>();
        if (transacaoCartao.is_cartao_numero != null) {
            if (transacaoCartao.is_cartao_numero.length() >= 8) {
                log.add("bin: " + transacaoCartao.is_cartao_numero.substring(0, 8));
            } else {
                log.add("bin: " + transacaoCartao.is_cartao_numero.substring(0, 6));
            }
        }
        log.add("entrada: " + transacaoCartao.is_entrada);
        log.add("tipo: " + transacaoCartao.is_tipo);
        log.add("senha digitada: " + transacaoCartao.ib_senha_digitada);
        log.add("criptografia de dados: " + (transacaoCartao.in_data_encript_type != null));
        log.add("assina comprovante: " + transacaoCartao.ib_comprovante_assinar);
        if (transacaoCartao.is_aid != null) {
            log.add("aid: " + transacaoCartao.is_aid);
        }
        log.add("trilha 1: " + (transacaoCartao.ih_cartao_trilha1 != null));
        log.add("trilha 2: " + (transacaoCartao.ih_cartao_trilha2 != null));
        log.add("bandeira: " + transacaoCartao.is_administradora);
        log.add("fallback:" + transacaoCartao.HasFallback());
        if (transacaoCartao.ib_status_off_line != null) {
            log.add("offline: " + transacaoCartao.ib_status_off_line);
            log.add("envia rejeitada: " + transacaoCartao.ib_offline_rejeitada_enviar);
        }
        return Collections.singletonList("cartao: [ " + String.join((CharSequence)", ", log) + " ]");
    }

    private static String responseTransaction(VeSPagueTransacao respTransaction) {
        ArrayList<String> log = new ArrayList<String>();
        log.add(String.format("perna: %s", respTransaction.in_perna));
        log.add("sequencial transacao: " + respTransaction.in_sequencial);
        log.add("nsu: " + respTransaction.in_nsu);
        log.add("resposta: " + respTransaction.is_resposta);
        log.add("display: " + respTransaction.is_resposta_video);
        if (respTransaction.is_resposta_mensagem != null) {
            log.add("display mensagem: " + respTransaction.is_resposta_mensagem);
        }
        if (respTransaction.is_resposta_video_cliente != null) {
            log.add("pinpad: " + respTransaction.is_resposta_video_cliente);
        }
        if (respTransaction.in_nsu_rede != null) {
            log.add("nsu rede: " + respTransaction.in_nsu_rede);
        }
        if (respTransaction.is_autorizacao != null) {
            log.add("autorizacao: " + respTransaction.is_autorizacao);
        }
        if (respTransaction.io_problem != null) {
            log.add("erro: " + respTransaction.io_problem);
        }
        return String.join((CharSequence)", ", log);
    }

    private static String finalizeTransaction(VeSPagueTransacao respTransaction) {
        ArrayList<String> log = new ArrayList<String>();
        log.add(String.format("perna: %s", respTransaction.in_perna));
        if (respTransaction.is_rede != null && respTransaction.is_rede_versao != null) {
            log.add("rede: " + respTransaction.is_rede);
            log.add("versao: " + respTransaction.is_rede_versao);
        }
        log.add("sequencial transacao: " + respTransaction.in_sequencial);
        log.add("resposta: " + respTransaction.is_resposta);
        if (respTransaction.is_resposta_video != null) {
            log.add("display: " + respTransaction.is_resposta_video);
        }
        if (respTransaction.is_resposta_mensagem != null) {
            log.add("display mensagem: " + respTransaction.is_resposta_mensagem);
        }
        if (respTransaction.is_resposta_video_cliente != null) {
            log.add("pinpad: " + respTransaction.is_resposta_video_cliente);
        }
        if (respTransaction.io_problem != null) {
            log.add("erro: " + respTransaction.io_problem);
        }
        return String.join((CharSequence)", ", log);
    }

    public static void logTransaction(String clientId, VeSPagueTransacao veSPagueTransacao) {
        try {
            if (veSPagueTransacao.in_perna != null && veSPagueTransacao.in_perna.intValue() == 1) {
                LOGGER.info("{}: {}", (Object)clientId, (Object)LogFormatterUtil.requestTransaction((VeSPagueTransacao)veSPagueTransacao));
            } else if (veSPagueTransacao.in_perna != null && veSPagueTransacao.in_perna.intValue() == 2) {
                LOGGER.info("{}: {}", (Object)clientId, (Object)LogFormatterUtil.responseTransaction((VeSPagueTransacao)veSPagueTransacao));
            } else {
                LOGGER.info("{}: {}", (Object)clientId, (Object)LogFormatterUtil.finalizeTransaction((VeSPagueTransacao)veSPagueTransacao));
            }
        }
        catch (Exception e) {
            LOGGER.error("erro ao formatar log de transacao", (Throwable)e);
        }
    }

    public static boolean isMensageTef(VeSPagueTransacao veSPagueTransacao) {
        return veSPagueTransacao.io_problem != null;
    }
}

