/*
 * Decompiled with CFR 0.152.
 */
package vespague.common.comm;

import java.io.Serializable;
import lib.comm.VBICommInterface;
import lib.comm.VeSComm;
import lib.comm.VeSCommAbstract;
import lib.comm.VeSCommSocket;
import lib.comm.structure.VeSCommServiceExecuted;
import lib.comm.structure.VeSCommServiceExecuting;
import lib.thread.VBIThread;

public class VeSCommClient
extends VeSCommAbstract {
    private String is_client;
    private static final String TRACE_CONFIGURATION = "<VeSTraceConfiguration><is_filename>VBICommClient</is_filename><ib_append>true</ib_append><in_file_size_maximum>65536</in_file_size_maximum></VeSTraceConfiguration>";
    private static final VeSComm.VeSCommException EXCEPTION_NOT_CONNECTED = new VeSComm.VeSCommNotConnectedException("Connection in progress ...");

    public VeSCommClient(String[] as_xml) {
        this(null, as_xml);
    }

    public VeSCommClient(String as_identifier, String[] as_xml) {
        this(as_identifier, as_xml, null);
    }

    public VeSCommClient(String as_identifier, String[] as_xml, VBICommInterface ao_interface) {
        super(as_xml, TRACE_CONFIGURATION, ao_interface);
        this.is_client = String.valueOf(this.is_address) + "(" + this.getClass().getName() + ")" + (as_identifier == null ? "" : "/" + as_identifier);
        this.io_exc_initialized = new VeSComm.VBICommDisconnectedException();
    }

    protected void finalize() {
        try {
            this.Disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void configureHostServer(String host, Integer port, Boolean certificateSelfSigned) {
        if (this.getComm() instanceof VeSCommSocket) {
            VeSCommSocket veSCommSocket = (VeSCommSocket)this.getComm();
            veSCommSocket.configureHost(host, port, certificateSelfSigned);
        }
    }

    public void Connect() throws VeSComm.VeSCommException, VeSComm.VeSCommAlreadyConnectedException {
        this.Initialized(false, (VeSComm.VeSCommException)((Object)new VeSComm.VeSCommAlreadyConnectedException()));
        this.getComm().Connect(null);
        this.Initialize();
        this.io_exc_initialized = EXCEPTION_NOT_CONNECTED;
    }

    public boolean Connected() {
        return super.Connected() && this.io_connections != null && this.io_connections.length == 1 && this.io_connections[0].Connected();
    }

    public final void Disconnect() throws VeSComm.VeSCommException, VeSComm.VBICommDisconnectedException {
        this.Initialized(true, (VeSComm.VeSCommException)((Object)new VeSComm.VBICommDisconnectedException()));
        try {
            this.io_connections[0].ObjectSend((Serializable)new VeSCommAbstract.VeSCommCommandExecuting(42405, (Object)this.is_client));
            this.Trace("ClientUnregister", null);
        }
        catch (VeSCommAbstract.VeSCommCommandInvalidException ex) {
            assert (false) : "Command invalid impossible !?!?!";
            ex.printStackTrace();
        }
        catch (VeSComm.VeSCommObjectInvalidException ex) {
            assert (false) : "Object invalid impossible !?!?!";
            ex.printStackTrace();
        }
        catch (VeSComm.VeSCommNotConnectedException veSCommNotConnectedException) {
            // empty catch block
        }
        this.Finalize();
        this.io_connections[0].DisconnectAll();
        this.io_exc_initialized = new VeSComm.VeSCommNotConnectedException();
    }

    protected final void CommandExecuted(VeSCommAbstract.VeSCommCommandExecuted ao_command) throws VeSCommAbstract.VeSCommCommandInvalidException, InterruptedException {
        assert (ao_command != null) : "Argument can't be null";
        switch (ao_command.getCommand()) {
            case 47821: {
                this.io_lbq_service_executed.put((VeSCommServiceExecuted)ao_command.getArgument());
                break;
            }
            case 42405: {
                if (ao_command.io_exception == null || ao_command.io_exception instanceof VeSCommAbstract.VeSCommServerNotStartedException) {
                    this.io_exc_initialized = new VeSComm.VeSCommNotConnectedException(String.valueOf(ao_command.io_exception == null ? "" : String.valueOf(ao_command.io_exception.getMessage()) + " - ") + "Reconnection in progress ...");
                } else {
                    this.Finalize();
                }
                this.Trace("ClientUnregister", this.io_exc_initialized.getMessage());
                break;
            }
            case 21845: {
                break;
            }
            default: {
                throw new VeSCommAbstract.VeSCommCommandInvalidException(ao_command.getCommand());
            }
        }
    }

    public final void ServiceExecuting(VeSCommServiceExecuting ao_service) throws VeSComm.VeSCommNotConnectedException, VeSComm.VeSCommException {
        try {
            this.Trace("ServiceExecuting", ao_service.toString());
            this.io_connections[0].ObjectSend((Serializable)new VeSCommAbstract.VeSCommCommandExecuting(47821, (Object)ao_service));
        }
        catch (VeSCommAbstract.VeSCommCommandInvalidException ex) {
            assert (false) : "Impossible !?!?!";
            ex.printStackTrace();
        }
    }

    public final VeSCommServiceExecuted ServiceExecuted(Long an_timeout) throws VeSComm.VeSCommNotConnectedException, VeSCommAbstract.VeSCommServiceInvalidException, VeSComm.VeSCommException, InterruptedException {
        VeSCommServiceExecuted lo_executed = null;
        try {
            lo_executed = super.ServiceExecuted(an_timeout);
        }
        catch (VeSComm.VeSCommNotConnectedException ex) {
            this.io_connections[0].ObjectSend((Serializable)new VeSCommAbstract.VeSCommCommandExecuting(21845));
            lo_executed = super.ServiceExecuted(an_timeout);
        }
        return lo_executed;
    }

    protected final void IdentifierSet(String as_identifier) {
        this.is_client = as_identifier;
    }

    public final String IdentifierGet() {
        return this.is_client;
    }

    protected final VBIThread ReceiverThreadCreate() {
        return new VBIThread("VBICommClient.Receive", true, false, true, true, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ VeSComm[] access$0(VeSCommClient veSCommClient) {
        return veSCommClient.io_connections;
    }

    static /* synthetic */ VeSComm.VeSCommException access$1(VeSCommClient veSCommClient) {
        return veSCommClient.io_exc_initialized;
    }

    static /* synthetic */ VeSComm.VeSCommException access$2() {
        return EXCEPTION_NOT_CONNECTED;
    }

    static /* synthetic */ void access$3(VeSCommClient veSCommClient, VeSComm.VeSCommException veSCommException) {
        veSCommClient.io_exc_initialized = veSCommException;
    }

    static /* synthetic */ void access$4(VeSCommClient veSCommClient, String string, String string2) {
        veSCommClient.Trace(string, string2);
    }
}

