/*
 * Decompiled with CFR 0.152.
 */
package vespague.common.graphic;

import image.VBIImage;
import java.time.Duration;
import lib.VeSUtil;
import lib.graphic.window.VeSWindowProgress;
import lib.thread.VBIThread;
import lib.type.VeSInteger;
import lib.type.VeSMethod;
import lib.type.VeSNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vespague.automation.VeSPagueClientToAutomation;
import vespague.client.device.VeSPaguePinpad;
import vespague.client.graphic.VeSPagueClient;
import vespague.client.interaction.VeSPagueClientTransactionManager;
import vespague.client.lib.graphic.window.ClientWindowQrcodeProgress;
import vespague.common.VeSPagueClientUtil;
import vespague.structure.VeSPagueTransacao;

public final class VSPagueCodigoBarraMostrar {
    private static final Logger LOGGER = LoggerFactory.getLogger(VSPagueCodigoBarraMostrar.class);
    private VeSWindowProgress io_window;
    private VBIThread thdContadorTela;
    private long contadorTimeout;
    private int tempoTotal;

    public VSPagueCodigoBarraMostrar(VeSPagueClientTransactionManager ao_transaction_manager, VeSInteger an_tempo, Boolean ab_cancell_transaction, VBIImage ao_qrcode_pinpad) throws Exception {
        LOGGER.debug("a");
        this.tempoTotal = an_tempo.intValue();
        VeSPagueTransacao lo_transacao = ao_transaction_manager.TransactionGet();
        LOGGER.debug("d");
        if (VeSPagueClient.VISIBLE) {
            this.io_window = new ClientWindowQrcodeProgress("Pagamento com Carteira Digital", "N\u00e3o feche esta janela!", ab_cancell_transaction, ao_qrcode_pinpad, lo_transacao.ih_codigo_barra, lo_transacao.in_codigo_barra, lo_transacao.is_codigo_barra);
            this.io_window.CloseQuestionSet("Deseja encerrar esta opera\u00e7\u00e3o de pagamento?");
        }
    }

    private void qrcodeExibir(VeSPagueClientTransactionManager transactionManager, VBIImage imagemQrcode) throws Exception {
        VeSPaguePinpad pinpad = transactionManager.io_client.PinpadGet();
        if (pinpad != null && pinpad.Connected() && imagemQrcode != null) {
            try {
                String nomeMedia = pinpad.MultimidiaCarregarApresentar(imagemQrcode.toByteArray(), "   LER QRCODE   \r   NO TERMINAL  ");
                if (nomeMedia != null) {
                    pinpad.MultimidiaExcluir(nomeMedia);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Erro de comunicacao com pinpad.", (Throwable)ex);
            }
        }
        VeSPagueTransacao transacao = transactionManager.TransactionGet();
        LOGGER.debug("d");
        if (!VeSPagueClient.VISIBLE) {
            LOGGER.debug("r");
            VeSPagueClientToAutomation sendAutomation = new VeSPagueClientToAutomation("");
            if (imagemQrcode == null) {
                sendAutomation.automacao_coleta_retorno = VeSPagueClientUtil.RETURN_CODE_ERROR_INDEFINED;
                sendAutomation.automacao_coleta_mensagem = new String[]{"SEM QRCODE PARA EXIBI\u00c7\u00c3O"};
            } else {
                sendAutomation.automacao_coleta_retorno = VeSPagueClientUtil.RETURN_CODE_SUCESS_CONFIRMATION;
                sendAutomation.automacao_coleta_mensagem_tipo = new String[]{"TXT", "PNG", transacao.is_codigo_barra == null ? null : "TXT"};
                sendAutomation.automacao_coleta_mensagem = new String[]{"QRCODE", VeSUtil.ByteToHexa((byte[])imagemQrcode.toByteArray()), transacao.is_codigo_barra == null ? null : transacao.is_codigo_barra};
            }
            transactionManager.io_client_to_server.io_client_automation_interaction.Send(sendAutomation, Integer.valueOf(this.tempoTotal * 1000), true, null);
            transactionManager.io_client_to_server.io_client_automation_interaction.RespostaAplicacaoComercialConsistir(sendAutomation.automacao_coleta_sequencial, VeSPagueClientUtil.RETURN_CODE_SUCESS_CONFIRMATION);
        } else {
            this.ThreadContadorTempoTela(new VeSInteger((long)this.tempoTotal));
        }
    }

    public final boolean Cancel() {
        LOGGER.debug("a");
        return this.io_window.Cancel();
    }

    public final void Run(VeSMethod ao_metodo, VeSPagueClientTransactionManager transactionManager, VBIImage imagemQrCode) throws VeSWindowProgress.VeSWindowProgressException, Exception {
        this.Run(ao_metodo, null, transactionManager, imagemQrCode);
    }

    public final void Run(VeSMethod ao_metodo, Object[] ao_object, VeSPagueClientTransactionManager transactionManager, VBIImage imagemQrCode) throws VeSWindowProgress.VeSWindowProgressException, Exception {
        block7: {
            this.qrcodeExibir(transactionManager, imagemQrCode);
            LOGGER.debug("a");
            if (VeSPagueClient.VISIBLE) {
                try {
                    this.io_window.MethodExecute(ao_metodo, ao_object);
                    this.io_window.CloseQuestionSet(null);
                    this.io_window.Cancel();
                    break block7;
                }
                finally {
                    if (this.thdContadorTela != null) {
                        this.thdContadorTela.Interrupt(null);
                    }
                }
            }
            ao_metodo.Invoke(ao_object);
        }
        LOGGER.debug("z");
    }

    private final void ThreadContadorTempoTela(VeSInteger an_time_tempo) {
        if (an_time_tempo.compareTo(0L) != 0) {
            this.thdContadorTela = new VBIThread("TimeQrCode", false, false, true, false, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
            this.thdContadorTela.Start();
        }
    }

    private final void OperatorTimerWait(VeSWindowProgress ao_window, VeSInteger an_timer) {
        try {
            LOGGER.debug("Iniciando contagem do tempo..");
            int ln_time = an_timer.intValue();
            while (ln_time > -1 && !ao_window.Canceled() && !Thread.currentThread().isInterrupted()) {
                Duration lo_tempo = Duration.ofSeconds(ln_time);
                long ln_min = lo_tempo.toMinutes();
                long ln_seg = lo_tempo.minusMinutes(ln_min).getSeconds();
                this.contadorTimeout = lo_tempo.toMillis();
                ao_window.ProgressMessageSet("Aguardando leitura do QRCode [" + VeSNumber.format((long)ln_min, (String)"00") + ":" + VeSNumber.format((long)ln_seg, (String)"00") + "]");
                Thread.sleep(1000L);
                --ln_time;
            }
            ao_window.ProgressMessageSet("Aguarde...");
        }
        catch (Exception ex) {
            LOGGER.debug("Erro ao fazer contagem do tempo", (Throwable)ex);
        }
    }

    public long getContadorTimeout() {
        return this.contadorTimeout;
    }

    public int getTempoTotal() {
        return this.tempoTotal;
    }

    static /* synthetic */ VeSWindowProgress access$0(VSPagueCodigoBarraMostrar vSPagueCodigoBarraMostrar) {
        return vSPagueCodigoBarraMostrar.io_window;
    }

    static /* synthetic */ void access$1(VSPagueCodigoBarraMostrar vSPagueCodigoBarraMostrar, VeSWindowProgress veSWindowProgress, VeSInteger veSInteger) {
        vSPagueCodigoBarraMostrar.OperatorTimerWait(veSWindowProgress, veSInteger);
    }
}

