/*
 * Decompiled with CFR 0.152.
 */
package vespague.common.graphic;

import java.awt.Color;
import java.awt.Component;
import java.math.BigInteger;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import lib.VeSVector;
import lib.database.VeSDatabaseSqlException;
import lib.graphic.VeSGui;
import lib.graphic.VeSLabel;
import lib.graphic.VeSPanel;
import lib.graphic.VeSTable;
import lib.graphic.VeSTextField;
import lib.graphic.window.VeSWindowChild;
import lib.type.VBIDatetime;
import lib.type.VBIPeriod;
import lib.type.VeSInteger;
import vespague.client.lib.graphic.window.VBIWindowMessage;

public abstract class VeSPagueWindowExpiration
extends VeSWindowChild {
    public static final int DATA_EXPIRACAO = 0;
    public static final int ESTABELECIMENTO = 1;
    private String is_text = null;
    private String is_text_default = "Todos os estabelecimentos e suas respectivas datas de expira\u00e7\u00e3o";
    private VeSTextField io_txf_legenda;
    private VeSLabel io_lbl_legenda;
    private JScrollPane io_sp_estabelecimento;
    private VBIPeriod io_period;
    private Object[][] io_ob_estabelecimento;
    private VeSTable io_tbl_estabelecimento;

    public VeSPagueWindowExpiration() {
        this("Estabelecimentos e Data de Expira\u00e7\u00e3o", null, null);
    }

    public VeSPagueWindowExpiration(String as_title, String as_text, VBIPeriod ao_period) {
        this(as_title, as_text, ao_period, false);
    }

    public VeSPagueWindowExpiration(String as_title, String as_text, VBIPeriod ao_period, boolean ab_automatic_expiration) {
        super(as_title, 5, 5, 420, 400, false, true, false, true, false);
        Object[][] objectArrayArray = new Object[2][];
        Object[] objectArray = new Object[7];
        objectArray[0] = "Data de Expira\u00e7\u00e3o";
        objectArray[1] = "Duplo clique para abrir o estabelecimento";
        objectArray[2] = false;
        objectArray[3] = 120;
        objectArray[5] = 0;
        objectArrayArray[0] = objectArray;
        Object[] objectArray2 = new Object[7];
        objectArray2[0] = "Estabelecimento";
        objectArray2[1] = "Duplo clique para abrir o estabelecimento";
        objectArray2[2] = false;
        objectArray2[3] = 210;
        objectArray2[5] = 2;
        objectArrayArray[1] = objectArray2;
        this.io_ob_estabelecimento = objectArrayArray;
        this.io_tbl_estabelecimento = new VeSTable(0, this.io_ob_estabelecimento);
        this.is_text = as_text;
        this.io_period = ao_period;
        this.TableLoad();
        this.TablePaint();
        if (this.io_tbl_estabelecimento.getRowCount() > 0) {
            this.WindowGUI();
            this.repaint();
        } else if (!ab_automatic_expiration) {
            VBIWindowMessage.Show((String)"ATEN\u00c7\u00c3O PARA A EXPIRA\u00c7\u00c3O", (Object)"N\u00e3o h\u00e1 nenhum estabelecimento cadastrado na base de dados.", (int)2, (Object[])VBIWindowMessage.OK_OPTIONS);
        } else {
            this.dispose();
        }
    }

    private void WindowGUI() {
        JEditorPane lo_editor = new JEditorPane();
        lo_editor.setBounds(5, 5, 350, 40);
        lo_editor.setBackground(this.io_ctn.getBackground());
        lo_editor.setEditable(false);
        lo_editor.setContentType("text/html");
        lo_editor.setText("<html><font face=\"Courier New\"><b>" + (this.is_text != null ? this.is_text : this.is_text_default) + "</b></font>" + "</html>");
        VeSPanel lo_panel = new VeSPanel();
        lo_panel.setBorder((Border)new TitledBorder(BorderFactory.createBevelBorder(1), null, 1, 2));
        lo_panel.setBounds(10, 10, 350, 50);
        lo_panel.add((Component)lo_editor);
        this.io_ctn.add((Component)lo_panel);
        this.io_sp_estabelecimento = new JScrollPane((Component)this.io_tbl_estabelecimento);
        this.io_sp_estabelecimento.setBounds(10, 70, 350, 270);
        this.io_ctn.add(this.io_sp_estabelecimento);
        this.io_txf_legenda = new VeSTextField();
        this.io_txf_legenda.setBounds(10, 350, 10, 10);
        this.io_txf_legenda.setBackground(VeSGui.COR_VERMELHO);
        this.io_ctn.add((Component)this.io_txf_legenda);
        this.io_lbl_legenda = new VeSLabel(25, 343, 200, 25, "<html><b>Estabelecimentos expirados</b></html>");
        this.io_ctn.add((Component)this.io_lbl_legenda);
        this.setVisible(true);
    }

    public abstract void TableLoad();

    public abstract VBIDatetime DatabaseDateCurrenGet() throws VeSDatabaseSqlException;

    public void TablePaint() {
        try {
            VBIDatetime ld_current_date = this.DatabaseDateCurrenGet();
            int ln_position = 0;
            int[] ln_line = new int[this.io_tbl_estabelecimento.getRowCount()];
            Color[] lc_color = new Color[this.io_tbl_estabelecimento.getRowCount()];
            int ln_1 = 0;
            while (ln_1 < this.io_tbl_estabelecimento.getRowCount()) {
                ln_line[ln_position++] = ln_1;
                lc_color[ln_1] = new VeSInteger(ld_current_date.toString("yyyyMMdd")).compareTo((BigInteger)new VeSInteger(new VBIDatetime(this.io_tbl_estabelecimento.getValueAt(ln_1, 0).toString(), "dd/MM/yyyy").toString("yyyyMMdd"))) > 0 ? VeSGui.COR_VERMELHO : VeSGui.COR_PRETO;
                ++ln_1;
            }
            this.io_tbl_estabelecimento.setForegroundLineColor(ln_line, lc_color);
            this.io_tbl_estabelecimento.repaint();
            this.io_tbl_estabelecimento.revalidate();
        }
        catch (VeSDatabaseSqlException ex) {
            VBIWindowMessage.ErrorShow(null, (Object)ex.getMessage());
        }
    }

    public VBIPeriod PeriodGet() {
        return this.io_period;
    }

    public VeSTable TableGet() {
        return this.io_tbl_estabelecimento;
    }

    public void setDataVector(VeSVector ao_vct_values) {
        this.io_tbl_estabelecimento.setDataVector((Vector)ao_vct_values);
        this.io_tbl_estabelecimento.repaint();
    }
}

