/*
 * Decompiled with CFR 0.152.
 */
package vespague.exception;

import lib.VBIMain;
import lib.type.VeSInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vespague.client.graphic.VeSPagueClient;
import vespague.client.lib.graphic.window.VBIWindowMessage;

public abstract class VSPagueClientWindowException {
    private static final Logger LOGGER = LoggerFactory.getLogger(VSPagueClientWindowException.class);

    public VSPagueClientWindowException(Throwable ao_throwable) {
        this(null, ao_throwable);
    }

    public VSPagueClientWindowException(String as_message, Throwable ao_throwable) {
        this(as_message, Boolean.valueOf(VeSPagueClient.VISIBLE), ao_throwable);
    }

    public VSPagueClientWindowException(String as_message, Boolean ab_visivel, Throwable ao_throwable) {
        this(null, as_message, ab_visivel, ao_throwable, VeSInteger.ZERO);
    }

    public VSPagueClientWindowException(String as_title, String as_message, Boolean ab_visivel, Throwable ao_throwable, VeSInteger an_timer_message) {
        LOGGER.error(as_message == null ? "erro durante o processamento" : as_message, ao_throwable);
        if (VBIMain.Graphic()) {
            String mensagem = this.getMessageOperator(as_message, ao_throwable);
            if (ab_visivel.booleanValue()) {
                VBIWindowMessage.Show((String)as_title, (Object)mensagem, (int)3, (Object[])VBIWindowMessage.OK_OPTIONS, (Object)an_timer_message);
            }
        }
    }

    protected String getMessageOperator(String message, Throwable exception) {
        if (message != null && !message.isEmpty()) {
            if (exception == null) {
                return message;
            }
            return String.valueOf(message) + "\n" + exception.getMessage();
        }
        if (exception == null) {
            return "Exce\u00e7\u00e3o durante o processamento da transa\u00e7\u00e3o";
        }
        if (exception.getCause() != null) {
            return exception.getCause().getMessage();
        }
        if (exception.getMessage() != null) {
            return exception.getMessage();
        }
        return exception.toString();
    }
}

