/*
 * Decompiled with CFR 0.152.
 */
package vespague.structure;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import lib.VeSUtil;
import lib.device.pinpad.VeSPinpadCompartilhado;
import lib.type.VBIDatetime;
import lib.type.VeSDecimal;
import lib.type.VeSInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vespague.client.device.VeSPaguePinpad;
import vespague.client.graphic.VeSPagueClient;
import vespague.common.VeSPagueBaseUtil;
import vespague.common.VeSPagueClientUtil;
import vespague.common.VeSPagueUtil;
import vespague.common.type.VeSCombination;
import vespague.structure.VSPagueConfiguracaoClient;
import vespague.structure.VeSPagueConfiguracaoClient;
import vespague.structure.VeSPagueConfiguracaoData;
import vespague.structure.VeSPagueConfiguracaoParametro;
import vespague.structure.VeSPagueConfiguracaoPesquisar;
import vespague.structure.VeSPaguePinpadStatistical;
import vespague.structure.VeSPagueTransacao;
import vespague.structure.VeSPagueValorLojaBitsConfiguracao;
import vespague.structure.VeSPagueValorLojaParametroConfiguracao;
import vespague.structure.VeSPagueValorLojaRedeConfiguracao;

public class VSPagueConfiguracaoClient
extends VeSPagueConfiguracaoClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(VSPagueConfiguracaoClient.class);

    public VSPagueConfiguracaoClient(VeSPagueConfiguracaoData veSPagueConfiguracaoData) throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        super(veSPagueConfiguracaoData);
        ArrayList<Integer> listaRedes = new ArrayList<Integer>();
        int i = 0;
        while (i < veSPagueConfiguracaoData.io_cfg_parametro.length) {
            listaRedes.add(i);
            ++i;
        }
        this.RedeIndexSet(listaRedes);
    }

    public VSPagueConfiguracaoClient(VeSPagueConfiguracaoParametro veSPagueConfiguracaoParametro) {
        super(veSPagueConfiguracaoParametro);
    }

    public void Back(int estado) throws IllegalArgumentException, VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        if (this.BitIndexGet().length != 0 && this.ParametrosIndexGet().length != 0 && estado >= 0 && estado <= this.in_estado_atual) {
            super.Back(estado);
        }
    }

    public void CartaoNumeroFiltrar(String cartaoNumero) throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        if (this.BitIndexGet() != null && this.BitIndexGet().length > 0) {
            super.CartaoNumeroFiltrar(cartaoNumero);
        }
    }

    public void CartaoNumeroParametroFiltrar(String cartaoNumero) throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        if (this.BitIndexGet() != null && this.BitIndexGet().length > 0) {
            super.CartaoNumeroParametroFiltrar(cartaoNumero);
        }
    }

    public boolean TransacaoNSUColetaVerificar() {
        if (this.BitIndexGet() != null && this.BitIndexGet().length > 0) {
            return super.TransacaoNSUColetaVerificar();
        }
        return VeSPagueClientUtil.TRANSACAO_TIPO_ADMINISTRACAO_REIMPRIMIR.equals(this.TransacaoGet().is_tipo) || VeSPagueClientUtil.TRANSACAO_TIPO_ADMINISTRACAO_CANCELAR.equals(this.TransacaoGet().is_tipo) || VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_CONFIRMAR.equals(this.TransacaoGet().is_tipo) || VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_PREAUTORIZACAO_ADICIONAR.equals(this.TransacaoGet().is_tipo) || VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_PREAUTORIZACAO_CAPTURAR.equals(this.TransacaoGet().is_tipo) || VeSPagueClientUtil.TRANSACAO_TIPO_TELEFONE_CONSULTAR.equals(this.TransacaoGet().is_tipo);
    }

    public boolean TransacaoValorColetaVerificar() {
        return !VeSPagueClientUtil.TRANSACAO_TIPO_ADMINISTRACAO_CARTAO_CONSULTAR.equals(this.TransacaoGet().is_tipo) && !VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_CONSULTAR_SALDO.equals(this.TransacaoGet().is_tipo) && !VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_SENHA_TROCAR.equals(this.TransacaoGet().is_tipo) && !VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_CONSULTAR_ENDERECO.equals(this.TransacaoGet().is_tipo);
    }

    public void TransacaoTipoFiltrar(Object tipoTransacao) throws IllegalArgumentException, VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        if (VeSPagueClientUtil.TRANSACAO_TIPO_ADMINISTRACAO_EXTRATO_GERAL.equals(tipoTransacao)) {
            return;
        }
        if (this.BitIndexGet() != null && this.BitIndexGet().length > 0) {
            super.TransacaoTipoFiltrar(tipoTransacao);
        }
    }

    public boolean TransacaoDinheiroValorColetaVerificar() throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoColetaCombinacao veSPagueConfiguracaoColetaCombinacao = new VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoColetaCombinacao(this.RedeIndexGet(), this.ConfiguracaoDataGet());
        int i = 0;
        while (i < this.BitIndexGet().length) {
            veSPagueConfiguracaoColetaCombinacao.Add(this.ConfiguracaoDataGet().io_cfg_parametro[this.BitIndexGet()[i][0]].io_valor_loja_bits[this.BitIndexGet()[i][1]].is_rede, 0, (Object)this.ConfiguracaoDataGet().io_cfg_parametro[this.BitIndexGet()[i][0]].io_valor_loja_bits[this.BitIndexGet()[i][1]].io_fluxos[this.BitIndexGet()[i][2]].valor_dinheiro.ib_collect);
            ++i;
        }
        if (this.ParametroObrigatorioVerificar()) {
            i = 0;
            while (i < this.ParametrosIndexGet().length) {
                veSPagueConfiguracaoColetaCombinacao.Add(this.ConfiguracaoDataGet().io_cfg_parametro[this.ParametrosIndexGet()[i][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[i][1]].is_rede, 1, (Object)this.ConfiguracaoDataGet().io_cfg_parametro[this.ParametrosIndexGet()[i][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[i][1]].ib_pagamento_dinheiro);
                ++i;
            }
        } else {
            int ln_1 = 0;
            while (ln_1 < this.RedeIndexGet().length) {
                veSPagueConfiguracaoColetaCombinacao.Add(this.ConfiguracaoDataGet().io_cfg_parametro[this.RedeIndexGet()[ln_1]].io_valor_loja_rede.is_rede, 1, (Object)true);
                ++ln_1;
            }
        }
        if (VeSPagueUtil.TRANSACAO_PRODUTO_TIPO_DINHEIRO.equals(this.io_transaction.is_transacao_produto)) {
            veSPagueConfiguracaoColetaCombinacao.Add(this.io_transaction.is_rede, 1, (Object)Boolean.TRUE);
        }
        try {
            return veSPagueConfiguracaoColetaCombinacao.Result() != VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoColetaCombinacao.RESULTADO_COLETA_IGNORADA;
        }
        catch (VeSCombination.VeSInvalidCombinationException veSInvalidCombinationException) {
            throw new VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException("Problemas ao verificar a coleta do campo 'Valor em Dinheiro'", (Throwable)veSInvalidCombinationException);
        }
    }

    public VeSDecimal TransacaoDinheiroValorMinimoGet() {
        Object valorPagamentoMinimo = null;
        if (this.ParametrosIndexGet().length > 0) {
            valorPagamentoMinimo = this.ConfiguracaoDataGet().io_cfg_parametro[this.ParametrosIndexGet()[0][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[0][1]].io_pagamento_dinheiro_valor_min;
            int i = 1;
            while (i < this.ParametrosIndexGet().length && valorPagamentoMinimo != null) {
                valorPagamentoMinimo = this.ConfiguracaoDataGet().io_cfg_parametro[this.ParametrosIndexGet()[i][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[i][1]].io_pagamento_dinheiro_valor_min != null ? (VeSDecimal)VeSUtil.min((Comparable)valorPagamentoMinimo, (Comparable)this.ConfiguracaoDataGet().io_cfg_parametro[this.ParametrosIndexGet()[i][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[i][1]].io_pagamento_dinheiro_valor_min) : null;
                ++i;
            }
        }
        return valorPagamentoMinimo;
    }

    public VeSDecimal TransacaoDinheiroValorMaximoGet() {
        Object valorPagamentoMaximo = null;
        if (this.ParametrosIndexGet().length > 0) {
            valorPagamentoMaximo = this.ConfiguracaoDataGet().io_cfg_parametro[this.ParametrosIndexGet()[0][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[0][1]].io_pagamento_dinheiro_valor_max;
            int i = 1;
            while (i < this.ParametrosIndexGet().length && valorPagamentoMaximo != null) {
                valorPagamentoMaximo = this.ConfiguracaoDataGet().io_cfg_parametro[this.ParametrosIndexGet()[i][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[i][1]].io_pagamento_dinheiro_valor_max != null ? (VeSDecimal)VeSUtil.min((Comparable)valorPagamentoMaximo, (Comparable)this.ConfiguracaoDataGet().io_cfg_parametro[this.ParametrosIndexGet()[i][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[i][1]].io_pagamento_dinheiro_valor_max) : null;
                ++i;
            }
        }
        return valorPagamentoMaximo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void TransacaoDinheiroValorFiltrar(VeSDecimal transacaoValor) throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        ArrayList<int[]> listBitsIndex = new ArrayList<int[]>();
        boolean coletado = transacaoValor != null;
        int ln_index = 0;
        while (ln_index < this.BitIndexGet().length) {
            if (this.ConfiguracaoDataGet().io_cfg_parametro[this.BitIndexGet()[ln_index][0]].io_valor_loja_bits[this.BitIndexGet()[ln_index][1]].io_fluxos[this.BitIndexGet()[ln_index][2]].valor_dinheiro.ib_collect == coletado) {
                listBitsIndex.add(this.BitIndexGet()[ln_index]);
            }
            ++ln_index;
        }
        if (listBitsIndex.isEmpty()) throw new VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException("N\u00e3o h\u00e1 BITs para continuar a transa\u00e7\u00e3o.");
        int[][] arrayBitsIndex = new int[listBitsIndex.size()][];
        listBitsIndex.toArray((T[])arrayBitsIndex);
        if (coletado && !this.ContaPagamentoDinheiro()) {
            listBitsIndex.clear();
            if (this.ParametroObrigatorioVerificar()) {
                int ln = 0;
                while (ln < this.ParametrosIndexGet().length) {
                    if (!(this.ConfiguracaoDataGet().io_cfg_parametro[this.ParametrosIndexGet()[ln][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[ln][1]].io_pagamento_dinheiro_valor_max != null && transacaoValor.compareTo((BigDecimal)this.ConfiguracaoDataGet().io_cfg_parametro[this.ParametrosIndexGet()[ln][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[ln][1]].io_pagamento_dinheiro_valor_max) > 0 || this.ConfiguracaoDataGet().io_cfg_parametro[this.ParametrosIndexGet()[ln][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[ln][1]].io_pagamento_dinheiro_valor_min != null && transacaoValor.compareTo((BigDecimal)this.ConfiguracaoDataGet().io_cfg_parametro[this.ParametrosIndexGet()[ln][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[ln][1]].io_pagamento_dinheiro_valor_min) < 0)) {
                        listBitsIndex.add(this.ParametrosIndexGet()[ln]);
                    }
                    ++ln;
                }
                if (listBitsIndex.isEmpty()) throw new VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException("N\u00e3o h\u00e1 PAR\u00c2METROs para continuar a transa\u00e7\u00e3o.");
                this.ParametrosIndexSet((int[][])new int[listBitsIndex.size()][]);
                listBitsIndex.toArray((T[])this.ParametrosIndexGet());
            }
        }
        this.BitIndexSet((int[][])arrayBitsIndex);
        this.EstadoProximoIr();
    }

    public boolean TransacaoDataOriginalColetaVerificar() throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        if (this.BitIndexGet() != null && this.BitIndexGet().length > 0) {
            return super.TransacaoDataOriginalColetaVerificar();
        }
        return VeSPagueClientUtil.TRANSACAO_TIPO_ADMINISTRACAO_REIMPRIMIR.equals(this.TransacaoGet().is_tipo) || VeSPagueClientUtil.TRANSACAO_TIPO_ADMINISTRACAO_CANCELAR.equals(this.TransacaoGet().is_tipo) || VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_CONFIRMAR.equals(this.TransacaoGet().is_tipo) || VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_PREAUTORIZACAO_ADICIONAR.equals(this.TransacaoGet().is_tipo) || VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_PREAUTORIZACAO_CAPTURAR.equals(this.TransacaoGet().is_tipo);
    }

    public boolean TransacaoConsultaLogVerificar() {
        return this.io_transaction.is_tipo.equals(VeSPagueUtil.TRANSACAO_TIPO_ADMINISTRACAO_CANCELAR) && this.io_transaction.in_valor_original != null || this.io_transaction.is_tipo.equals(VeSPagueUtil.TRANSACAO_TIPO_ADMINISTRACAO_REIMPRIMIR) && this.io_transaction.in_nsu_original != null || this.io_transaction.is_tipo.equals(VeSPagueUtil.TRANSACAO_TIPO_CARTAO_CONFIRMAR) && this.io_transaction.in_nsu_original != null;
    }

    public boolean TransacaoValorOriginalColetaVerificar() {
        return this.TransacaoGet() != null && (!VeSPagueClientUtil.TRANSACAO_TIPO_ADMINISTRACAO_REIMPRIMIR.equals(this.TransacaoGet().is_tipo) || VeSPagueClientUtil.TRANSACAO_TIPO_ADMINISTRACAO_CANCELAR.equals(this.TransacaoGet().is_tipo));
    }

    public Object[] ProdutoDisponivelGet(VeSPaguePinpad veSPaguePinpad) throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        List<Object> listProdutosDisponiveis;
        HashSet<String> bitsProdutos = new HashSet<String>();
        HashSet<String> parametrosProdutos = new HashSet<String>();
        boolean parametroUsar = false;
        if (veSPaguePinpad != null && veSPaguePinpad.in_cartao_tipo != null && veSPaguePinpad.in_cartao_rede_adquirente != null && veSPaguePinpad.in_cartao_registro_indice != null && (VeSPinpadCompartilhado.CARTAO_TIPO_EMV.compareTo((BigInteger)veSPaguePinpad.in_cartao_tipo) == 0 || VeSPinpadCompartilhado.CARTAO_TIPO_TIBC_V1.compareTo((BigInteger)veSPaguePinpad.in_cartao_tipo) == 0 || VeSPinpadCompartilhado.CARTAO_TIPO_TIBC_V3.compareTo((BigInteger)veSPaguePinpad.in_cartao_tipo) == 0 || VeSPinpadCompartilhado.CARTAO_TIPO_EASY_ENTRY.compareTo((BigInteger)veSPaguePinpad.in_cartao_tipo) == 0 || VeSPinpadCompartilhado.CARTAO_TIPO_EMV_CONTACTLESS.compareTo((BigInteger)veSPaguePinpad.in_cartao_tipo) == 0)) {
            int redeIndex = this.EMVIndexToNet(veSPaguePinpad.in_cartao_rede_adquirente.intValue(), veSPaguePinpad.in_cartao_registro_indice.intValue());
            int aidIndex = this.AIDIndexToArrayIndex(redeIndex, veSPaguePinpad.in_cartao_registro_indice.intValue());
            this.TransacaoRedeFiltrar((Object)this.ConfiguracaoDataGet().io_cfg_parametro[redeIndex].io_valor_loja_rede.is_rede);
            this.io_transaction.TransacaoCartaoGet().ib_offline_rejeitada_enviar = this.ConfiguracaoDataGet().io_cfg_parametro[redeIndex].io_valor_loja_rede.io_chip[aidIndex].ib_rejeitada_host_enviar != null && this.ConfiguracaoDataGet().io_cfg_parametro[redeIndex].io_valor_loja_rede.io_chip[aidIndex].ib_rejeitada_host_enviar != false;
        }
        VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoColetaCombinacao veSPagueConfiguracaoColetaCombinacao = new VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoColetaCombinacao(this.RedeIndexGet(), this.ConfiguracaoDataGet());
        int bitsIndex = 0;
        while (bitsIndex < this.BitIndexGet().length) {
            parametroUsar = parametroUsar ? parametroUsar : this.ConfiguracaoDataGet().io_cfg_parametro[this.BitIndexGet()[bitsIndex][0]].io_valor_loja_bits[this.BitIndexGet()[bitsIndex][1]].ib_parametro_obrigatorio_usar == null || this.ConfiguracaoDataGet().io_cfg_parametro[this.BitIndexGet()[bitsIndex][0]].io_valor_loja_bits[this.BitIndexGet()[bitsIndex][1]].ib_parametro_obrigatorio_usar != false;
            veSPagueConfiguracaoColetaCombinacao.Add(this.ConfiguracaoDataGet().io_cfg_parametro[this.BitIndexGet()[bitsIndex][0]].io_valor_loja_bits[this.BitIndexGet()[bitsIndex][1]].is_rede, 0, (Object)this.ConfiguracaoDataGet().io_cfg_parametro[this.BitIndexGet()[bitsIndex][0]].io_valor_loja_bits[this.BitIndexGet()[bitsIndex][1]].io_fluxos[this.BitIndexGet()[bitsIndex][2]].produto_rede.ib_collect);
            if (this.ConfiguracaoDataGet().io_cfg_parametro[this.BitIndexGet()[bitsIndex][0]].io_valor_loja_bits[this.BitIndexGet()[bitsIndex][1]].io_fluxos[this.BitIndexGet()[bitsIndex][2]].produto_rede.ib_collect) {
                bitsProdutos.add(String.valueOf(VeSPagueUtil.ProdutoGet((VeSPagueValorLojaBitsConfiguracao)this.ConfiguracaoDataGet().io_cfg_parametro[this.BitIndexGet()[bitsIndex][0]].io_valor_loja_bits[this.BitIndexGet()[bitsIndex][1]])) + "-" + this.ConfiguracaoDataGet().io_cfg_parametro[this.BitIndexGet()[bitsIndex][0]].io_valor_loja_bits[this.BitIndexGet()[bitsIndex][1]].is_rede);
            }
            ++bitsIndex;
        }
        if (parametroUsar && this.TransacaoGet().TransacaoCartaoGet() != null && this.TransacaoGet().TransacaoCartaoGet().is_cartao_numero != null) {
            String cartaoNumero = new VeSInteger(this.TransacaoGet().TransacaoCartaoGet().is_cartao_numero).toString();
            HashSet<String> bandeiraValorLojaParametro = new HashSet<String>();
            int parametroIndex = 0;
            while (parametroIndex < this.ParametrosIndexGet().length) {
                VeSInteger cartaoBin;
                VeSPagueValorLojaParametroConfiguracao valorLojaParametroConfiguracao = this.ConfiguracaoDataGet().io_cfg_parametro[this.ParametrosIndexGet()[parametroIndex][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[parametroIndex][1]];
                VeSInteger veSInteger = cartaoBin = this.TransacaoGet().TransacaoCartaoGet().is_cartao_numero.length() > valorLojaParametroConfiguracao.in_bin_de.length() ? new VeSInteger(cartaoNumero.substring(0, valorLojaParametroConfiguracao.in_bin_de.length())) : new VeSInteger(cartaoNumero);
                if (cartaoBin.compareTo((BigInteger)valorLojaParametroConfiguracao.in_bin_de) >= 0 && cartaoBin.compareTo((BigInteger)valorLojaParametroConfiguracao.in_bin_ate) <= 0 && !bitsProdutos.isEmpty() && bitsProdutos.contains(String.valueOf(valorLojaParametroConfiguracao.is_produto) + "-" + valorLojaParametroConfiguracao.is_rede)) {
                    bandeiraValorLojaParametro.add(valorLojaParametroConfiguracao.is_administradora);
                    parametrosProdutos.add(String.valueOf(valorLojaParametroConfiguracao.is_produto) + "-" + valorLojaParametroConfiguracao.is_rede);
                }
                veSPagueConfiguracaoColetaCombinacao.Add(valorLojaParametroConfiguracao.is_rede, 1, (Object)(valorLojaParametroConfiguracao.is_produto != null && VeSPagueUtil.TRANSACAO_TIPO_ADMINISTRACAO_CANCELAR.equals(this.io_transaction.is_tipo) && VeSPagueUtil.TRANSACAO_TIPO_CONTA_PAGAR.equals(this.io_transaction.is_tipo_original) ? false : valorLojaParametroConfiguracao.is_produto != null));
                ++parametroIndex;
            }
            LOGGER.debug("Bandeiras encontradas na configuracao de BINs {}", (Object)Arrays.toString(bandeiraValorLojaParametro.toArray()));
            LOGGER.debug("Produtos Bits encontrados {}", (Object)Arrays.toString(bitsProdutos.toArray()));
            LOGGER.debug("Produtos Parametros encontrados {}", (Object)Arrays.toString(parametrosProdutos.toArray()));
            listProdutosDisponiveis = Arrays.asList(parametrosProdutos.toArray());
        } else {
            int redeIndex = 0;
            while (redeIndex < this.RedeIndexGet().length) {
                veSPagueConfiguracaoColetaCombinacao.Add(this.ConfiguracaoDataGet().io_cfg_parametro[this.RedeIndexGet()[redeIndex]].io_valor_loja_rede.is_rede, 1, (Object)Boolean.TRUE);
                ++redeIndex;
            }
            listProdutosDisponiveis = Arrays.asList(bitsProdutos.toArray());
        }
        try {
            boolean coletar = veSPagueConfiguracaoColetaCombinacao.Result() != VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoColetaCombinacao.RESULTADO_COLETA_IGNORADA;
            Collections.sort(listProdutosDisponiveis, so_ordenador);
            Object[] arrayProdutosDisponiveis = listProdutosDisponiveis.toArray();
            boolean consistir = true;
            if (!coletar) {
                if (arrayProdutosDisponiveis.length > 1) {
                    consistir = false;
                }
            } else if (arrayProdutosDisponiveis.length < 1) {
                consistir = false;
            }
            if (consistir) {
                return arrayProdutosDisponiveis;
            }
            throw new VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException("N\u00e3o h\u00e1 produto dispon\u00edvel para esta transa\u00e7\u00e3o.");
        }
        catch (VeSCombination.VeSInvalidCombinationException veSInvalidCombinationException) {
            throw new VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException("Problemas na verifica\u00e7\u00e3o de op\u00e7\u00f5es para a lista 'Produto'.", (Throwable)veSInvalidCombinationException);
        }
    }

    public boolean CartaoNumeroColetaVerificar() throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        if (VeSPagueUtil.TRANSACAO_TIPO_ADMINISTRACAO_CANCELAR.equals(this.io_transaction.is_tipo) && VeSPagueUtil.TRANSACAO_TIPO_DIGITAL_PAGAR.equals(this.io_transaction.is_tipo_original)) {
            return false;
        }
        return this.TransacaoGet().TransacaoCartaoGet() != null;
    }

    public boolean ImpressaoComprovanteVerificar() throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        if (this.BitIndexGet() != null && this.BitIndexGet().length > 0) {
            return super.ImpressaoComprovanteVerificar();
        }
        return true;
    }

    public void TransacaoCancelamentoFiltrarBits(VeSPagueTransacao veSPagueTransacao) throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        if (this.BitIndexGet().length > 0) {
            super.TransacaoCancelamentoFiltrarBits(veSPagueTransacao);
        }
    }

    protected void ParametrosBitsInterseccionar() throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        if (this.RedeIndexGet() != null && this.ParametrosIndexGet() != null) {
            Object result;
            VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoRelacaoCombinacao veSPagueConfiguracaoRelacaoCombinacao = new VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoRelacaoCombinacao(this.RedeIndexGet(), this.io_cfg_data);
            String RESULTPARAMETROOBRIGATORIO = "uso obrigat\u00f3rio dos par\u00e2metros";
            String RESULTPARAMETROINDEFINIDO = "uso indefinido dos par\u00e2metros";
            String RESULTPARAMETRONAOUSADO = "n\u00e3o uso dos par\u00e2metros";
            1 veSPagueConfiguracaoCombinacao = new /* Unavailable Anonymous Inner Class!! */;
            this.io_bits_index_manager.ArrayIndexLoop((VeSPagueConfiguracaoPesquisar.ArrayIndexLoopInteraction)new /* Unavailable Anonymous Inner Class!! */, true);
            if (this.ParametrosIndexGet().length != 0) {
                this.io_parametro_index_manager.ArrayIndexLoop((VeSPagueConfiguracaoPesquisar.ArrayIndexLoopInteraction)new /* Unavailable Anonymous Inner Class!! */, false);
            }
            try {
                result = veSPagueConfiguracaoCombinacao.Result();
            }
            catch (VeSCombination.VeSInvalidCombinationException veSInvalidCombinationException) {
                throw new VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException((Throwable)veSInvalidCombinationException);
            }
            if (result != RESULTPARAMETRONAOUSADO) {
                this.io_bits_index_manager.ArrayIndexLoop((VeSPagueConfiguracaoPesquisar.ArrayIndexLoopInteraction)new /* Unavailable Anonymous Inner Class!! */, false);
                this.io_bits_index_manager.Commit(true);
            }
            this.io_parametro_index_manager.Commit(false);
        }
    }

    public String RedeNomeCapturar() {
        if (this.BitIndexGet().length == 0) {
            return "";
        }
        return super.RedeNomeCapturar();
    }

    public Set CartaoEntradaTipoDisponivel(String rede, String redeVersao) throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        if (this.BitIndexGet() == null || this.BitIndexGet().length == 0) {
            HashSet entradas = new HashSet(VeSPagueClientUtil.TRANSACAO_ENTRADA_GRUPO.values());
            boolean entradaChip = Arrays.stream(this.io_cfg_data.io_cfg_parametro).anyMatch(redeConfiguracao -> redeConfiguracao.io_valor_loja_rede.io_configuracao.ib_entrada_chip == null || redeConfiguracao.io_valor_loja_rede.io_configuracao.ib_entrada_chip != false);
            boolean entradaContactless = Arrays.stream(this.io_cfg_data.io_cfg_parametro).anyMatch(redeConfiguracao -> redeConfiguracao.io_valor_loja_rede.io_chip != null && Arrays.stream(redeConfiguracao.io_valor_loja_rede.io_chip).anyMatch(chip -> chip.ib_contactless != null && chip.ib_contactless != false));
            boolean entradaCodigoBarras = Arrays.stream(this.io_cfg_data.io_cfg_parametro).anyMatch(redeConfiguracao -> redeConfiguracao.io_valor_loja_rede.io_configuracao.ib_entrada_codigo_barras != null && redeConfiguracao.io_valor_loja_rede.io_configuracao.ib_entrada_codigo_barras != false);
            boolean entradaDigitado = Arrays.stream(this.io_cfg_data.io_cfg_parametro).anyMatch(redeConfiguracao -> redeConfiguracao.io_valor_loja_rede.io_configuracao.ib_entrada_digitado == null || redeConfiguracao.io_valor_loja_rede.io_configuracao.ib_entrada_digitado != false);
            boolean entradaMagnetico = Arrays.stream(this.io_cfg_data.io_cfg_parametro).anyMatch(redeConfiguracao -> redeConfiguracao.io_valor_loja_rede.io_configuracao.ib_entrada_magnetico == null || redeConfiguracao.io_valor_loja_rede.io_configuracao.ib_entrada_magnetico != false);
            if (!entradaChip) {
                entradas.remove("Circuito Integrado");
            }
            if (!entradaContactless) {
                entradas.remove("Contactless");
            }
            if (!entradaDigitado) {
                entradas.remove("Digitado");
            }
            if (!entradaMagnetico) {
                entradas.remove("Magn\u00e9tico");
            }
            if (!entradaCodigoBarras) {
                entradas.remove("C\u00f3digo de Barras");
            }
            return entradas;
        }
        return super.CartaoEntradaTipoDisponivel(rede, redeVersao);
    }

    public Set<Object> CartaoEntradaTipoDisponivel() throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        if (this.BitIndexGet() == null || this.BitIndexGet().length == 0) {
            return this.CartaoEntradaTipoDisponivel(null, null);
        }
        return super.CartaoEntradaTipoDisponivel();
    }

    public void TipoCartaoFiltrar(String tipoCartao) throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        if (this.BitIndexGet().length != 0 && this.ParametrosIndexGet().length != 0) {
            super.TipoCartaoFiltrar(tipoCartao);
        }
    }

    protected int EstadoProximoIr(boolean interseccaoBitsParametros) throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        if (!(this.BitIndexGet() != null && this.BitIndexGet().length != 0 || this.ParametrosIndexGet() != null && this.ParametrosIndexGet().length != 0)) {
            return 0;
        }
        return super.EstadoProximoIr(this.ParametrosIndexGet().length > 0);
    }

    public String[] TransacaoTipoCartaoColetaVerificar() {
        if (this.BitIndexGet() == null || this.BitIndexGet().length == 0) {
            if (VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_CONSULTAR_SALDO.equals(this.TransacaoGet().is_tipo)) {
                return new String[]{VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_DEBITO};
            }
            if (VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_CONSULTAR_ENDERECO.equals(this.TransacaoGet().is_tipo)) {
                return new String[]{VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_CREDITO};
            }
            ArrayList<String> listatipoCartao = new ArrayList<String>();
            listatipoCartao.add(VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_CREDITO);
            listatipoCartao.add(VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_DEBITO);
            listatipoCartao.add(VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_VOUCHER);
            return listatipoCartao.toArray(new String[0]);
        }
        return super.TransacaoTipoCartaoColetaVerificar();
    }

    public Object[] findListaPagamento(String cartaoTipo) {
        if (this.BitIndexGet() == null || this.BitIndexGet().length == 0) {
            if (VeSPagueClientUtil.TRANSACAO_TIPO_DIGITAL_PAGAR.equals(this.TransacaoGet().is_tipo) || VeSPagueClientUtil.TRANSACAO_TIPO_TELEFONE_RECARREGAR.equals(this.TransacaoGet().is_tipo) || VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_PAGAR.equals(this.TransacaoGet().is_tipo) || VeSPagueClientUtil.TRANSACAO_TIPO_CONTA_PAGAR.equals(this.TransacaoGet().is_tipo)) {
                return new Object[]{VeSPagueClientUtil.TRANSACAO_PAGAMENTO_A_VISTA};
            }
            if (VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_CONSULTAR_FINANCIADO.equals(this.TransacaoGet().is_tipo)) {
                return new Object[]{VeSPagueClientUtil.TRANSACAO_PAGAMENTO_PARCELADO};
            }
            ArrayList<String> listaPagamento = new ArrayList<String>();
            listaPagamento.add(VeSPagueClientUtil.TRANSACAO_PAGAMENTO_A_VISTA);
            if (VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_DEBITO.equals(cartaoTipo)) {
                boolean isPreDatado;
                boolean isCrediario;
                boolean isParcelar = Arrays.stream(this.io_cfg_data.io_cfg_parametro).anyMatch(veSPagueConfiguracaoParametro -> veSPagueConfiguracaoParametro.io_valor_loja_rede.io_configuracao.ib_debito_parcelar != null && veSPagueConfiguracaoParametro.io_valor_loja_rede.io_configuracao.ib_debito_parcelar != false);
                if (isParcelar) {
                    listaPagamento.add(VeSPagueClientUtil.TRANSACAO_PAGAMENTO_PARCELADO);
                }
                if (isCrediario = Arrays.stream(this.io_cfg_data.io_cfg_parametro).anyMatch(veSPagueConfiguracaoParametro -> veSPagueConfiguracaoParametro.io_valor_loja_rede.io_configuracao.ib_crediario != null && veSPagueConfiguracaoParametro.io_valor_loja_rede.io_configuracao.ib_crediario != false)) {
                    listaPagamento.add(VeSPagueClientUtil.TRANSACAO_PAGAMENTO_CREDIARIO);
                }
                if (isPreDatado = Arrays.stream(this.io_cfg_data.io_cfg_parametro).anyMatch(veSPagueConfiguracaoParametro -> veSPagueConfiguracaoParametro.io_valor_loja_rede.io_configuracao.ib_debito_predatado != null && veSPagueConfiguracaoParametro.io_valor_loja_rede.io_configuracao.ib_debito_predatado != false)) {
                    listaPagamento.add(VeSPagueClientUtil.TRANSACAO_PAGAMENTO_PRE_DATADO);
                }
            } else if (VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_CREDITO.equals(cartaoTipo)) {
                boolean isNotParcelar;
                boolean isCrediario = Arrays.stream(this.io_cfg_data.io_cfg_parametro).anyMatch(veSPagueConfiguracaoParametro -> veSPagueConfiguracaoParametro.io_valor_loja_rede.io_configuracao.ib_transacao_crediario != null && veSPagueConfiguracaoParametro.io_valor_loja_rede.io_configuracao.ib_transacao_crediario != false);
                if (isCrediario) {
                    listaPagamento.add(VeSPagueClientUtil.TRANSACAO_PAGAMENTO_CREDIARIO);
                }
                if (!(isNotParcelar = Arrays.stream(this.io_cfg_data.io_cfg_parametro).anyMatch(veSPagueConfiguracaoParametro -> veSPagueConfiguracaoParametro.io_valor_loja_rede.io_configuracao.ib_credito_parcelar != null && veSPagueConfiguracaoParametro.io_valor_loja_rede.io_configuracao.ib_credito_parcelar == false))) {
                    listaPagamento.add(VeSPagueClientUtil.TRANSACAO_PAGAMENTO_PARCELADO);
                }
            }
            return listaPagamento.toArray(new Object[0]);
        }
        return super.findListaPagamento(cartaoTipo);
    }

    public Object[] findListaFinanciado() {
        if (VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_CONSULTAR_FINANCIADO.equals(this.TransacaoGet().is_tipo)) {
            return new Object[]{VeSPagueClientUtil.TRANSACAO_FINANCIADO_ADMINISTRADORA};
        }
        ArrayList<String> listaFinanciado = new ArrayList<String>();
        listaFinanciado.add(VeSPagueClientUtil.TRANSACAO_FINANCIADO_ESTABELECIMENTO);
        listaFinanciado.add(VeSPagueClientUtil.TRANSACAO_FINANCIADO_ADMINISTRADORA);
        return listaFinanciado.toArray(new Object[0]);
    }

    public void TransacaoProdutoBitsFiltrar(boolean ab_coletar) throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        if (this.BitIndexGet() != null && this.BitIndexGet().length > 0) {
            super.TransacaoProdutoBitsFiltrar(ab_coletar);
        }
    }

    public void TransacaoTipoContaParametroFiltrar() throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        if (this.BitIndexGet() != null && this.BitIndexGet().length > 0) {
            super.TransacaoTipoContaParametroFiltrar();
        }
    }

    public boolean isRoteamentoNataxa() {
        return true;
    }

    public String[] getTiposPagamentos() {
        boolean isNotPIX = Arrays.stream(this.io_cfg_data.io_cfg_parametro).anyMatch(veSPagueConfiguracaoParametro -> veSPagueConfiguracaoParametro.io_valor_loja_rede.io_configuracao.isPagamentoPIX != null && veSPagueConfiguracaoParametro.io_valor_loja_rede.io_configuracao.isPagamentoPIX == false);
        boolean isNotCarteiraDigital = Arrays.stream(this.io_cfg_data.io_cfg_parametro).anyMatch(veSPagueConfiguracaoParametro -> veSPagueConfiguracaoParametro.io_valor_loja_rede.io_configuracao.isPagamentoCarteiraDigital != null && veSPagueConfiguracaoParametro.io_valor_loja_rede.io_configuracao.isPagamentoCarteiraDigital == false);
        LinkedHashSet<String> mapaTiposPagamentosOrdenado = new LinkedHashSet<String>();
        mapaTiposPagamentosOrdenado.add(VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_CREDITO);
        mapaTiposPagamentosOrdenado.add(VeSPagueClientUtil.TRANSACAO_CARTAO_TIPO_DEBITO);
        if (!isNotPIX) {
            mapaTiposPagamentosOrdenado.add("PIX");
        }
        if (!isNotCarteiraDigital) {
            mapaTiposPagamentosOrdenado.add("Carteira Digital");
        }
        return mapaTiposPagamentosOrdenado.toArray(new String[0]);
    }

    public boolean isColetaTransacaoPagamento() {
        if (VeSPagueClientUtil.TRANSACAO_TIPO_ADMINISTRACAO_CARTAO_CONSULTAR.equals(this.TransacaoGet().is_tipo) || VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_CONSULTAR_SALDO.equals(this.TransacaoGet().is_tipo) || VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_SENHA_TROCAR.equals(this.TransacaoGet().is_tipo) || VeSPagueClientUtil.TRANSACAO_TIPO_TELEFONE_CONSULTAR.equals(this.TransacaoGet().is_tipo) || VeSPagueClientUtil.TRANSACAO_TIPO_REDE_STATUS_CONSULTAR.equals(this.TransacaoGet().is_tipo) || VeSPagueClientUtil.TRANSACAO_TIPO_CARTAO_CONSULTAR_ENDERECO.equals(this.TransacaoGet().is_tipo)) {
            return false;
        }
        return super.isColetaTransacaoPagamento();
    }

    public void TransacaoConsultaLogFiltrar(boolean ab_consult) throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        if (this.BitIndexGet() != null && this.BitIndexGet().length > 0) {
            super.TransacaoConsultaLogFiltrar(ab_consult);
        }
    }

    public VBIDatetime CartaoDataValidadeFiltrar(VBIDatetime cartaoValidade) throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        boolean coletado;
        boolean validadeOk = coletado = cartaoValidade != null;
        if (coletado && this.CartaoDataValidadeConsistir() && !this.RedeNomeCapturar().equals(VeSPagueBaseUtil.TRANSACAO_REDE_CIELO)) {
            this.CartaoValidadeConsistir(cartaoValidade, false);
        }
        ArrayList<int[]> bitsIndex = new ArrayList<int[]>();
        boolean parametroUser = false;
        int i = 0;
        while (i < this.BitIndexGet().length) {
            if (!parametroUser) {
                boolean bl = parametroUser = this.io_cfg_data.io_cfg_parametro[this.BitIndexGet()[i][0]].io_valor_loja_bits[this.BitIndexGet()[i][1]].ib_parametro_obrigatorio_usar == null || this.io_cfg_data.io_cfg_parametro[this.BitIndexGet()[i][0]].io_valor_loja_bits[this.BitIndexGet()[i][1]].ib_parametro_obrigatorio_usar != false;
            }
            if (this.io_cfg_data.io_cfg_parametro[this.BitIndexGet()[i][0]].io_valor_loja_bits[this.BitIndexGet()[i][1]].io_fluxos[this.BitIndexGet()[i][2]].cartao_validade.ib_collect == coletado) {
                bitsIndex.add(this.BitIndexGet()[i]);
            }
            ++i;
        }
        if (!bitsIndex.isEmpty()) {
            int[][] arrayBitsIndex = new int[bitsIndex.size()][];
            bitsIndex.toArray((T[])arrayBitsIndex);
            bitsIndex.clear();
            String ls_cartao_entrada = this.io_transaction.TransacaoCartaoGet().is_entrada;
            if (coletado && parametroUser && !this.ContaPagamentoDinheiro()) {
                int i2 = 0;
                while (i2 < this.ParametrosIndexGet().length) {
                    if (!coletado && (ls_cartao_entrada == "Circuito Integrado" && (this.io_cfg_data.io_cfg_parametro[this.ParametrosIndexGet()[i2][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[i2][1]].ib_cartao_chip_validade_digitar == null || this.io_cfg_data.io_cfg_parametro[this.ParametrosIndexGet()[i2][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[i2][1]].ib_cartao_chip_validade_digitar == coletado) || ls_cartao_entrada == "Magn\u00e9tico" && (this.io_cfg_data.io_cfg_parametro[this.ParametrosIndexGet()[i2][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[i2][1]].ib_cartao_lido_validade_digitar == null || this.io_cfg_data.io_cfg_parametro[this.ParametrosIndexGet()[i2][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[i2][1]].ib_cartao_lido_validade_digitar == coletado) || ls_cartao_entrada == "Digitado" && (this.io_cfg_data.io_cfg_parametro[this.ParametrosIndexGet()[i2][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[i2][1]].ib_cartao_digitado_validade_digitar == null || this.io_cfg_data.io_cfg_parametro[this.ParametrosIndexGet()[i2][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[i2][1]].ib_cartao_digitado_validade_digitar == coletado)) || validadeOk || ls_cartao_entrada == "Digitado" && this.io_cfg_data.io_cfg_parametro[this.ParametrosIndexGet()[i2][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[i2][1]].ib_cartao_validade_digitado_verificar != null && this.io_cfg_data.io_cfg_parametro[this.ParametrosIndexGet()[i2][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[i2][1]].ib_cartao_validade_digitado_verificar == false || ls_cartao_entrada == "Magn\u00e9tico" && this.io_cfg_data.io_cfg_parametro[this.ParametrosIndexGet()[i2][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[i2][1]].ib_cartao_validade_lido_verificar != null && this.io_cfg_data.io_cfg_parametro[this.ParametrosIndexGet()[i2][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[i2][1]].ib_cartao_validade_lido_verificar == false || ls_cartao_entrada == "Circuito Integrado" && this.io_cfg_data.io_cfg_parametro[this.ParametrosIndexGet()[i2][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[i2][1]].ib_cartao_validade_chip_verificar != null && !this.io_cfg_data.io_cfg_parametro[this.ParametrosIndexGet()[i2][0]].io_valor_loja_parametro[this.ParametrosIndexGet()[i2][1]].ib_cartao_validade_chip_verificar.booleanValue()) {
                        bitsIndex.add(this.ParametrosIndexGet()[i2]);
                    }
                    ++i2;
                }
                if (!bitsIndex.isEmpty()) {
                    this.ParametrosIndexSet((int[][])new int[bitsIndex.size()][]);
                    bitsIndex.toArray((T[])this.ParametrosIndexGet());
                } else {
                    throw new VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException("N\u00e3o h\u00e1 PAR\u00c2METROS para continuar a transa\u00e7\u00e3o.");
                }
            }
            this.BitIndexSet((int[][])arrayBitsIndex);
            this.EstadoProximoIr();
            return cartaoValidade;
        }
        throw new VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException("N\u00e3o h\u00e1 mapa de BITs para continuar a transa\u00e7\u00e3o.");
    }

    public VeSInteger[] getAcquirerEMVIdentifyList() {
        TreeMap<VeSInteger, VeSInteger> emvPrioridade = new TreeMap<VeSInteger, VeSInteger>();
        int[] redeIndex = this.RedeIndexGet();
        VeSPagueConfiguracaoData veSPagueConfiguracaoData = this.ConfiguracaoDataGet();
        int i = 0;
        while (i < redeIndex.length) {
            if (veSPagueConfiguracaoData.io_cfg_parametro[redeIndex[i]].io_valor_loja_rede.io_configuracao.in_emv_identificacao != null && veSPagueConfiguracaoData.io_cfg_parametro[redeIndex[i]].io_valor_loja_rede.io_configuracao.in_emv_identificacao.compareTo((BigInteger)VeSInteger.ZERO) > 0 && !emvPrioridade.containsValue(veSPagueConfiguracaoData.io_cfg_parametro[redeIndex[i]].io_valor_loja_rede.io_configuracao.in_emv_identificacao)) {
                emvPrioridade.put(veSPagueConfiguracaoData.io_cfg_parametro[redeIndex[i]].io_valor_loja_rede.in_prioridade != null ? veSPagueConfiguracaoData.io_cfg_parametro[redeIndex[i]].io_valor_loja_rede.in_prioridade : (veSPagueConfiguracaoData.io_cfg_parametro[redeIndex[i]].io_valor_loja_rede.io_configuracao.ib_entrada_contactless != null && veSPagueConfiguracaoData.io_cfg_parametro[redeIndex[i]].io_valor_loja_rede.io_configuracao.ib_entrada_contactless != false ? new VeSInteger(2147383647L).subtract((long)i) : new VeSInteger(Integer.MAX_VALUE).subtract((long)i)), veSPagueConfiguracaoData.io_cfg_parametro[redeIndex[i]].io_valor_loja_rede.io_configuracao.in_emv_identificacao);
            }
            ++i;
        }
        return emvPrioridade.values().toArray(new VeSInteger[0]);
    }

    public VBIDatetime[] PinpadRedeVersaoGet() throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        if (this.ConfiguracaoDataGet().getVersaoCargaTabelas() != null) {
            VBIDatetime[] tabelaVersao = new VBIDatetime[this.getMapaRedeIndice().size()];
            int i = 0;
            while (i < this.RedeIndexGet().length) {
                VeSInteger ln_rede_index = this.ConfiguracaoDataGet().io_cfg_parametro[this.RedeIndexGet()[i]].io_valor_loja_rede.io_configuracao.in_emv_identificacao;
                if (ln_rede_index != null) {
                    tabelaVersao[ln_rede_index.intValue()] = this.ConfiguracaoDataGet().getVersaoCargaTabelas();
                }
                ++i;
            }
            return tabelaVersao;
        }
        return super.PinpadRedeVersaoGet();
    }

    public boolean CartaoChipDataValidadeConsistir() throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        if (this.ParametrosIndexGet() != null && this.ParametrosIndexGet().length > 0) {
            return super.CartaoChipDataValidadeConsistir();
        }
        return false;
    }

    public Object ConfiguracaoCombinacaoResult(Object conbinacao) throws VeSCombination.VeSInvalidCombinationException {
        if (this.getParametroUsar() && this.ParametrosIndexGet().length > 0) {
            return super.ConfiguracaoCombinacaoResult(conbinacao);
        }
        return VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoColetaCombinacao.RESULTADO_COLETA_IGNORADA;
    }

    public VeSPagueConfiguracaoClient getState() {
        VeSPagueConfiguracaoData veSPagueConfiguracaoData = new VeSPagueConfiguracaoData();
        veSPagueConfiguracaoData.is_cfg_comunicacao = this.ConfiguracaoDataGet().is_cfg_comunicacao;
        veSPagueConfiguracaoData.setLayout(this.ConfiguracaoDataGet().getLayout());
        veSPagueConfiguracaoData.is_cfg_estabelecimento = this.ConfiguracaoDataGet().is_cfg_estabelecimento;
        veSPagueConfiguracaoData.io_lst_device = this.ConfiguracaoDataGet().io_lst_device;
        veSPagueConfiguracaoData.io_cfg_loja = this.ConfiguracaoDataGet().io_cfg_loja;
        veSPagueConfiguracaoData.io_cfg_conciliacao = this.ConfiguracaoDataGet().io_cfg_conciliacao;
        veSPagueConfiguracaoData.io_cfg_application_identifier = this.ConfiguracaoDataGet().io_cfg_application_identifier;
        veSPagueConfiguracaoData.ib_rede_menor_taxa = this.ConfiguracaoDataGet().ib_rede_menor_taxa;
        veSPagueConfiguracaoData.io_cfg_terminal = this.ConfiguracaoDataGet().io_cfg_terminal;
        veSPagueConfiguracaoData.in_bits_index = (int[][])this.BitIndexGet().clone();
        veSPagueConfiguracaoData.in_parametros_index = (int[][])this.ParametrosIndexGet().clone();
        veSPagueConfiguracaoData.io_cfg_parametro = (VeSPagueConfiguracaoParametro[])this.ConfiguracaoDataGet().io_cfg_parametro.clone();
        VSPagueConfiguracaoClient vsPagueConfiguracaoClient = null;
        try {
            vsPagueConfiguracaoClient = new VSPagueConfiguracaoClient(veSPagueConfiguracaoData);
        }
        catch (VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException e) {
            LOGGER.error("erro ao criar estado de datastore", (Throwable)e);
            return null;
        }
        vsPagueConfiguracaoClient.RedeIndexSet(this.RedeIndexGet());
        vsPagueConfiguracaoClient.io_transaction = this.io_transaction.clone();
        vsPagueConfiguracaoClient.is_formas_pagamentos = this.is_formas_pagamentos;
        vsPagueConfiguracaoClient.setFinanciador(this.getFinanciador());
        return vsPagueConfiguracaoClient;
    }

    public void stateRecovery(VeSPagueConfiguracaoClient veSPagueConfiguracaoClient) {
        this.io_transaction = veSPagueConfiguracaoClient.io_transaction;
        this.io_transaction.is_tipo_original = veSPagueConfiguracaoClient.io_transaction.is_tipo_original;
        this.RedeIndexSet(veSPagueConfiguracaoClient.RedeIndexGet());
        try {
            this.ConfiguracaoUpdate(veSPagueConfiguracaoClient.io_cfg_data);
        }
        catch (Exception ex) {
            LOGGER.error("erro ao recuperar o estado do datastore.", (Throwable)ex);
        }
    }

    public String[] TransacaoHabilitadaVerificar(String tipoTransacao, String cartaoEntrada) {
        return new String[]{tipoTransacao, cartaoEntrada};
    }

    public Object[] ContaRedeDisponivelGet() {
        if (this.ParametrosIndexGet() != null && this.ParametrosIndexGet().length > 0) {
            return super.ContaRedeDisponivelGet();
        }
        ArrayList<String> redesDisponiveis = new ArrayList<String>();
        int i = 0;
        while (i < this.RedeIndexGet().length) {
            VeSPagueValorLojaRedeConfiguracao veSPagueValorLojaRedeConfiguracao = this.io_cfg_data.io_cfg_parametro[this.RedeIndexGet()[i]].io_valor_loja_rede;
            if (veSPagueValorLojaRedeConfiguracao != null) {
                redesDisponiveis.add(veSPagueValorLojaRedeConfiguracao.is_rede);
            }
            ++i;
        }
        return redesDisponiveis.toArray(new Object[0]);
    }

    public Object[] TransacaoPagamentoTipoValorGet() throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        if (this.ParametrosIndexGet() != null && this.ParametrosIndexGet().length > 0) {
            return super.TransacaoPagamentoTipoValorGet();
        }
        HashSet<String> listaPagarCom = new HashSet<String>();
        listaPagarCom.add(VeSPagueBaseUtil.TRANSACAO_VALOR_TIPO_CARTAO);
        listaPagarCom.add(VeSPagueBaseUtil.TRANSACAO_VALOR_TIPO_CHEQUE);
        listaPagarCom.add(VeSPagueBaseUtil.TRANSACAO_VALOR_TIPO_DINHEIRO);
        Object[] lo_return = listaPagarCom.toArray();
        Arrays.sort(lo_return);
        return lo_return;
    }

    public void TransacaoFinalizar(VeSPagueClient veSPagueClient, VeSPaguePinpad veSPaguePinpad, boolean ab_sequencial_alimentar) throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        boolean sequencialFluxoBits = ab_sequencial_alimentar;
        if (VeSPagueClientUtil.TRANSACAO_TIPO_ADMINISTRACAO_EXTRATO_GERAL.equals(this.TransacaoGet().is_tipo)) {
            sequencialFluxoBits = false;
        }
        super.TransacaoFinalizar(veSPagueClient, veSPaguePinpad, sequencialFluxoBits);
    }

    public boolean TransacaoConsultaMoedaVerificar(String tipoTransacao, String cartaoEntrada, String tipoCartao, String pagamento) {
        return true;
    }

    public void CartaoEntradaTipoFiltrar(String as_cartao_entrada, VeSPaguePinpadStatistical ao_statistical_section, boolean ab_cartao_chip_presenca, VeSPinpadCompartilhado ao_dv_pinpad) throws VeSPagueConfiguracaoPesquisar.VeSPagueConfiguracaoPesquisarException {
        if (this.ParametrosIndexGet() != null && this.ParametrosIndexGet().length > 0) {
            super.CartaoEntradaTipoFiltrar(as_cartao_entrada, ao_statistical_section, ab_cartao_chip_presenca, ao_dv_pinpad);
        }
    }
}

