/*
 * Decompiled with CFR 0.152.
 */
package vespague.structure;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import vespague.client.graphic.VeSPagueClient;
import vespague.common.VSPagueVersion;
import vespague.common.VeSPagueVersao;

public class VSPagueMavenConfiguration
implements VSPagueVersion {
    private static final Logger LOGGER = LoggerFactory.getLogger(VSPagueMavenConfiguration.class);
    private final String version;
    private final String groupId;
    private final String artifactId;
    private final String applicationName;
    private final String applicationTitle;

    public VSPagueMavenConfiguration(String applicationName, String applicationTitle) throws Exception {
        Hashtable pomProperties = this.getTagXml(new String[]{"version", "groupId", "artifactId"});
        this.version = (String)pomProperties.get("version");
        this.groupId = (String)pomProperties.get("groupId");
        this.artifactId = (String)pomProperties.get("artifactId");
        this.applicationName = applicationName;
        this.applicationTitle = applicationTitle;
    }

    public String getVersion() {
        return this.version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    private Hashtable<String, String> getTagXml(String ... tags) throws Exception {
        String pomPath = "META-INF/maven/br.com.dtx/vspague-client/pom.xml";
        InputStream inputStream = VeSPagueClient.class.getClassLoader().getResourceAsStream(pomPath);
        if (inputStream == null) {
            pomPath = "pom.xml";
            inputStream = Files.newInputStream(Paths.get(pomPath, new String[0]), new OpenOption[0]);
        }
        LOGGER.debug("Carregando informacao da versao do diretorio: {}", (Object)pomPath);
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document document = builder.parse(inputStream);
        Hashtable<String, String> stringMap = new Hashtable<String, String>();
        Element element = document.getDocumentElement();
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            NodeList node = element.getElementsByTagName(tag);
            if (node.getLength() > 0) {
                stringMap.put(tag, node.item(0).getTextContent());
            }
            ++n2;
        }
        return stringMap;
    }

    public VeSPagueVersao toVeSPagueVersao() {
        String applicationVersion;
        String vbiVersion = applicationVersion = this.getVersion();
        int indexVbiVersion = applicationVersion.indexOf("-");
        if (indexVbiVersion > 0) {
            vbiVersion = applicationVersion.substring(0, indexVbiVersion);
        }
        return new VeSPagueVersao(this.applicationName, this.applicationTitle, vbiVersion, applicationVersion);
    }
}

